/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.emitter.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.java.util.emitter.core.Emitter;
import org.apache.hive.druid.io.druid.java.util.emitter.core.LoggingEmitter;
import org.apache.hive.druid.io.druid.java.util.emitter.factory.EmitterFactory;
import org.asynchttpclient.AsyncHttpClient;

public class Emitters {
    private static final Logger log = new Logger(Emitters.class);
    private static final String LOG_EMITTER_PROP = "org.apache.hive.druid.io.druid.java.util.emitter.logging";
    private static final String HTTP_EMITTER_PROP = "org.apache.hive.druid.io.druid.java.util.emitter.http";
    private static final String CUSTOM_EMITTER_TYPE_PROP = "org.apache.hive.druid.io.druid.java.util.emitter.type";

    public static Emitter create(Properties props, AsyncHttpClient httpClient, Lifecycle lifecycle) {
        return Emitters.create(props, httpClient, new ObjectMapper(), lifecycle);
    }

    public static Emitter create(Properties props, AsyncHttpClient httpClient, ObjectMapper jsonMapper, Lifecycle lifecycle) {
        Map<Object, Object> jsonified = Maps.newHashMap();
        if (props.getProperty(LOG_EMITTER_PROP) != null) {
            jsonified = Emitters.makeLoggingMap(props);
            jsonified.put("type", "logging");
        } else if (props.getProperty(HTTP_EMITTER_PROP) != null) {
            jsonified = Emitters.makeHttpMap(props);
            jsonified.put("type", "http");
        } else if (props.getProperty(CUSTOM_EMITTER_TYPE_PROP) != null) {
            jsonified = Emitters.makeCustomFactoryMap(props);
        } else {
            throw new ISE("Unknown type of emitter. Please set [%s], [%s] or provide registered subtype of io.druid.java.util.emitter.core.factory.EmitterFactory via [%s]", LOG_EMITTER_PROP, HTTP_EMITTER_PROP, CUSTOM_EMITTER_TYPE_PROP);
        }
        return jsonMapper.convertValue(jsonified, EmitterFactory.class).makeEmitter(jsonMapper, httpClient, lifecycle);
    }

    static Map<String, Object> makeHttpMap(Properties props) {
        HashMap<String, Object> httpMap = Maps.newHashMap();
        String urlProperty = "org.apache.hive.druid.io.druid.java.util.emitter.http.url";
        String baseUrl = props.getProperty("org.apache.hive.druid.io.druid.java.util.emitter.http.url");
        if (baseUrl == null) {
            throw new IAE("Property[%s] must be set", "org.apache.hive.druid.io.druid.java.util.emitter.http.url");
        }
        httpMap.put("recipientBaseUrl", baseUrl);
        httpMap.put("flushMillis", Long.parseLong(props.getProperty("org.apache.hive.druid.io.druid.java.util.emitter.flushMillis", "60000")));
        httpMap.put("flushCount", Integer.parseInt(props.getProperty("org.apache.hive.druid.io.druid.java.util.emitter.flushCount", "300")));
        httpMap.put("flushTimeOut", Long.parseLong(props.getProperty("org.apache.hive.druid.io.druid.java.util.emitter.http.flushTimeOut", String.valueOf(Long.MAX_VALUE))));
        if (props.containsKey("org.apache.hive.druid.io.druid.java.util.emitter.http.basicAuthentication")) {
            httpMap.put("basicAuthentication", props.getProperty("org.apache.hive.druid.io.druid.java.util.emitter.http.basicAuthentication"));
        }
        if (props.containsKey("org.apache.hive.druid.io.druid.java.util.emitter.http.batchingStrategy")) {
            httpMap.put("batchingStrategy", StringUtils.toUpperCase(props.getProperty("org.apache.hive.druid.io.druid.java.util.emitter.http.batchingStrategy")));
        }
        if (props.containsKey("org.apache.hive.druid.io.druid.java.util.emitter.http.maxBatchSize")) {
            httpMap.put("maxBatchSize", Integer.parseInt(props.getProperty("org.apache.hive.druid.io.druid.java.util.emitter.http.maxBatchSize")));
        }
        if (props.containsKey("org.apache.hive.druid.io.druid.java.util.emitter.http.batchQueueSizeLimit")) {
            httpMap.put("batchQueueSizeLimit", Integer.parseInt(props.getProperty("org.apache.hive.druid.io.druid.java.util.emitter.http.batchQueueSizeLimit")));
        }
        if (props.containsKey("org.apache.hive.druid.io.druid.java.util.emitter.http.httpTimeoutAllowanceFactor")) {
            httpMap.put("httpTimeoutAllowanceFactor", Float.valueOf(Float.parseFloat(props.getProperty("org.apache.hive.druid.io.druid.java.util.emitter.http.httpTimeoutAllowanceFactor"))));
        }
        if (props.containsKey("org.apache.hive.druid.io.druid.java.util.emitter.http.minHttpTimeoutMillis")) {
            httpMap.put("minHttpTimeoutMillis", Float.valueOf(Float.parseFloat(props.getProperty("org.apache.hive.druid.io.druid.java.util.emitter.http.minHttpTimeoutMillis"))));
        }
        return httpMap;
    }

    static Map<String, Object> makeLoggingMap(Properties props) {
        HashMap<String, Object> loggingMap = Maps.newHashMap();
        loggingMap.put("loggerClass", props.getProperty("org.apache.hive.druid.io.druid.java.util.emitter.logging.class", LoggingEmitter.class.getName()));
        loggingMap.put("logLevel", props.getProperty("org.apache.hive.druid.io.druid.java.util.emitter.logging.level", "debug"));
        return loggingMap;
    }

    static Map<String, Object> makeCustomFactoryMap(Properties props) {
        HashMap<String, Object> factoryMap = Maps.newHashMap();
        String prefix = "org.apache.hive.druid.io.druid.java.util.emitter.";
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(prefix)) continue;
            String combinedKey = key.substring(prefix.length());
            Map<String, Object> currentLevelJson = factoryMap;
            Object currentKey = null;
            String[] keyPath = combinedKey.split("\\.");
            for (int i = 0; i < keyPath.length - 1; ++i) {
                String keyPart = keyPath[i];
                Object nextLevelJson = currentLevelJson.get(keyPart);
                if (nextLevelJson == null) {
                    nextLevelJson = new HashMap();
                    currentLevelJson.put(keyPart, nextLevelJson);
                }
                currentLevelJson = (Map)nextLevelJson;
            }
            currentLevelJson.put(keyPath[keyPath.length - 1], entry.getValue());
        }
        return factoryMap;
    }
}

