/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.io.druid.collections.NonBlockingPool;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.query.ColumnSelectorPlus;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorUtil;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.topn.BaseTopNAlgorithm;
import org.apache.hive.druid.io.druid.query.topn.DimValHolder;
import org.apache.hive.druid.io.druid.query.topn.PooledTopNAlgorithm;
import org.apache.hive.druid.io.druid.query.topn.TopNAlgorithm;
import org.apache.hive.druid.io.druid.query.topn.TopNParams;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryBuilder;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryMetrics;
import org.apache.hive.druid.io.druid.query.topn.TopNResultBuilder;
import org.apache.hive.druid.io.druid.segment.Capabilities;
import org.apache.hive.druid.io.druid.segment.Cursor;

public class AggregateTopNMetricFirstAlgorithm
implements TopNAlgorithm<int[], TopNParams> {
    private final Capabilities capabilities;
    private final TopNQuery query;
    private final NonBlockingPool<ByteBuffer> bufferPool;

    public AggregateTopNMetricFirstAlgorithm(Capabilities capabilities, TopNQuery query, NonBlockingPool<ByteBuffer> bufferPool) {
        this.capabilities = capabilities;
        this.query = query;
        this.bufferPool = bufferPool;
    }

    @Override
    public TopNParams makeInitParams(ColumnSelectorPlus selectorPlus, Cursor cursor) {
        return new TopNParams(selectorPlus, cursor, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TopNParams params, TopNResultBuilder resultBuilder, int[] ints, @Nullable TopNQueryMetrics queryMetrics) {
        String metric = this.query.getTopNMetricSpec().getMetricName(this.query.getDimensionSpec());
        Pair<List<AggregatorFactory>, List<PostAggregator>> condensedAggPostAggPair = AggregatorUtil.condensedAggregators(this.query.getAggregatorSpecs(), this.query.getPostAggregatorSpecs(), metric);
        if (((List)condensedAggPostAggPair.lhs).isEmpty() && ((List)condensedAggPostAggPair.rhs).isEmpty()) {
            throw new ISE("WTF! Can't find the metric to do topN over?", new Object[0]);
        }
        TopNQuery singleMetricQuery = new TopNQueryBuilder(this.query).aggregators((List)condensedAggPostAggPair.lhs).postAggregators((List)condensedAggPostAggPair.rhs).build();
        TopNResultBuilder singleMetricResultBuilder = BaseTopNAlgorithm.makeResultBuilder(params, singleMetricQuery);
        PooledTopNAlgorithm singleMetricAlgo = new PooledTopNAlgorithm(this.capabilities, singleMetricQuery, this.bufferPool);
        PooledTopNAlgorithm.PooledTopNParams singleMetricParam = null;
        int[] dimValSelector = null;
        try {
            singleMetricParam = singleMetricAlgo.makeInitParams((ColumnSelectorPlus)params.getSelectorPlus(), params.getCursor());
            singleMetricAlgo.run(singleMetricParam, singleMetricResultBuilder, null, null);
            dimValSelector = this.getDimValSelectorForTopNMetric(singleMetricParam, singleMetricResultBuilder);
            singleMetricAlgo.cleanup(singleMetricParam);
        }
        catch (Throwable throwable) {
            singleMetricAlgo.cleanup(singleMetricParam);
            throw throwable;
        }
        PooledTopNAlgorithm allMetricAlgo = new PooledTopNAlgorithm(this.capabilities, this.query, this.bufferPool);
        PooledTopNAlgorithm.PooledTopNParams allMetricsParam = null;
        try {
            allMetricsParam = allMetricAlgo.makeInitParams((ColumnSelectorPlus)params.getSelectorPlus(), params.getCursor());
            allMetricAlgo.run(allMetricsParam, resultBuilder, dimValSelector, queryMetrics);
            allMetricAlgo.cleanup(allMetricsParam);
        }
        catch (Throwable throwable) {
            allMetricAlgo.cleanup(allMetricsParam);
            throw throwable;
        }
    }

    @Override
    public void cleanup(TopNParams params) {
    }

    private int[] getDimValSelectorForTopNMetric(TopNParams params, TopNResultBuilder resultBuilder) {
        if (params.getCardinality() < 0) {
            throw new UnsupportedOperationException("Cannot operate on a dimension with unknown cardinality");
        }
        int[] dimValSelector = new int[params.getCardinality()];
        Arrays.fill(dimValSelector, -2);
        Iterator<DimValHolder> dimValIter = resultBuilder.getTopNIterator();
        while (dimValIter.hasNext()) {
            int dimValIndex = (Integer)dimValIter.next().getDimValIndex();
            dimValSelector[dimValIndex] = -1;
        }
        return dimValSelector;
    }
}

