/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.emitter;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.java.util.emitter.service.AlertBuilder;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;

public class EmittingLogger
extends Logger {
    private static volatile ServiceEmitter emitter = null;
    private final String className;

    public static void registerEmitter(ServiceEmitter emitter) {
        Preconditions.checkNotNull(emitter);
        EmittingLogger.emitter = emitter;
    }

    public EmittingLogger(String className) {
        super(className);
        this.className = className;
    }

    public EmittingLogger(Class clazz) {
        super(clazz);
        this.className = clazz.getName();
    }

    public AlertBuilder makeAlert(String message, Object ... objects) {
        return this.makeAlert(null, message, objects);
    }

    public AlertBuilder makeAlert(Throwable t, String message, Object ... objects) {
        if (emitter == null) {
            String errorMessage = StringUtils.format("Emitter not initialized!  Cannot alert.  Please make sure to call %s.registerEmitter()", this.getClass());
            this.error(errorMessage, new Object[0]);
            throw new ISE(errorMessage, new Object[0]);
        }
        AlertBuilder retVal = new EmittingAlertBuilder(t, StringUtils.format(message, objects), emitter).addData("class", this.className);
        if (t != null) {
            StringWriter trace = new StringWriter();
            PrintWriter pw = new PrintWriter(trace);
            t.printStackTrace(pw);
            retVal.addData("exceptionType", t.getClass());
            retVal.addData("exceptionMessage", t.getMessage());
            retVal.addData("exceptionStackTrace", trace.toString());
        }
        return retVal;
    }

    public class EmittingAlertBuilder
    extends AlertBuilder {
        private final Throwable t;
        private volatile boolean emitted;

        private EmittingAlertBuilder(Throwable t, String description, ServiceEmitter emitter) {
            super(description, emitter);
            this.emitted = false;
            this.t = t;
        }

        @Override
        public void emit() {
            this.logIt("%s: %s");
            this.emitted = true;
            super.emit();
        }

        protected void finalize() throws Throwable {
            if (!this.emitted) {
                this.logIt("Alert not emitted, emitting. %s: %s");
                super.emit();
            }
        }

        private void logIt(String format) {
            if (this.t == null) {
                EmittingLogger.this.error(format, this.description, this.dataMap);
            } else {
                EmittingLogger.this.error(this.t, format, this.description, Maps.filterKeys(this.dataMap, Predicates.not(Predicates.equalTo("exceptionStackTrace"))));
            }
        }
    }
}

