/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.timeline.partition;

import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Range;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.timeline.partition.LinearPartitionChunk;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpecLookup;

public class LinearShardSpec
implements ShardSpec {
    private int partitionNum;

    @JsonCreator
    public LinearShardSpec(@JsonProperty(value="partitionNum") Integer partitionNum) {
        this.partitionNum = Preconditions.checkNotNull(partitionNum, "Must set partitionNum on LinearShardSpec");
    }

    @Override
    @JsonProperty(value="partitionNum")
    public int getPartitionNum() {
        return this.partitionNum;
    }

    @Override
    public ShardSpecLookup getLookup(final List<ShardSpec> shardSpecs) {
        return new ShardSpecLookup(){

            @Override
            public ShardSpec getShardSpec(long timestamp, InputRow row) {
                return (ShardSpec)shardSpecs.get(0);
            }
        };
    }

    @Override
    public Map<String, Range<String>> getDomain() {
        return ImmutableMap.of();
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        return new LinearPartitionChunk<T>(this.partitionNum, obj);
    }

    @Override
    public boolean isInChunk(long timestamp, InputRow inputRow) {
        return true;
    }

    public String toString() {
        return "LinearShardSpec{partitionNum=" + this.partitionNum + '}';
    }
}

