/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.common.utils.ByteUtils;
import org.apache.hive.druid.io.druid.io.Channels;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.data.ColumnarInts;
import org.apache.hive.druid.io.druid.segment.data.WritableSupplier;
import org.apache.hive.druid.io.druid.segment.serde.MetaSerdeHelper;
import org.apache.hive.druid.io.druid.segment.writeout.HeapByteBufferWriteOutBytes;

public class VSizeColumnarInts
implements ColumnarInts,
Comparable<VSizeColumnarInts>,
WritableSupplier<ColumnarInts> {
    public static final byte VERSION = 0;
    private static final MetaSerdeHelper<VSizeColumnarInts> metaSerdeHelper = MetaSerdeHelper.firstWriteByte(x -> 0).writeByte(x -> ByteUtils.checkedCast(x.numBytes)).writeInt(x -> x.buffer.remaining());
    private final ByteBuffer buffer;
    private final int numBytes;
    private final int bitsToShift;
    private final int size;

    public static VSizeColumnarInts fromArray(int[] array) {
        return VSizeColumnarInts.fromArray(array, Ints.max(array));
    }

    public static VSizeColumnarInts fromArray(int[] array, int maxValue) {
        return VSizeColumnarInts.fromList(IntArrayList.wrap(array), maxValue);
    }

    public static VSizeColumnarInts fromList(IntList list, int maxValue) {
        byte numBytes = VSizeColumnarInts.getNumBytesForMax(maxValue);
        ByteBuffer buffer = ByteBuffer.allocate(list.size() * numBytes + (4 - numBytes));
        VSizeColumnarInts.writeToBuffer(buffer, list, numBytes, maxValue);
        return new VSizeColumnarInts(buffer.asReadOnlyBuffer(), numBytes);
    }

    private static void writeToBuffer(ByteBuffer buffer, IntList list, int numBytes, int maxValue) {
        ByteBuffer helperBuffer = ByteBuffer.allocate(4);
        for (int i = 0; i < list.size(); ++i) {
            int val = list.getInt(i);
            if (val < 0) {
                throw new IAE("integer values must be positive, got[%d], i[%d]", val, i);
            }
            if (val > maxValue) {
                throw new IAE("val[%d] > maxValue[%d], please don't lie about maxValue.  i[%d]", val, maxValue, i);
            }
            helperBuffer.putInt(0, val);
            buffer.put(helperBuffer.array(), 4 - numBytes, numBytes);
        }
        buffer.position(0);
    }

    public static byte getNumBytesForMax(int maxValue) {
        if (maxValue < 0) {
            throw new IAE("maxValue[%s] must be positive", maxValue);
        }
        if (maxValue <= 255) {
            return 1;
        }
        if (maxValue <= 65535) {
            return 2;
        }
        if (maxValue <= 0xFFFFFF) {
            return 3;
        }
        return 4;
    }

    public VSizeColumnarInts(ByteBuffer buffer, int numBytes) {
        this.buffer = buffer;
        this.numBytes = numBytes;
        this.bitsToShift = 32 - (numBytes << 3);
        int numBufferBytes = 4 - numBytes;
        this.size = (buffer.remaining() - numBufferBytes) / numBytes;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int get(int index) {
        return this.buffer.getInt(this.buffer.position() + index * this.numBytes) >>> this.bitsToShift;
    }

    public int getNumBytesNoPadding() {
        return this.buffer.remaining() - (4 - this.numBytes);
    }

    public void writeBytesNoPaddingTo(HeapByteBufferWriteOutBytes out) {
        ByteBuffer toWrite = this.buffer.slice();
        toWrite.limit(toWrite.limit() - (4 - this.numBytes));
        out.write(toWrite);
    }

    @Override
    public int compareTo(VSizeColumnarInts o) {
        int retVal = Ints.compare(this.numBytes, o.numBytes);
        if (retVal == 0) {
            retVal = this.buffer.compareTo(o.buffer);
        }
        return retVal;
    }

    public int getNumBytes() {
        return this.numBytes;
    }

    @Override
    public long getSerializedSize() throws IOException {
        return metaSerdeHelper.size(this) + this.buffer.remaining();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        metaSerdeHelper.writeTo(channel, this);
        Channels.writeFully(channel, this.buffer.asReadOnlyBuffer());
    }

    @Override
    public ColumnarInts get() {
        return this;
    }

    public static VSizeColumnarInts readFromByteBuffer(ByteBuffer buffer) {
        byte versionFromBuffer = buffer.get();
        if (0 == versionFromBuffer) {
            byte numBytes = buffer.get();
            int size = buffer.getInt();
            ByteBuffer bufferToUse = buffer.asReadOnlyBuffer();
            bufferToUse.limit(bufferToUse.position() + size);
            buffer.position(bufferToUse.limit());
            return new VSizeColumnarInts(bufferToUse, numBytes);
        }
        throw new IAE("Unknown version[%s]", versionFromBuffer);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("buffer", this.buffer);
    }
}

