/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.java.util.common.parsers.CloseableIterator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;

public class StreamingMergeSortedGrouper<KeyType>
implements Grouper<KeyType> {
    private static final Logger LOG = new Logger(StreamingMergeSortedGrouper.class);
    private static final long DEFAULT_TIMEOUT_NS = TimeUnit.SECONDS.toNanos(5L);
    private static final long SPIN_FOR_TIMEOUT_THRESHOLD_NS = 1000L;
    private final Supplier<ByteBuffer> bufferSupplier;
    private final Grouper.KeySerde<KeyType> keySerde;
    private final BufferAggregator[] aggregators;
    private final int[] aggregatorOffsets;
    private final int keySize;
    private final int recordSize;
    private final long queryTimeoutAtNs;
    private final boolean hasQueryTimeout;
    private ByteBuffer buffer;
    private int maxNumSlots;
    private boolean initialized;
    private volatile boolean finished;
    private volatile int curWriteIndex;
    private volatile int nextReadIndex;

    public static <KeyType> int requiredBufferCapacity(Grouper.KeySerde<KeyType> keySerde, AggregatorFactory[] aggregatorFactories) {
        int recordSize = keySerde.keySize();
        for (AggregatorFactory aggregatorFactory : aggregatorFactories) {
            recordSize += aggregatorFactory.getMaxIntermediateSize();
        }
        return recordSize * 3;
    }

    StreamingMergeSortedGrouper(Supplier<ByteBuffer> bufferSupplier, Grouper.KeySerde<KeyType> keySerde, ColumnSelectorFactory columnSelectorFactory, AggregatorFactory[] aggregatorFactories, long queryTimeoutAtMs) {
        this.bufferSupplier = bufferSupplier;
        this.keySerde = keySerde;
        this.aggregators = new BufferAggregator[aggregatorFactories.length];
        this.aggregatorOffsets = new int[aggregatorFactories.length];
        int offset = this.keySize = keySerde.keySize();
        for (int i = 0; i < aggregatorFactories.length; ++i) {
            this.aggregators[i] = aggregatorFactories[i].factorizeBuffered(columnSelectorFactory);
            this.aggregatorOffsets[i] = offset;
            offset += aggregatorFactories[i].getMaxIntermediateSize();
        }
        this.recordSize = offset;
        this.hasQueryTimeout = queryTimeoutAtMs != 0L;
        long timeoutNs = this.hasQueryTimeout ? TimeUnit.MILLISECONDS.toNanos(queryTimeoutAtMs - System.currentTimeMillis()) : 0L;
        this.queryTimeoutAtNs = System.nanoTime() + timeoutNs;
    }

    @Override
    public void init() {
        if (!this.initialized) {
            this.buffer = this.bufferSupplier.get();
            this.maxNumSlots = this.buffer.capacity() / this.recordSize;
            Preconditions.checkState(this.maxNumSlots > 2, "Buffer[%s] should be large enough to store at least three records[%s]", new Object[]{this.buffer.capacity(), this.recordSize});
            this.reset();
            this.initialized = true;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public AggregateResult aggregate(KeyType key, int notUsed) {
        return this.aggregate(key);
    }

    @Override
    public AggregateResult aggregate(KeyType key) {
        try {
            ByteBuffer keyBuffer = this.keySerde.toByteBuffer(key);
            if (keyBuffer.remaining() != this.keySize) {
                throw new IAE("keySerde.toByteBuffer(key).remaining[%s] != keySerde.keySize[%s], buffer was the wrong size?!", keyBuffer.remaining(), this.keySize);
            }
            int prevRecordOffset = this.curWriteIndex * this.recordSize;
            if (this.curWriteIndex == -1 || !this.keyEquals(keyBuffer, this.buffer, prevRecordOffset)) {
                this.initNewSlot(keyBuffer);
            }
            int curRecordOffset = this.curWriteIndex * this.recordSize;
            for (int i = 0; i < this.aggregatorOffsets.length; ++i) {
                this.aggregators[i].aggregate(this.buffer, curRecordOffset + this.aggregatorOffsets[i]);
            }
            return AggregateResult.ok();
        }
        catch (RuntimeException e) {
            this.finished = true;
            throw e;
        }
    }

    private boolean keyEquals(ByteBuffer curKeyBuffer, ByteBuffer buffer, int bufferOffset) {
        int i = 0;
        while (i + 8 <= this.keySize) {
            if (curKeyBuffer.getLong(i) != buffer.getLong(bufferOffset + i)) {
                return false;
            }
            i += 8;
        }
        if (i + 4 <= this.keySize) {
            if (curKeyBuffer.getInt(i) != buffer.getInt(bufferOffset + i)) {
                return false;
            }
            i += 4;
        }
        while (i < this.keySize) {
            if (curKeyBuffer.get(i) != buffer.get(bufferOffset + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void initNewSlot(ByteBuffer newKey) {
        this.increaseWriteIndex();
        int recordOffset = this.recordSize * this.curWriteIndex;
        this.buffer.position(recordOffset);
        this.buffer.put(newKey);
        for (int i = 0; i < this.aggregators.length; ++i) {
            this.aggregators[i].init(this.buffer, recordOffset + this.aggregatorOffsets[i]);
        }
    }

    private void increaseWriteIndex() {
        long startAtNs = System.nanoTime();
        long queryTimeoutAtNs = this.getQueryTimeoutAtNs(startAtNs);
        long spinTimeoutAtNs = startAtNs + 1000L;
        long timeoutNs = queryTimeoutAtNs - startAtNs;
        long spinTimeoutNs = 1000L;
        if (this.curWriteIndex == this.maxNumSlots - 1) {
            while (!(this.nextReadIndex != -1 && this.nextReadIndex != 0 || Thread.currentThread().isInterrupted())) {
                if (timeoutNs <= 0L) {
                    throw new RuntimeException(new TimeoutException());
                }
                if (spinTimeoutNs <= 0L) {
                    Thread.yield();
                }
                long now = System.nanoTime();
                timeoutNs = queryTimeoutAtNs - now;
                spinTimeoutNs = spinTimeoutAtNs - now;
            }
            this.curWriteIndex = 0;
        } else {
            int nextWriteIndex = this.curWriteIndex + 1;
            while (nextWriteIndex == this.nextReadIndex && !Thread.currentThread().isInterrupted()) {
                if (timeoutNs <= 0L) {
                    throw new RuntimeException(new TimeoutException());
                }
                if (spinTimeoutNs <= 0L) {
                    Thread.yield();
                }
                long now = System.nanoTime();
                timeoutNs = queryTimeoutAtNs - now;
                spinTimeoutNs = spinTimeoutAtNs - now;
            }
            this.curWriteIndex = nextWriteIndex;
        }
    }

    @Override
    public void reset() {
        this.curWriteIndex = -1;
        this.nextReadIndex = -1;
        this.finished = false;
    }

    @Override
    public void close() {
        for (BufferAggregator aggregator : this.aggregators) {
            try {
                aggregator.close();
            }
            catch (Exception e) {
                LOG.warn(e, "Could not close aggregator [%s], skipping.", aggregator);
            }
        }
    }

    public void finish() {
        this.increaseWriteIndex();
        this.finished = true;
    }

    public CloseableIterator<Grouper.Entry<KeyType>> iterator() {
        if (!this.initialized) {
            throw new ISE("Grouper should be initialized first", new Object[0]);
        }
        return new CloseableIterator<Grouper.Entry<KeyType>>(){
            {
                this.increaseReadIndexTo(0);
            }

            @Override
            public boolean hasNext() {
                return !StreamingMergeSortedGrouper.this.finished || this.remaining() > 0;
            }

            private int remaining() {
                if (StreamingMergeSortedGrouper.this.curWriteIndex >= StreamingMergeSortedGrouper.this.nextReadIndex) {
                    return StreamingMergeSortedGrouper.this.curWriteIndex - StreamingMergeSortedGrouper.this.nextReadIndex;
                }
                return StreamingMergeSortedGrouper.this.maxNumSlots - StreamingMergeSortedGrouper.this.nextReadIndex + StreamingMergeSortedGrouper.this.curWriteIndex;
            }

            @Override
            public Grouper.Entry<KeyType> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int recordOffset = StreamingMergeSortedGrouper.this.recordSize * StreamingMergeSortedGrouper.this.nextReadIndex;
                Object key = StreamingMergeSortedGrouper.this.keySerde.fromByteBuffer(StreamingMergeSortedGrouper.this.buffer, recordOffset);
                Object[] values = new Object[StreamingMergeSortedGrouper.this.aggregators.length];
                for (int i = 0; i < StreamingMergeSortedGrouper.this.aggregators.length; ++i) {
                    values[i] = StreamingMergeSortedGrouper.this.aggregators[i].get(StreamingMergeSortedGrouper.this.buffer, recordOffset + StreamingMergeSortedGrouper.this.aggregatorOffsets[i]);
                }
                int targetIndex = StreamingMergeSortedGrouper.this.nextReadIndex == StreamingMergeSortedGrouper.this.maxNumSlots - 1 ? 0 : StreamingMergeSortedGrouper.this.nextReadIndex + 1;
                this.increaseReadIndexTo(targetIndex);
                return new Grouper.Entry(key, values);
            }

            private void increaseReadIndexTo(int target) {
                long startAtNs = System.nanoTime();
                long queryTimeoutAtNs = StreamingMergeSortedGrouper.this.getQueryTimeoutAtNs(startAtNs);
                long spinTimeoutAtNs = startAtNs + 1000L;
                long timeoutNs = queryTimeoutAtNs - startAtNs;
                long spinTimeoutNs = 1000L;
                while (!(StreamingMergeSortedGrouper.this.curWriteIndex != -1 && target != StreamingMergeSortedGrouper.this.curWriteIndex || StreamingMergeSortedGrouper.this.finished || Thread.currentThread().isInterrupted())) {
                    if (timeoutNs <= 0L) {
                        throw new RuntimeException(new TimeoutException());
                    }
                    if (spinTimeoutNs <= 0L) {
                        Thread.yield();
                    }
                    long now = System.nanoTime();
                    timeoutNs = queryTimeoutAtNs - now;
                    spinTimeoutNs = spinTimeoutAtNs - now;
                }
                StreamingMergeSortedGrouper.this.nextReadIndex = target;
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    private long getQueryTimeoutAtNs(long startAtNs) {
        return this.hasQueryTimeout ? this.queryTimeoutAtNs : startAtNs + DEFAULT_TIMEOUT_NS;
    }

    @Override
    public CloseableIterator<Grouper.Entry<KeyType>> iterator(boolean sorted) {
        return this.iterator();
    }
}

