/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.first;

import org.apache.hive.druid.io.druid.collections.SerializablePair;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.segment.BaseFloatColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.BaseLongColumnValueSelector;

public class FloatFirstAggregator
implements Aggregator {
    private final BaseFloatColumnValueSelector valueSelector;
    private final BaseLongColumnValueSelector timeSelector;
    protected long firstTime;
    protected float firstValue;

    public FloatFirstAggregator(BaseLongColumnValueSelector timeSelector, BaseFloatColumnValueSelector valueSelector) {
        this.valueSelector = valueSelector;
        this.timeSelector = timeSelector;
        this.firstTime = Long.MAX_VALUE;
        this.firstValue = 0.0f;
    }

    @Override
    public void aggregate() {
        long time = this.timeSelector.getLong();
        if (time < this.firstTime) {
            this.firstTime = time;
            this.firstValue = this.valueSelector.getFloat();
        }
    }

    @Override
    public Object get() {
        return new SerializablePair<Long, Float>(this.firstTime, Float.valueOf(this.firstValue));
    }

    @Override
    public float getFloat() {
        return this.firstValue;
    }

    @Override
    public double getDouble() {
        return this.firstValue;
    }

    @Override
    public long getLong() {
        return (long)this.firstValue;
    }

    @Override
    public void close() {
    }
}

