/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.cardinality.types;

import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.query.aggregation.cardinality.types.CardinalityAggregatorColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.aggregation.cardinality.types.DoubleCardinalityAggregatorColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.aggregation.cardinality.types.FloatCardinalityAggregatorColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.aggregation.cardinality.types.LongCardinalityAggregatorColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.aggregation.cardinality.types.StringCardinalityAggregatorColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ValueType;

public class CardinalityAggregatorColumnSelectorStrategyFactory
implements ColumnSelectorStrategyFactory<CardinalityAggregatorColumnSelectorStrategy> {
    @Override
    public CardinalityAggregatorColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
        ValueType type = capabilities.getType();
        switch (type) {
            case STRING: {
                return new StringCardinalityAggregatorColumnSelectorStrategy();
            }
            case LONG: {
                return new LongCardinalityAggregatorColumnSelectorStrategy();
            }
            case FLOAT: {
                return new FloatCardinalityAggregatorColumnSelectorStrategy();
            }
            case DOUBLE: {
                return new DoubleCardinalityAggregatorColumnSelectorStrategy();
            }
        }
        throw new IAE("Cannot create query type helper from invalid type [%s]", new Object[]{type});
    }
}

