/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.cardinality;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.hll.HyperLogLogCollector;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.query.ColumnSelectorPlus;
import org.apache.hive.druid.io.druid.query.aggregation.AggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.NoopAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.NoopBufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.cardinality.CardinalityAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.cardinality.CardinalityBufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.cardinality.HyperLogLogCollectorAggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.cardinality.types.CardinalityAggregatorColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.aggregation.cardinality.types.CardinalityAggregatorColumnSelectorStrategyFactory;
import org.apache.hive.druid.io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.hive.druid.io.druid.query.cache.CacheKeyBuilder;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;

public class CardinalityAggregatorFactory
extends AggregatorFactory {
    private static final CardinalityAggregatorColumnSelectorStrategyFactory STRATEGY_FACTORY = new CardinalityAggregatorColumnSelectorStrategyFactory();
    private final String name;
    private final List<DimensionSpec> fields;
    private final boolean byRow;
    private final boolean round;

    private static List<String> makeRequiredFieldNamesFromFields(List<DimensionSpec> fields) {
        return ImmutableList.copyOf(Lists.transform(fields, new Function<DimensionSpec, String>(){

            @Override
            public String apply(DimensionSpec input) {
                return input.getDimension();
            }
        }));
    }

    private static List<DimensionSpec> makeFieldsFromFieldNames(List<String> fieldNames) {
        return ImmutableList.copyOf(Lists.transform(fieldNames, new Function<String, DimensionSpec>(){

            @Override
            public DimensionSpec apply(String input) {
                return new DefaultDimensionSpec(input, input);
            }
        }));
    }

    @JsonCreator
    public CardinalityAggregatorFactory(@JsonProperty(value="name") String name, @Deprecated @JsonProperty(value="fieldNames") List<String> fieldNames, @JsonProperty(value="fields") List<DimensionSpec> fields, @JsonProperty(value="byRow") boolean byRow, @JsonProperty(value="round") boolean round) {
        this.name = name;
        if (fields == null) {
            Preconditions.checkArgument(fieldNames != null, "Must provide 'fieldNames' if 'fields' is null.");
            this.fields = CardinalityAggregatorFactory.makeFieldsFromFieldNames(fieldNames);
        } else {
            Preconditions.checkArgument(fieldNames == null, "Cannot specify both 'fieldNames' and 'fields.");
            this.fields = fields;
        }
        this.byRow = byRow;
        this.round = round;
    }

    public CardinalityAggregatorFactory(String name, List<DimensionSpec> fields, boolean byRow) {
        this(name, null, fields, byRow, false);
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory columnFactory) {
        ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>[] selectorPluses = DimensionHandlerUtils.createColumnSelectorPluses(STRATEGY_FACTORY, this.fields, columnFactory);
        if (selectorPluses.length == 0) {
            return NoopAggregator.instance();
        }
        return new CardinalityAggregator(this.name, selectorPluses, this.byRow);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory columnFactory) {
        ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>[] selectorPluses = DimensionHandlerUtils.createColumnSelectorPluses(STRATEGY_FACTORY, this.fields, columnFactory);
        if (selectorPluses.length == 0) {
            return NoopBufferAggregator.instance();
        }
        return new CardinalityBufferAggregator(selectorPluses, this.byRow);
    }

    @Override
    public Comparator getComparator() {
        return new Comparator<HyperLogLogCollector>(){

            @Override
            public int compare(HyperLogLogCollector lhs, HyperLogLogCollector rhs) {
                return lhs.compareTo(rhs);
            }
        };
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return ((HyperLogLogCollector)lhs).fold((HyperLogLogCollector)rhs);
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new HyperLogLogCollectorAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new HyperUniquesAggregatorFactory(this.name, this.name, false, this.round);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return this.fields.stream().map(field -> new CardinalityAggregatorFactory(field.getOutputName(), null, Collections.singletonList(field), this.byRow, this.round)).collect(Collectors.toList());
    }

    @Override
    public Object deserialize(Object object) {
        ByteBuffer buffer;
        if (object instanceof byte[]) {
            buffer = ByteBuffer.wrap((byte[])object);
        } else if (object instanceof ByteBuffer) {
            buffer = ((ByteBuffer)object).duplicate();
        } else if (object instanceof String) {
            buffer = ByteBuffer.wrap(Base64.decodeBase64((byte[])StringUtils.toUtf8((String)object)));
        } else {
            return object;
        }
        return HyperLogLogCollector.makeCollector(buffer);
    }

    @Override
    public Object finalizeComputation(Object object) {
        return HyperUniquesAggregatorFactory.estimateCardinality(object, this.round);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> requiredFields() {
        return CardinalityAggregatorFactory.makeRequiredFieldNamesFromFields(this.fields);
    }

    @JsonProperty
    public List<DimensionSpec> getFields() {
        return this.fields;
    }

    @JsonProperty
    public boolean isByRow() {
        return this.byRow;
    }

    @JsonProperty
    public boolean isRound() {
        return this.round;
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(8).appendCacheables(this.fields).appendBoolean(this.byRow).appendBoolean(this.round).build();
    }

    @Override
    public String getTypeName() {
        return "hyperUnique";
    }

    @Override
    public int getMaxIntermediateSize() {
        return HyperLogLogCollector.getLatestNumBytesForDenseStorage();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardinalityAggregatorFactory that = (CardinalityAggregatorFactory)o;
        return this.byRow == that.byRow && this.round == that.round && Objects.equals(this.name, that.name) && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fields, this.byRow, this.round);
    }

    public String toString() {
        return "CardinalityAggregatorFactory{name='" + this.name + '\'' + ", fields=" + this.fields + ", byRow=" + this.byRow + ", round=" + this.round + '}';
    }
}

