/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.metadata;

import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.metadata.PasswordProvider;

public class EnvironmentVariablePasswordProvider
implements PasswordProvider {
    private final String variable;

    @JsonCreator
    public EnvironmentVariablePasswordProvider(@JsonProperty(value="variable") String variable) {
        this.variable = Preconditions.checkNotNull(variable);
    }

    @JsonProperty(value="variable")
    public String getVariable() {
        return this.variable;
    }

    @Override
    @JsonIgnore
    public String getPassword() {
        return System.getenv(this.variable);
    }

    public String toString() {
        return "EnvironmentVariablePasswordProvider{variable='" + this.variable + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentVariablePasswordProvider that = (EnvironmentVariablePasswordProvider)o;
        return this.variable != null ? this.variable.equals(that.variable) : that.variable == null;
    }

    public int hashCode() {
        return this.variable != null ? this.variable.hashCode() : 0;
    }
}

