/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParser;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonToken;
import org.apache.hive.druid.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JavaType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.databind.type.TypeFactory;
import org.apache.hive.druid.com.fasterxml.jackson.dataformat.smile.SmileFactory;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.io.ByteSource;
import org.apache.hive.druid.com.google.common.util.concurrent.FutureCallback;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.java.util.common.RE;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.guava.BaseSequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.java.util.common.jackson.JacksonUtils;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.java.util.http.client.HttpClient;
import org.apache.hive.druid.io.druid.java.util.http.client.Request;
import org.apache.hive.druid.io.druid.java.util.http.client.response.ClientResponse;
import org.apache.hive.druid.io.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.io.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.hive.druid.io.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.hive.druid.io.druid.query.BySegmentResultValueClass;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryContexts;
import org.apache.hive.druid.io.druid.query.QueryInterruptedException;
import org.apache.hive.druid.io.druid.query.QueryMetrics;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.QueryToolChestWarehouse;
import org.apache.hive.druid.io.druid.query.QueryWatcher;
import org.apache.hive.druid.io.druid.query.ResourceLimitExceededException;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.aggregation.MetricManipulatorFns;
import org.apache.hive.druid.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.hive.druid.org.jboss.netty.buffer.ChannelBufferInputStream;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpChunk;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponse;
import org.joda.time.Duration;

public class DirectDruidClient<T>
implements QueryRunner<T> {
    public static final String QUERY_FAIL_TIME = "queryFailTime";
    public static final String QUERY_TOTAL_BYTES_GATHERED = "queryTotalBytesGathered";
    private static final Logger log = new Logger(DirectDruidClient.class);
    private static final Map<Class<? extends Query>, Pair<JavaType, JavaType>> typesMap = new ConcurrentHashMap<Class<? extends Query>, Pair<JavaType, JavaType>>();
    private final QueryToolChestWarehouse warehouse;
    private final QueryWatcher queryWatcher;
    private final ObjectMapper objectMapper;
    private final HttpClient httpClient;
    private final String scheme;
    private final String host;
    private final ServiceEmitter emitter;
    private final AtomicInteger openConnections;
    private final boolean isSmile;

    public static void removeMagicResponseContextFields(Map<String, Object> responseContext) {
        responseContext.remove(QUERY_FAIL_TIME);
        responseContext.remove(QUERY_TOTAL_BYTES_GATHERED);
    }

    public static Map<String, Object> makeResponseContextForQuery(Query query, long startTimeMillis) {
        ConcurrentHashMap<String, Object> responseContext = new ConcurrentHashMap<String, Object>();
        responseContext.put(QUERY_FAIL_TIME, startTimeMillis + QueryContexts.getTimeout(query));
        responseContext.put(QUERY_TOTAL_BYTES_GATHERED, new AtomicLong());
        return responseContext;
    }

    public DirectDruidClient(QueryToolChestWarehouse warehouse, QueryWatcher queryWatcher, ObjectMapper objectMapper, HttpClient httpClient, String scheme, String host, ServiceEmitter emitter) {
        this.warehouse = warehouse;
        this.queryWatcher = queryWatcher;
        this.objectMapper = objectMapper;
        this.httpClient = httpClient;
        this.scheme = scheme;
        this.host = host;
        this.emitter = emitter;
        this.isSmile = this.objectMapper.getFactory() instanceof SmileFactory;
        this.openConnections = new AtomicInteger();
    }

    public int getNumOpenConnections() {
        return this.openConnections.get();
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, final Map<String, Object> context) {
        ListenableFuture<InputStream> future;
        final Query<T> query = queryPlus.getQuery();
        final QueryToolChest toolChest = this.warehouse.getToolChest(query);
        boolean isBySegment = QueryContexts.isBySegment(query);
        Pair<JavaType, JavaType> types = typesMap.get(query.getClass());
        if (types == null) {
            TypeFactory typeFactory = this.objectMapper.getTypeFactory();
            JavaType baseType = typeFactory.constructType(toolChest.getResultTypeReference());
            JavaType bySegmentType = typeFactory.constructParametricType(Result.class, typeFactory.constructParametricType(BySegmentResultValueClass.class, baseType));
            types = Pair.of(baseType, bySegmentType);
            typesMap.put(query.getClass(), types);
        }
        final JavaType typeRef = isBySegment ? (JavaType)types.rhs : (JavaType)types.lhs;
        final String url = StringUtils.format("%s://%s/druid/v2/", this.scheme, this.host);
        final String cancelUrl = StringUtils.format("%s://%s/druid/v2/%s", this.scheme, this.host, query.getId());
        try {
            log.debug("Querying queryId[%s] url[%s]", query.getId(), url);
            final long requestStartTimeNs = System.nanoTime();
            final long timeoutAt = (Long)context.get(QUERY_FAIL_TIME);
            final long maxScatterGatherBytes = QueryContexts.getMaxScatterGatherBytes(query);
            final AtomicLong totalBytesGathered = (AtomicLong)context.get(QUERY_TOTAL_BYTES_GATHERED);
            HttpResponseHandler<InputStream, InputStream> responseHandler = new HttpResponseHandler<InputStream, InputStream>(){
                private final AtomicLong byteCount = new AtomicLong(0L);
                private final BlockingQueue<InputStream> queue = new LinkedBlockingQueue<InputStream>();
                private final AtomicBoolean done = new AtomicBoolean(false);
                private final AtomicReference<String> fail = new AtomicReference();
                private QueryMetrics<? super Query<T>> queryMetrics;
                private long responseStartTimeNs;

                private QueryMetrics<? super Query<T>> acquireResponseMetrics() {
                    if (this.queryMetrics == null) {
                        this.queryMetrics = toolChest.makeMetrics(query);
                        this.queryMetrics.server(DirectDruidClient.this.host);
                    }
                    return this.queryMetrics;
                }

                @Override
                public ClientResponse<InputStream> handleResponse(HttpResponse response) {
                    this.checkQueryTimeout();
                    this.checkTotalBytesLimit(response.getContent().readableBytes());
                    log.debug("Initial response from url[%s] for queryId[%s]", url, query.getId());
                    this.responseStartTimeNs = System.nanoTime();
                    this.acquireResponseMetrics().reportNodeTimeToFirstByte(this.responseStartTimeNs - requestStartTimeNs).emit(DirectDruidClient.this.emitter);
                    try {
                        String responseContext = response.headers().get("X-Druid-Response-Context");
                        if (responseContext != null) {
                            context.putAll(DirectDruidClient.this.objectMapper.readValue(responseContext, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT));
                        }
                        this.queue.put(new ChannelBufferInputStream(response.getContent()));
                    }
                    catch (IOException e) {
                        log.error(e, "Error parsing response context from url [%s]", url);
                        return ClientResponse.finished(new InputStream(){

                            @Override
                            public int read() throws IOException {
                                throw e;
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        log.error(e, "Queue appending interrupted", new Object[0]);
                        Thread.currentThread().interrupt();
                        throw Throwables.propagate(e);
                    }
                    this.byteCount.addAndGet(response.getContent().readableBytes());
                    return ClientResponse.finished(new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public boolean hasMoreElements() {
                            if (fail.get() != null) {
                                throw new RE((String)fail.get(), new Object[0]);
                            }
                            this.checkQueryTimeout();
                            AtomicBoolean atomicBoolean = done;
                            synchronized (atomicBoolean) {
                                return !done.get() || !queue.isEmpty();
                            }
                        }

                        @Override
                        public InputStream nextElement() {
                            if (fail.get() != null) {
                                throw new RE((String)fail.get(), new Object[0]);
                            }
                            try {
                                InputStream is = (InputStream)queue.poll(this.checkQueryTimeout(), TimeUnit.MILLISECONDS);
                                if (is != null) {
                                    return is;
                                }
                                throw new RE("Query[%s] url[%s] timed out.", query.getId(), url);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw Throwables.propagate(e);
                            }
                        }
                    }));
                }

                @Override
                public ClientResponse<InputStream> handleChunk(ClientResponse<InputStream> clientResponse, HttpChunk chunk) {
                    this.checkQueryTimeout();
                    ChannelBuffer channelBuffer = chunk.getContent();
                    int bytes = channelBuffer.readableBytes();
                    this.checkTotalBytesLimit(bytes);
                    if (bytes > 0) {
                        try {
                            this.queue.put(new ChannelBufferInputStream(channelBuffer));
                        }
                        catch (InterruptedException e) {
                            log.error(e, "Unable to put finalizing input stream into Sequence queue for url [%s]", url);
                            Thread.currentThread().interrupt();
                            throw Throwables.propagate(e);
                        }
                        this.byteCount.addAndGet(bytes);
                    }
                    return clientResponse;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ClientResponse<InputStream> done(ClientResponse<InputStream> clientResponse) {
                    long stopTimeNs = System.nanoTime();
                    long nodeTimeNs = stopTimeNs - requestStartTimeNs;
                    long nodeTimeMs = TimeUnit.NANOSECONDS.toMillis(nodeTimeNs);
                    log.debug("Completed queryId[%s] request to url[%s] with %,d bytes returned in %,d millis [%,f b/s].", query.getId(), url, this.byteCount.get(), nodeTimeMs, (double)this.byteCount.get() / (0.001 * (double)nodeTimeMs));
                    QueryMetrics responseMetrics = this.acquireResponseMetrics();
                    responseMetrics.reportNodeTime(nodeTimeNs);
                    responseMetrics.reportNodeBytes(this.byteCount.get());
                    responseMetrics.emit(DirectDruidClient.this.emitter);
                    AtomicBoolean atomicBoolean = this.done;
                    synchronized (atomicBoolean) {
                        try {
                            this.queue.put(ByteSource.empty().openStream());
                        }
                        catch (InterruptedException e) {
                            log.error(e, "Unable to put finalizing input stream into Sequence queue for url [%s]", url);
                            Thread.currentThread().interrupt();
                            throw Throwables.propagate(e);
                        }
                        catch (IOException e) {
                            throw Throwables.propagate(e);
                        }
                        finally {
                            this.done.set(true);
                        }
                    }
                    return ClientResponse.finished(clientResponse.getObj());
                }

                @Override
                public void exceptionCaught(ClientResponse<InputStream> clientResponse, Throwable e) {
                    String msg = StringUtils.format("Query[%s] url[%s] failed with exception msg [%s]", query.getId(), url, e.getMessage());
                    this.setupResponseReadFailure(msg, e);
                }

                private void setupResponseReadFailure(final String msg, final Throwable th) {
                    this.fail.set(msg);
                    this.queue.clear();
                    this.queue.offer(new InputStream(){

                        @Override
                        public int read() throws IOException {
                            if (th != null) {
                                throw new IOException(msg, th);
                            }
                            throw new IOException(msg);
                        }
                    });
                }

                private long checkQueryTimeout() {
                    long timeLeft = timeoutAt - System.currentTimeMillis();
                    if (timeLeft <= 0L) {
                        String msg = StringUtils.format("Query[%s] url[%s] timed out.", query.getId(), url);
                        this.setupResponseReadFailure(msg, null);
                        throw new RE(msg, new Object[0]);
                    }
                    return timeLeft;
                }

                private void checkTotalBytesLimit(long bytes) {
                    if (maxScatterGatherBytes < Long.MAX_VALUE && totalBytesGathered.addAndGet(bytes) > maxScatterGatherBytes) {
                        String msg = StringUtils.format("Query[%s] url[%s] max scatter-gather bytes limit reached.", query.getId(), url);
                        this.setupResponseReadFailure(msg, null);
                        throw new RE(msg, new Object[0]);
                    }
                }
            };
            long timeLeft = timeoutAt - System.currentTimeMillis();
            if (timeLeft <= 0L) {
                throw new RE("Query[%s] url[%s] timed out.", query.getId(), url);
            }
            future = this.httpClient.go(new Request(HttpMethod.POST, new URL(url)).setContent(this.objectMapper.writeValueAsBytes(QueryContexts.withTimeout(query, timeLeft))).setHeader("Content-Type", this.isSmile ? "application/x-jackson-smile" : "application/json"), responseHandler, Duration.millis((long)timeLeft));
            this.queryWatcher.registerQuery(query, future);
            this.openConnections.getAndIncrement();
            Futures.addCallback(future, (FutureCallback)new FutureCallback<InputStream>(){

                @Override
                public void onSuccess(InputStream result) {
                    DirectDruidClient.this.openConnections.getAndDecrement();
                }

                @Override
                public void onFailure(Throwable t) {
                    DirectDruidClient.this.openConnections.getAndDecrement();
                    if (future.isCancelled()) {
                        try {
                            StatusResponseHolder res = (StatusResponseHolder)DirectDruidClient.this.httpClient.go(new Request(HttpMethod.DELETE, new URL(cancelUrl)).setContent(DirectDruidClient.this.objectMapper.writeValueAsBytes(query)).setHeader("Content-Type", DirectDruidClient.this.isSmile ? "application/x-jackson-smile" : "application/json"), new StatusResponseHandler(Charsets.UTF_8), Duration.standardSeconds((long)1L)).get(1L, TimeUnit.SECONDS);
                            if (res.getStatus().getCode() >= 500) {
                                throw new RE("Error cancelling query[%s]: queriable node returned status[%d] [%s].", res.getStatus().getCode(), res.getStatus().getReasonPhrase());
                            }
                        }
                        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
                            Throwables.propagate(e);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
        Sequence retVal = new BaseSequence(new BaseSequence.IteratorMaker<T, JsonParserIterator<T>>(){

            @Override
            public JsonParserIterator<T> make() {
                return new JsonParserIterator(typeRef, future, url, query);
            }

            @Override
            public void cleanup(JsonParserIterator<T> iterFromMake) {
                CloseQuietly.close(iterFromMake);
            }
        });
        if (!isBySegment) {
            retVal = Sequences.map(retVal, toolChest.makePreComputeManipulatorFn(query, MetricManipulatorFns.deserializing()));
        }
        return retVal;
    }

    public String toString() {
        return "DirectDruidClient{host='" + this.host + '\'' + ", isSmile=" + this.isSmile + '}';
    }

    private class JsonParserIterator<T>
    implements Iterator<T>,
    Closeable {
        private JsonParser jp;
        private ObjectCodec objectCodec;
        private final JavaType typeRef;
        private final Future<InputStream> future;
        private final Query<T> query;
        private final String url;

        public JsonParserIterator(JavaType typeRef, Future<InputStream> future, String url, Query<T> query) {
            this.typeRef = typeRef;
            this.future = future;
            this.url = url;
            this.query = query;
            this.jp = null;
        }

        @Override
        public boolean hasNext() {
            this.init();
            if (this.jp.isClosed()) {
                return false;
            }
            if (this.jp.getCurrentToken() == JsonToken.END_ARRAY) {
                CloseQuietly.close(this.jp);
                return false;
            }
            return true;
        }

        @Override
        public T next() {
            this.init();
            try {
                Object retVal = this.objectCodec.readValue(this.jp, this.typeRef);
                this.jp.nextToken();
                return retVal;
            }
            catch (IOException e) {
                throw Throwables.propagate(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void init() {
            if (this.jp == null) {
                try {
                    InputStream is = this.future.get();
                    if (is == null) {
                        throw new QueryInterruptedException(new ResourceLimitExceededException("query[%s] url[%s] timed out or max bytes limit reached.", this.query.getId(), this.url), DirectDruidClient.this.host);
                    }
                    this.jp = DirectDruidClient.this.objectMapper.getFactory().createParser(is);
                    JsonToken nextToken = this.jp.nextToken();
                    if (nextToken == JsonToken.START_OBJECT) {
                        QueryInterruptedException cause = this.jp.getCodec().readValue(this.jp, QueryInterruptedException.class);
                        throw new QueryInterruptedException(cause, DirectDruidClient.this.host);
                    }
                    if (nextToken != JsonToken.START_ARRAY) {
                        throw new IAE("Next token wasn't a START_ARRAY, was[%s] from url [%s]", new Object[]{this.jp.getCurrentToken(), this.url});
                    }
                    this.jp.nextToken();
                    this.objectCodec = this.jp.getCodec();
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    throw new RE(e, "Failure getting results for query[%s] url[%s] because of [%s]", this.query.getId(), this.url, e.getMessage());
                }
                catch (CancellationException e) {
                    throw new QueryInterruptedException(e, DirectDruidClient.this.host);
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (this.jp != null) {
                this.jp.close();
            }
        }
    }
}

