/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.druid;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.ComplexMetric;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidConnectionImpl;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidSchema;
import org.apache.hive.druid.org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.hive.druid.org.apache.calcite.interpreter.BindableConvention;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptTable;
import org.apache.hive.druid.org.apache.calcite.plan.RelTrait;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.AggregateCall;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.hive.druid.org.apache.calcite.schema.Table;
import org.apache.hive.druid.org.apache.calcite.schema.TranslatableTable;
import org.apache.hive.druid.org.apache.calcite.schema.impl.AbstractTable;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;

public class DruidTable
extends AbstractTable
implements TranslatableTable {
    public static final String DEFAULT_TIMESTAMP_COLUMN = "__time";
    public static final Interval DEFAULT_INTERVAL = new Interval((ReadableInstant)new DateTime((Object)"1900-01-01", (Chronology)ISOChronology.getInstanceUTC()), (ReadableInstant)new DateTime((Object)"3000-01-01", (Chronology)ISOChronology.getInstanceUTC()));
    final DruidSchema schema;
    final String dataSource;
    final RelProtoDataType protoRowType;
    final ImmutableSet<String> metricFieldNames;
    final ImmutableList<Interval> intervals;
    final String timestampFieldName;
    final ImmutableMap<String, List<ComplexMetric>> complexMetrics;
    final ImmutableMap<String, SqlTypeName> allFields;

    public DruidTable(DruidSchema schema, String dataSource, RelProtoDataType protoRowType, Set<String> metricFieldNames, String timestampFieldName, List<Interval> intervals, Map<String, List<ComplexMetric>> complexMetrics, Map<String, SqlTypeName> allFields) {
        this.timestampFieldName = Preconditions.checkNotNull(timestampFieldName);
        this.schema = Preconditions.checkNotNull(schema);
        this.dataSource = Preconditions.checkNotNull(dataSource);
        this.protoRowType = protoRowType;
        this.metricFieldNames = ImmutableSet.copyOf(metricFieldNames);
        this.intervals = intervals != null ? ImmutableList.copyOf(intervals) : ImmutableList.of(DEFAULT_INTERVAL);
        this.complexMetrics = complexMetrics == null ? ImmutableMap.of() : ImmutableMap.copyOf(complexMetrics);
        this.allFields = allFields == null ? ImmutableMap.of() : ImmutableMap.copyOf(allFields);
    }

    static Table create(DruidSchema druidSchema, String dataSourceName, List<Interval> intervals, Map<String, SqlTypeName> fieldMap, Set<String> metricNameSet, String timestampColumnName, DruidConnectionImpl connection, Map<String, List<ComplexMetric>> complexMetrics) {
        assert (connection != null);
        connection.metadata(dataSourceName, timestampColumnName, intervals, fieldMap, metricNameSet, complexMetrics);
        return DruidTable.create(druidSchema, dataSourceName, intervals, fieldMap, metricNameSet, timestampColumnName, complexMetrics);
    }

    static Table create(DruidSchema druidSchema, String dataSourceName, List<Interval> intervals, Map<String, SqlTypeName> fieldMap, Set<String> metricNameSet, String timestampColumnName, Map<String, List<ComplexMetric>> complexMetrics) {
        ImmutableMap<String, SqlTypeName> fields = ImmutableMap.copyOf(fieldMap);
        return new DruidTable(druidSchema, dataSourceName, new MapRelProtoDataType(fields, timestampColumnName), ImmutableSet.copyOf(metricNameSet), timestampColumnName, intervals, complexMetrics, fieldMap);
    }

    public ComplexMetric resolveComplexMetric(String alias, AggregateCall call) {
        List<ComplexMetric> potentialMetrics = this.getComplexMetricsFrom(alias);
        for (ComplexMetric complexMetric : potentialMetrics) {
            if (!complexMetric.canBeUsed(call)) continue;
            return complexMetric;
        }
        return null;
    }

    @Override
    public boolean isRolledUp(String column) {
        return this.complexMetrics.get(column) != null && this.allFields.get(column) != SqlTypeName.VARCHAR;
    }

    @Override
    public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig config) {
        assert (this.isRolledUp(column));
        return (config != null && config.approximateDistinctCount() && this.isCountDistinct(call) || call.getOperator() == SqlStdOperatorTable.APPROX_COUNT_DISTINCT) && call.getOperandList().size() == 1 && this.isValidParentKind(parent);
    }

    private boolean isValidParentKind(SqlNode node) {
        return node.getKind() == SqlKind.SELECT || node.getKind() == SqlKind.FILTER || this.isSupportedPostAggOperation(node.getKind());
    }

    private boolean isCountDistinct(SqlCall call) {
        return call.getKind() == SqlKind.COUNT && call.getFunctionQuantifier() != null && call.getFunctionQuantifier().getValue() == SqlSelectKeyword.DISTINCT;
    }

    private boolean isSupportedPostAggOperation(SqlKind kind) {
        return kind == SqlKind.PLUS || kind == SqlKind.MINUS || kind == SqlKind.DIVIDE || kind == SqlKind.TIMES;
    }

    public List<ComplexMetric> getComplexMetricsFrom(String alias) {
        return this.complexMetrics.containsKey(alias) ? this.complexMetrics.get(alias) : new ArrayList<ComplexMetric>();
    }

    public boolean isComplexMetric(String alias) {
        return this.complexMetrics.get(alias) != null;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        RelDataType rowType = (RelDataType)this.protoRowType.apply(typeFactory);
        List<String> fieldNames = rowType.getFieldNames();
        Preconditions.checkArgument(fieldNames.contains(this.timestampFieldName));
        Preconditions.checkArgument(fieldNames.containsAll(this.metricFieldNames));
        return rowType;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        LogicalTableScan scan = LogicalTableScan.create(cluster, relOptTable);
        return DruidQuery.create(cluster, cluster.traitSetOf((RelTrait)BindableConvention.INSTANCE), relOptTable, this, ImmutableList.of(scan));
    }

    public boolean isMetric(String name) {
        return this.metricFieldNames.contains(name);
    }

    private static class MapRelProtoDataType
    implements RelProtoDataType {
        private final ImmutableMap<String, SqlTypeName> fields;
        private final String timestampColumn;

        MapRelProtoDataType(ImmutableMap<String, SqlTypeName> fields) {
            this.fields = fields;
            this.timestampColumn = DruidTable.DEFAULT_TIMESTAMP_COLUMN;
        }

        MapRelProtoDataType(ImmutableMap<String, SqlTypeName> fields, String timestampColumn) {
            this.fields = fields;
            this.timestampColumn = timestampColumn;
        }

        @Override
        public RelDataType apply(RelDataTypeFactory typeFactory) {
            RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
            for (Map.Entry field : this.fields.entrySet()) {
                String key = (String)field.getKey();
                ((RelDataTypeFactory.Builder)builder).add(key, (SqlTypeName)((Object)field.getValue())).nullable(!this.timestampColumn.equals(key));
            }
            return builder.build();
        }
    }
}

