/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.hive.druid.io.druid.segment.DimensionHandler;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.Metadata;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.column.Column;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.joda.time.Interval;

public class SimpleQueryableIndex
implements QueryableIndex {
    private final Interval dataInterval;
    private final Indexed<String> columnNames;
    private final Indexed<String> availableDimensions;
    private final BitmapFactory bitmapFactory;
    private final Map<String, Column> columns;
    private final SmooshedFileMapper fileMapper;
    private final Metadata metadata;
    private final Map<String, DimensionHandler> dimensionHandlers;

    public SimpleQueryableIndex(Interval dataInterval, Indexed<String> columnNames, Indexed<String> dimNames, BitmapFactory bitmapFactory, Map<String, Column> columns, SmooshedFileMapper fileMapper, Metadata metadata) {
        Preconditions.checkNotNull(columns.get("__time"));
        this.dataInterval = dataInterval;
        this.columnNames = columnNames;
        this.availableDimensions = dimNames;
        this.bitmapFactory = bitmapFactory;
        this.columns = columns;
        this.fileMapper = fileMapper;
        this.metadata = metadata;
        this.dimensionHandlers = Maps.newLinkedHashMap();
        this.initDimensionHandlers();
    }

    @Override
    public Interval getDataInterval() {
        return this.dataInterval;
    }

    @Override
    public int getNumRows() {
        return this.columns.get("__time").getLength();
    }

    @Override
    public Indexed<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return this.availableDimensions;
    }

    @Override
    public BitmapFactory getBitmapFactoryForDimensions() {
        return this.bitmapFactory;
    }

    @Override
    @Nullable
    public Column getColumn(String columnName) {
        return this.columns.get(columnName);
    }

    @Override
    public void close() throws IOException {
        this.fileMapper.close();
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Map<String, DimensionHandler> getDimensionHandlers() {
        return this.dimensionHandlers;
    }

    private void initDimensionHandlers() {
        for (String dim : this.availableDimensions) {
            ColumnCapabilities capabilities = this.getColumn(dim).getCapabilities();
            DimensionHandler handler = DimensionHandlerUtils.getHandlerFromCapabilities(dim, capabilities, null);
            this.dimensionHandlers.put(dim, handler);
        }
    }
}

