/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlObjectBuilder;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;
import org.skife.jdbi.v2.sqlobject.mixins.CloseMe;

public class TestReturningQueryResults {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:" + UUID.randomUUID());
        this.dbi = new DBI((DataSource)ds);
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testSingleValue() throws Exception {
        this.handle.execute("insert into something (id, name) values (7, 'Tim')", new Object[0]);
        Spiffy spiffy = (Spiffy)SqlObjectBuilder.open((IDBI)this.dbi, Spiffy.class);
        Something s = spiffy.findById(7);
        Assert.assertEquals((Object)"Tim", (Object)s.getName());
    }

    @Test
    public void testIterator() throws Exception {
        this.handle.execute("insert into something (id, name) values (7, 'Tim')", new Object[0]);
        this.handle.execute("insert into something (id, name) values (3, 'Diego')", new Object[0]);
        Spiffy spiffy = (Spiffy)SqlObjectBuilder.open((IDBI)this.dbi, Spiffy.class);
        Iterator<Something> itty = spiffy.findByIdRange(2, 10);
        HashSet<Something> all = new HashSet<Something>();
        while (itty.hasNext()) {
            all.add(itty.next());
        }
        Assert.assertEquals((long)2L, (long)all.size());
        Assert.assertTrue((boolean)all.contains(new Something(7, "Tim")));
        Assert.assertTrue((boolean)all.contains(new Something(3, "Diego")));
    }

    @Test
    public void testList() throws Exception {
        this.handle.execute("insert into something (id, name) values (7, 'Tim')", new Object[0]);
        this.handle.execute("insert into something (id, name) values (3, 'Diego')", new Object[0]);
        Spiffy spiffy = (Spiffy)SqlObjectBuilder.open((IDBI)this.dbi, Spiffy.class);
        List<Something> all = spiffy.findTwoByIds(3, 7);
        Assert.assertEquals((long)2L, (long)all.size());
        Assert.assertTrue((boolean)all.contains(new Something(7, "Tim")));
        Assert.assertTrue((boolean)all.contains(new Something(3, "Diego")));
    }

    public static interface Spiffy
    extends CloseMe {
        @SqlQuery(value="select id, name from something where id = :id")
        @Mapper(value=SomethingMapper.class)
        public Something findById(@Bind(value="id") int var1);

        @SqlQuery(value="select id, name from something where id >= :from and id <= :to")
        @Mapper(value=SomethingMapper.class)
        public Iterator<Something> findByIdRange(@Bind(value="from") int var1, @Bind(value="to") int var2);

        @SqlQuery(value="select id, name from something where id = :first or id = :second")
        @Mapper(value=SomethingMapper.class)
        public List<Something> findTwoByIds(@Bind(value="first") int var1, @Bind(value="second") int var2);
    }
}

