/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlObjectBuilder;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.sqlobject.helpers.MapResultAsBean;
import org.skife.jdbi.v2.sqlobject.mixins.CloseMe;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TestRegisteredMappersWork {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:" + UUID.randomUUID());
        this.dbi = new DBI((DataSource)ds);
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testFoo() throws Exception {
        boolean world_is_right = ((BooleanDao)this.handle.attach(BooleanDao.class)).fetchABoolean();
        Assert.assertThat((Object)world_is_right, (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testBeanMapperFactory() throws Exception {
        BeanMappingDao db = (BeanMappingDao)this.handle.attach(BeanMappingDao.class);
        db.createBeanTable();
        Bean lima = new Bean();
        lima.setColor("green");
        lima.setName("lima");
        db.insertBean(lima);
        Bean another_lima = db.findByName("lima");
        Assert.assertThat((Object)another_lima.getName(), (Matcher)CoreMatchers.equalTo((Object)lima.getName()));
        Assert.assertThat((Object)another_lima.getColor(), (Matcher)CoreMatchers.equalTo((Object)lima.getColor()));
    }

    @Test
    public void testRegistered() throws Exception {
        this.handle.registerMapper((ResultSetMapper)new SomethingMapper());
        Spiffy s = (Spiffy)SqlObjectBuilder.attach((Handle)this.handle, Spiffy.class);
        s.insert(1L, "Tatu");
        Something t = s.byId(1L);
        Assert.assertEquals((long)1L, (long)t.getId());
        Assert.assertEquals((Object)"Tatu", (Object)t.getName());
    }

    @Test
    public void testBuiltIn() throws Exception {
        Spiffy s = (Spiffy)SqlObjectBuilder.attach((Handle)this.handle, Spiffy.class);
        s.insert(1L, "Tatu");
        Assert.assertEquals((Object)"Tatu", (Object)s.findNameBy(1L));
    }

    @Test
    public void testRegisterMapperAnnotationWorks() throws Exception {
        Kabob bob = (Kabob)this.dbi.onDemand(Kabob.class);
        bob.insert(1, "Henning");
        Something henning = bob.find(1);
        Assert.assertThat((Object)henning, (Matcher)CoreMatchers.equalTo((Object)new Something(1, "Henning")));
    }

    @Test(expected=DBIException.class)
    public void testNoRootRegistrations() throws Exception {
        Handle h = this.dbi.open();
        h.insert("insert into something (id, name) values (1, 'Henning')", new Object[0]);
        try {
            Something henning = (Something)h.createQuery("select id, name from something where id = 1").mapTo(Something.class).first();
            Assert.fail((String)"should have raised an exception");
        }
        finally {
            h.close();
        }
    }

    @Test
    public void testNoErrorOnNoData() throws Exception {
        Kabob bob = (Kabob)this.dbi.onDemand(Kabob.class);
        Something henning = bob.find(1);
        Assert.assertThat((Object)henning, (Matcher)CoreMatchers.nullValue());
        List<Something> rs = bob.listAll();
        Assert.assertThat((Object)rs.isEmpty(), (Matcher)CoreMatchers.equalTo((Object)true));
        Iterator<Something> itty = bob.iterateAll();
        Assert.assertThat((Object)itty.hasNext(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    public static class MySomethingMapper
    implements ResultSetMapper<Something> {
        public Something map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return new Something(r.getInt("id"), r.getString("name"));
        }
    }

    @RegisterMapper(value={MySomethingMapper.class})
    public static interface Kabob {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlQuery(value="select id, name from something where id = :id")
        public Something find(@Bind(value="id") int var1);

        @SqlQuery(value="select id, name from something order by id")
        public List<Something> listAll();

        @SqlQuery(value="select id, name from something order by id")
        public Iterator<Something> iterateAll();
    }

    public static interface Spiffy
    extends CloseMe {
        @SqlQuery(value="select id, name from something where id = :id")
        public Something byId(@Bind(value="id") long var1);

        @SqlQuery(value="select name from something where id = :id")
        public String findNameBy(@Bind(value="id") long var1);

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);
    }

    public static interface BeanMappingDao {
        @SqlUpdate(value="create table beans ( name varchar primary key, color varchar )")
        public void createBeanTable();

        @SqlUpdate(value="insert into beans (name, color) values (:name, :color)")
        public void insertBean(@BindBean Bean var1);

        @SqlQuery(value="select name, color from beans where name = :name")
        @MapResultAsBean
        public Bean findByName(@Bind(value="name") String var1);
    }

    public static class Bean {
        private String name;
        private String color;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }
    }

    public static interface BooleanDao {
        @SqlQuery(value="select 1+1 = 2")
        public boolean fetchABoolean();
    }
}

