/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Define;
import org.skife.jdbi.v2.sqlobject.customizers.OverrideStatementLocatorWith;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.sqlobject.stringtemplate.StringTemplate3StatementLocator;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class TestOverrideStatementLocatorWith {
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:" + UUID.randomUUID());
        DBI dbi = new DBI((DataSource)ds);
        this.handle = dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testBaz() throws Exception {
        Kangaroo wombat = (Kangaroo)this.handle.attach(Kangaroo.class);
        wombat.insert(new Something(7, "Henning"));
        String name = (String)this.handle.createQuery("select name from something where id = 7").map((ResultSetMapper)StringMapper.FIRST).first();
        Assert.assertThat((Object)name, (Matcher)CoreMatchers.equalTo((Object)"Henning"));
    }

    @Test
    public void testBam() throws Exception {
        this.handle.execute("insert into something (id, name) values (6, 'Martin')", new Object[0]);
        Something s = ((Kangaroo)this.handle.attach(Kangaroo.class)).findById(6L);
        Assert.assertThat((Object)s.getName(), (Matcher)CoreMatchers.equalTo((Object)"Martin"));
    }

    @Test
    public void testBap() throws Exception {
        this.handle.execute("insert into something (id, name) values (2, 'Bean')", new Object[0]);
        Kangaroo w = (Kangaroo)this.handle.attach(Kangaroo.class);
        Assert.assertThat((Object)w.findNameFor(2), (Matcher)CoreMatchers.equalTo((Object)"Bean"));
    }

    @Test
    public void testDefines() throws Exception {
        ((Kangaroo)this.handle.attach(Kangaroo.class)).weirdInsert("something", "id", "name", 5, "Bouncer");
        String name = (String)this.handle.createQuery("select name from something where id = 5").map((ResultSetMapper)StringMapper.FIRST).first();
        Assert.assertThat((Object)name, (Matcher)CoreMatchers.equalTo((Object)"Bouncer"));
    }

    @OverrideStatementLocatorWith(value=StringTemplate3StatementLocator.class)
    @RegisterMapper(value={SomethingMapper.class})
    static interface Kangaroo {
        @SqlUpdate
        public void insert(@BindBean Something var1);

        @SqlQuery
        public Something findById(@Bind(value="id") Long var1);

        @SqlQuery(value="select name from something where id = :it")
        public String findNameFor(@Bind int var1);

        @SqlUpdate
        public void weirdInsert(@Define(value="table") String var1, @Define(value="id_column") String var2, @Define(value="value_column") String var3, @Bind(value="id") int var4, @Bind(value="value") String var5);
    }
}

