/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.easymock.EasyMock;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.exceptions.TransactionException;
import org.skife.jdbi.v2.exceptions.UnableToCloseResourceException;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlObjectBuilder;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;
import org.skife.jdbi.v2.sqlobject.mixins.GetHandle;
import org.skife.jdbi.v2.sqlobject.mixins.Transactional;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class TestOnDemandSqlObject {
    private DBI dbi;
    private Handle handle;
    private JdbcDataSource ds;

    @Before
    public void setUp() throws Exception {
        this.ds = new JdbcDataSource();
        this.ds.setURL(String.format("jdbc:h2:mem:%s;MVCC=TRUE", UUID.randomUUID()));
        this.dbi = new DBI((DataSource)this.ds);
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testAPIWorks() throws Exception {
        Spiffy s = (Spiffy)SqlObjectBuilder.onDemand((IDBI)this.dbi, Spiffy.class);
        s.insert(7L, "Bill");
        String bill = (String)this.handle.createQuery("select name from something where id = 7").map((ResultSetMapper)StringMapper.FIRST).first();
        Assert.assertEquals((Object)"Bill", (Object)bill);
    }

    @Test
    public void testTransactionBindsTheHandle() throws Exception {
        TransactionStuff txl = (TransactionStuff)SqlObjectBuilder.onDemand((IDBI)this.dbi, TransactionStuff.class);
        TransactionStuff tx2 = (TransactionStuff)SqlObjectBuilder.onDemand((IDBI)this.dbi, TransactionStuff.class);
        txl.insert(8L, "Mike");
        txl.begin();
        Assert.assertSame((Object)txl.getHandle(), (Object)txl.getHandle());
        txl.updateName(8L, "Miker");
        Assert.assertEquals((Object)"Miker", (Object)txl.byId(8L).getName());
        Assert.assertEquals((Object)"Mike", (Object)tx2.byId(8L).getName());
        txl.commit();
        Assert.assertNotSame((Object)txl.getHandle(), (Object)txl.getHandle());
        Assert.assertEquals((Object)"Miker", (Object)tx2.byId(8L).getName());
    }

    @Test
    public void testIteratorBindsTheHandle() throws Exception {
        Spiffy s = (Spiffy)SqlObjectBuilder.onDemand((IDBI)this.dbi, Spiffy.class);
        s.insert(1L, "Tom");
        s.insert(2L, "Sam");
        Assert.assertNotSame((Object)s.getHandle(), (Object)s.getHandle());
        ResultIterator<Something> all = s.findAll();
        Assert.assertSame((Object)s.getHandle(), (Object)s.getHandle());
        all.next();
        Assert.assertSame((Object)s.getHandle(), (Object)s.getHandle());
        all.next();
        Assert.assertFalse((boolean)all.hasNext());
        Assert.assertNotSame((Object)s.getHandle(), (Object)s.getHandle());
    }

    @Test(expected=TransactionException.class)
    public void testExceptionOnClose() throws Exception {
        DBI dbi = new DBI((DataSource)this.ds){

            public Handle open() {
                Handle h = (Handle)EasyMock.createMock(Handle.class);
                h.createStatement(EasyMock.anyString());
                EasyMock.expectLastCall().andThrow((Throwable)new TransactionException("connection reset"));
                h.close();
                EasyMock.expectLastCall().andThrow((Throwable)new UnableToCloseResourceException("already closed", null));
                EasyMock.replay((Object[])new Object[]{h});
                return h;
            }
        };
        Spiffy s = (Spiffy)SqlObjectBuilder.onDemand((IDBI)dbi, Spiffy.class);
        s.insert(1L, "Tom");
    }

    @Test
    public void testIteratorCloseHandleOnError() throws Exception {
        HandleTrackerDBI dbi = new HandleTrackerDBI((DataSource)this.ds);
        Spiffy s = (Spiffy)SqlObjectBuilder.onDemand((IDBI)dbi, Spiffy.class);
        try {
            s.crashNow();
            Assert.fail();
        }
        catch (DBIException dBIException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)dbi.hasOpenedHandle());
    }

    @Test
    public void testIteratorClosedOnReadError() throws Exception {
        HandleTrackerDBI dbi = new HandleTrackerDBI((DataSource)this.ds);
        Spiffy spiffy = (Spiffy)SqlObjectBuilder.onDemand((IDBI)dbi, Spiffy.class);
        spiffy.insert(1L, "Tom");
        Iterator<Something> i = spiffy.crashOnFirstRead();
        try {
            i.next();
            Assert.fail();
        }
        catch (DBIException dBIException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)dbi.hasOpenedHandle());
    }

    @Test
    public void testIteratorClosedIfEmpty() throws Exception {
        HandleTrackerDBI dbi = new HandleTrackerDBI((DataSource)this.ds);
        Spiffy spiffy = (Spiffy)SqlObjectBuilder.onDemand((IDBI)dbi, Spiffy.class);
        ResultIterator<Something> nothing = spiffy.findAll();
        Assert.assertFalse((boolean)dbi.hasOpenedHandle());
    }

    @Test
    public void testIteratorPrepatureClose() throws Exception {
        HandleTrackerDBI dbi = new HandleTrackerDBI((DataSource)this.ds);
        Spiffy spiffy = (Spiffy)SqlObjectBuilder.onDemand((IDBI)dbi, Spiffy.class);
        spiffy.insert(1L, "Tom");
        ResultIterator<Something> all = spiffy.findAll();
        all.close();
        Assert.assertFalse((boolean)dbi.hasOpenedHandle());
    }

    @Test
    public void testSqlFromExternalFileWorks() throws Exception {
        Spiffy spiffy = (Spiffy)SqlObjectBuilder.onDemand((IDBI)this.dbi, Spiffy.class);
        ExternalSql external = (ExternalSql)SqlObjectBuilder.onDemand((IDBI)this.dbi, ExternalSql.class);
        spiffy.insert(1L, "Tom");
        spiffy.insert(2L, "Sam");
        Iterator<Something> all = external.findAll();
        all.next();
        all.next();
        Assert.assertFalse((boolean)all.hasNext());
    }

    public static class HandleTrackerDBI
    extends DBI {
        final List<Handle> openedHandle = new ArrayList<Handle>();

        HandleTrackerDBI(DataSource dataSource) {
            super(dataSource);
        }

        public Handle open() {
            Handle h = super.open();
            this.openedHandle.add(h);
            return h;
        }

        boolean hasOpenedHandle() throws SQLException {
            for (Handle h : this.openedHandle) {
                if (h.getConnection().isClosed()) continue;
                return true;
            }
            return false;
        }
    }

    static class CrashingMapper
    implements ResultSetMapper<Something> {
        CrashingMapper() {
        }

        public Something map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            throw new SQLException("protocol error");
        }
    }

    public static interface ExternalSql
    extends GetHandle {
        @SqlQuery(value="all-something")
        @Mapper(value=SomethingMapper.class)
        public Iterator<Something> findAll();
    }

    public static interface TransactionStuff
    extends GetHandle,
    Transactional<TransactionStuff> {
        @SqlQuery(value="select id, name from something where id = :id")
        @Mapper(value=SomethingMapper.class)
        public Something byId(@Bind(value="id") long var1);

        @SqlUpdate(value="update something set name = :name where id = :id")
        public void updateName(@Bind(value="id") long var1, @Bind(value="name") String var3);

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);
    }

    public static interface Spiffy
    extends GetHandle {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);

        @SqlQuery(value="select name, id from something")
        @Mapper(value=SomethingMapper.class)
        public ResultIterator<Something> findAll();

        @SqlQuery(value="select * from crash now")
        @Mapper(value=SomethingMapper.class)
        public Iterator<Something> crashNow();

        @SqlQuery(value="select name, id from something")
        @Mapper(value=CrashingMapper.class)
        public Iterator<Something> crashOnFirstRead();
    }
}

