/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import org.h2.jdbcx.JdbcConnectionPool;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.GetGeneratedKeys;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.mixins.CloseMe;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class TestGetGeneratedKeysPostgres {
    private JdbcConnectionPool ds;
    private DBI dbi;

    @Before
    public void setUp() throws Exception {
        this.dbi = new DBI("jdbc:postgresql:test", "postgres", "postgres");
        this.dbi.withHandle((HandleCallback)new HandleCallback<Object>(){

            public Object withHandle(Handle handle) throws Exception {
                handle.execute("create sequence id_sequence INCREMENT 1 START WITH 100", new Object[0]);
                handle.execute("create table if not exists something (name text, id int DEFAULT nextval('id_sequence'), CONSTRAINT something_id PRIMARY KEY ( id ));", new Object[0]);
                return null;
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        this.dbi.withHandle((HandleCallback)new HandleCallback<Object>(){

            public Object withHandle(Handle handle) throws Exception {
                handle.execute("drop table something", new Object[0]);
                handle.execute("drop sequence id_sequence", new Object[0]);
                return null;
            }
        });
    }

    @Ignore
    @Test
    public void testFoo() throws Exception {
        DAO dao = (DAO)this.dbi.open(DAO.class);
        Long brian_id = dao.insert("Brian");
        long keith_id = dao.insert("Keith");
        Assert.assertThat((Object)dao.findNameById(brian_id), (Matcher)CoreMatchers.equalTo((Object)"Brian"));
        Assert.assertThat((Object)dao.findNameById(keith_id), (Matcher)CoreMatchers.equalTo((Object)"Keith"));
        dao.close();
    }

    public static interface DAO
    extends CloseMe {
        @SqlUpdate(value="insert into something (name, id) values (:name, nextval('id_sequence'))")
        @GetGeneratedKeys(columnName="id")
        public long insert(@Bind(value="name") String var1);

        @SqlQuery(value="select name from something where id = :it")
        public String findNameById(@Bind long var1);
    }
}

