/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.lang.annotation.Annotation;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.skife.jdbi.derby.DerbyHelper;
import org.skife.jdbi.v2.Binding;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.BindBeanFactory;
import org.skife.jdbi.v2.sqlobject.Binder;

public class TestBindBeanFactory {
    private static final DerbyHelper DERBY_HELPER = new DerbyHelper();

    @BeforeClass
    public static void setUpClass() throws Exception {
        DERBY_HELPER.start();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        DERBY_HELPER.stop();
    }

    @Test
    public void testBindBeanFactory() throws Exception {
        BindBeanFactory factory = new BindBeanFactory();
        Binder beanBinder = factory.build((Annotation)((Object)new BindBeanImpl()));
        DBI dbi = new DBI(DERBY_HELPER.getDataSource());
        Handle handle = dbi.open();
        Update testStatement = handle.createStatement("does not matter");
        TestBean testBean = new TestBean();
        beanBinder.bind((SQLStatement)testStatement, (Annotation)((Object)new BindBeanImpl()), (Object)testBean);
        StatementContext context = testStatement.getContext();
        Binding binding = context.getBinding();
        Assert.assertEquals((Object)"LongArgument", (Object)binding.forName("ALong").getClass().getSimpleName());
        Assert.assertEquals((Object)"BooleanArgument", (Object)binding.forName("ARealBoolean").getClass().getSimpleName());
        Assert.assertEquals((Object)"BooleanArgument", (Object)binding.forName("ANullBoolean").getClass().getSimpleName());
        Assert.assertEquals((Object)"StringArgument", (Object)binding.forName("AString").getClass().getSimpleName());
        Assert.assertEquals((Object)"ObjectArgument", (Object)binding.forName("AFoo").getClass().getSimpleName());
        Assert.assertEquals((Object)"ShortArgument", (Object)binding.forName("AShort").getClass().getSimpleName());
        handle.close();
    }

    static class BindBeanImpl
    implements BindBean {
        BindBeanImpl() {
        }

        public Class<? extends Annotation> annotationType() {
            return BindBean.class;
        }

        public String value() {
            return "___jdbi_bare___";
        }
    }

    public static class Foo {
    }

    public static class TestBean {
        public long getALong() {
            return 4815162342L;
        }

        public Boolean getARealBoolean() {
            return Boolean.TRUE;
        }

        public Boolean getANullBoolean() {
            return null;
        }

        public String getAString() {
            return "a string, what did you expect?";
        }

        public Foo getAFoo() {
            return new Foo();
        }

        public Short getAShort() {
            return (short)12345;
        }
    }
}

