/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.easymock.EasyMock;
import org.junit.Test;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.DBITestCase;

public class TestTransactionsAutoCommit
extends DBITestCase {
    @Test
    public void restoreAutoCommitInitialStateOnUnexpectedError() throws Exception {
        Connection connection = (Connection)EasyMock.createNiceMock(Connection.class);
        PreparedStatement statement = (PreparedStatement)EasyMock.createNiceMock(PreparedStatement.class);
        BasicHandle h = this.openHandle(connection);
        EasyMock.expect((Object)connection.getAutoCommit()).andReturn((Object)true);
        connection.setAutoCommit(false);
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)connection.prepareStatement("insert into something (id, name) values (?, ?)")).andReturn((Object)statement);
        EasyMock.expect((Object)statement.execute()).andReturn((Object)true);
        EasyMock.expect((Object)statement.getUpdateCount()).andReturn((Object)1);
        connection.commit();
        EasyMock.expectLastCall().andThrow((Throwable)new SQLException("infrastructure error"));
        connection.setAutoCommit(true);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{connection, statement});
        h.begin();
        try {
            h.insert("insert into something (id, name) values (?, ?)", new Object[]{1L, "Tom"});
            h.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{connection});
    }
}

