/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.CachingStatementBuilder;
import org.skife.jdbi.v2.ColonPrefixNamedParamStatementRewriter;
import org.skife.jdbi.v2.ContainerFactoryRegistry;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.DefaultStatementBuilder;
import org.skife.jdbi.v2.Foreman;
import org.skife.jdbi.v2.MappingRegistry;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TimingCollector;
import org.skife.jdbi.v2.logging.NoOpLog;
import org.skife.jdbi.v2.tweak.SQLLog;
import org.skife.jdbi.v2.tweak.StatementBuilder;
import org.skife.jdbi.v2.tweak.StatementRewriter;

public class TestTimingCollector
extends DBITestCase {
    private BasicHandle h;
    private TTC tc;

    @Override
    protected BasicHandle openHandle() throws SQLException {
        this.tc = new TTC();
        Connection conn = DERBY_HELPER.getConnection();
        BasicHandle h = new BasicHandle(this.getTransactionHandler(), this.getStatementLocator(), (StatementBuilder)new CachingStatementBuilder((StatementBuilder)new DefaultStatementBuilder()), (StatementRewriter)new ColonPrefixNamedParamStatementRewriter(), conn, new HashMap(), (SQLLog)new NoOpLog(), (TimingCollector)this.tc, new MappingRegistry(), new Foreman(), new ContainerFactoryRegistry());
        HANDLES.add(h);
        return h;
    }

    @Override
    public void doSetUp() throws Exception {
        this.h = this.openHandle();
    }

    @Override
    public void doTearDown() throws Exception {
        if (this.h != null) {
            this.h.close();
        }
    }

    @Test
    public void testStatement() throws Exception {
        int rows = this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        Assert.assertEquals((long)1L, (long)rows);
    }

    @Test
    public void testSimpleInsert() throws Exception {
        String statement = "insert into something (id, name) values (1, 'eric')";
        int c = this.h.insert(statement, new Object[0]);
        Assert.assertEquals((long)1L, (long)c);
        List<String> statements = this.tc.getStatements();
        Assert.assertEquals((long)1L, (long)statements.size());
        Assert.assertEquals((Object)statement, (Object)statements.get(0));
    }

    @Test
    public void testUpdate() throws Exception {
        String stmt1 = "insert into something (id, name) values (1, 'eric')";
        String stmt2 = "update something set name = 'ERIC' where id = 1";
        String stmt3 = "select * from something where id = 1";
        this.h.insert(stmt1, new Object[0]);
        this.h.createStatement(stmt2).execute();
        Something eric = (Something)this.h.createQuery(stmt3).map(Something.class).list().get(0);
        Assert.assertEquals((Object)"ERIC", (Object)eric.getName());
        List<String> statements = this.tc.getStatements();
        Assert.assertEquals((long)3L, (long)statements.size());
        Assert.assertEquals((Object)stmt1, (Object)statements.get(0));
        Assert.assertEquals((Object)stmt2, (Object)statements.get(1));
        Assert.assertEquals((Object)stmt3, (Object)statements.get(2));
    }

    @Test
    public void testSimpleUpdate() throws Exception {
        String stmt1 = "insert into something (id, name) values (1, 'eric')";
        String stmt2 = "update something set name = 'cire' where id = 1";
        String stmt3 = "select * from something where id = 1";
        this.h.insert(stmt1, new Object[0]);
        this.h.update(stmt2, new Object[0]);
        Something eric = (Something)this.h.createQuery(stmt3).map(Something.class).list().get(0);
        Assert.assertEquals((Object)"cire", (Object)eric.getName());
        List<String> statements = this.tc.getStatements();
        Assert.assertEquals((long)3L, (long)statements.size());
        Assert.assertEquals((Object)stmt1, (Object)statements.get(0));
        Assert.assertEquals((Object)stmt2, (Object)statements.get(1));
        Assert.assertEquals((Object)stmt3, (Object)statements.get(2));
    }

    private static class TTC
    implements TimingCollector {
        private List<String> statements = new ArrayList<String>();

        private TTC() {
        }

        public synchronized void collect(long elapsedTime, StatementContext ctx) {
            this.statements.add(ctx.getRawSql());
        }

        public synchronized List<String> getStatements() {
            return this.statements;
        }
    }
}

