/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.Something;

public class TestStatements
extends DBITestCase {
    private BasicHandle h;

    @Override
    public void doSetUp() throws Exception {
        this.h = this.openHandle();
    }

    @Override
    public void doTearDown() throws Exception {
        if (this.h != null) {
            this.h.close();
        }
    }

    @Test
    public void testStatement() throws Exception {
        int rows = this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        Assert.assertEquals((long)1L, (long)rows);
    }

    @Test
    public void testSimpleInsert() throws Exception {
        int c = this.h.insert("insert into something (id, name) values (1, 'eric')", new Object[0]);
        Assert.assertEquals((long)1L, (long)c);
    }

    @Test
    public void testUpdate() throws Exception {
        this.h.insert("insert into something (id, name) values (1, 'eric')", new Object[0]);
        this.h.createStatement("update something set name = 'ERIC' where id = 1").execute();
        Something eric = (Something)this.h.createQuery("select * from something where id = 1").map(Something.class).list().get(0);
        Assert.assertEquals((Object)"ERIC", (Object)eric.getName());
    }

    @Test
    public void testSimpleUpdate() throws Exception {
        this.h.insert("insert into something (id, name) values (1, 'eric')", new Object[0]);
        this.h.update("update something set name = 'cire' where id = 1", new Object[0]);
        Something eric = (Something)this.h.createQuery("select * from something where id = 1").map(Something.class).list().get(0);
        Assert.assertEquals((Object)"cire", (Object)eric.getName());
    }
}

