/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.Foreman;
import org.skife.jdbi.v2.LongArgument;
import org.skife.jdbi.v2.ObjectArgument;
import org.skife.jdbi.v2.ShortArgument;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.StringArgument;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class TestForeman {
    @Test
    public void testWaffling() {
        Foreman foreman = new Foreman();
        Argument longArgument = foreman.waffle(Object.class, (Object)new Long(3L), null);
        Assert.assertSame(LongArgument.class, longArgument.getClass());
        Argument shortArgument = foreman.waffle(Object.class, (Object)2000, null);
        Assert.assertSame(ShortArgument.class, shortArgument.getClass());
        Argument stringArgument = foreman.waffle(Object.class, (Object)"I am a String!", null);
        Assert.assertSame(StringArgument.class, stringArgument.getClass());
    }

    @Test
    public void testExplicitWaffling() {
        Foreman foreman = new Foreman();
        Argument longArgument = foreman.waffle(Long.class, (Object)new Long(3L), null);
        Assert.assertSame(LongArgument.class, longArgument.getClass());
        Argument shortArgument = foreman.waffle(Short.TYPE, (Object)2000, null);
        Assert.assertSame(ShortArgument.class, shortArgument.getClass());
        Argument stringArgument = foreman.waffle(String.class, (Object)"I am a String!", null);
        Assert.assertSame(StringArgument.class, stringArgument.getClass());
    }

    @Test
    public void testPull88WeirdClassArgumentFactory() {
        Foreman foreman = new Foreman();
        foreman.register((ArgumentFactory)new WeirdClassArgumentFactory());
        Assert.assertEquals(WeirdArgument.class, foreman.waffle(Weird.class, (Object)new Weird(), null).getClass());
        Assert.assertEquals(ObjectArgument.class, foreman.waffle(Object.class, (Object)new Weird(), null).getClass());
    }

    @Test
    public void testPull88NullClassArgumentFactory() {
        Foreman foreman = new Foreman();
        foreman.register((ArgumentFactory)new WeirdClassArgumentFactory());
        Assert.assertEquals(WeirdArgument.class, foreman.waffle(Weird.class, null, null).getClass());
        Assert.assertEquals(ObjectArgument.class, foreman.waffle(Object.class, null, null).getClass());
    }

    @Test
    public void testPull88WeirdValueArgumentFactory() {
        Foreman foreman = new Foreman();
        foreman.register((ArgumentFactory)new WeirdValueArgumentFactory());
        Assert.assertEquals(WeirdArgument.class, foreman.waffle(Weird.class, (Object)new Weird(), null).getClass());
        Assert.assertEquals(WeirdArgument.class, foreman.waffle(Object.class, (Object)new Weird(), null).getClass());
    }

    @Test
    public void testPull88NullValueArgumentFactory() {
        Foreman foreman = new Foreman();
        foreman.register((ArgumentFactory)new WeirdValueArgumentFactory());
        Assert.assertEquals(ObjectArgument.class, foreman.waffle(Weird.class, null, null).getClass());
        Assert.assertEquals(ObjectArgument.class, foreman.waffle(Object.class, null, null).getClass());
    }

    private static class WeirdArgument
    implements Argument {
        private WeirdArgument() {
        }

        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        }
    }

    private static class WeirdValueArgumentFactory
    implements ArgumentFactory<Weird> {
        private WeirdValueArgumentFactory() {
        }

        public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
            return value instanceof Weird;
        }

        public Argument build(Class<?> expectedType, Weird value, StatementContext ctx) {
            return new WeirdArgument();
        }
    }

    private static class WeirdClassArgumentFactory
    implements ArgumentFactory<Weird> {
        private WeirdClassArgumentFactory() {
        }

        public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
            return expectedType == Weird.class;
        }

        public Argument build(Class<?> expectedType, Weird value, StatementContext ctx) {
            return new WeirdArgument();
        }
    }

    private static class Weird {
        private Weird() {
        }
    }
}

