/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.derby;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.skife.jdbi.HandyMapThing;

public class DerbyHelper {
    public static final String DERBY_SYSTEM_HOME = "target/test-db";
    private Driver driver;
    private boolean running = false;
    private DataSource dataSource;
    private final String dbName = "testing-" + UUID.randomUUID().toString();

    public void start() throws SQLException, IOException {
        if (!this.running) {
            System.setProperty("derby.system.home", DERBY_SYSTEM_HOME);
            File db = new File(DERBY_SYSTEM_HOME);
            db.mkdirs();
            EmbeddedDataSource newDataSource = new EmbeddedDataSource();
            newDataSource.setCreateDatabase("create");
            newDataSource.setDatabaseName(this.dbName);
            this.dataSource = newDataSource;
            Connection conn = this.dataSource.getConnection();
            conn.close();
            this.running = true;
        }
    }

    public void stop() throws SQLException {
        String[] drops;
        Connection conn = this.getConnection();
        Statement delete = conn.createStatement();
        try {
            delete.execute("delete from something");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        delete.close();
        for (String drop : drops = new String[]{"drop table something", "drop function do_it", "drop procedure INSERTSOMETHING"}) {
            Statement stmt = conn.createStatement();
            try {
                stmt.execute(drop);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getJdbcConnectionString() {
        return "jdbc:derby:" + this.getDbName();
    }

    public void dropAndCreateSomething() throws SQLException {
        Connection conn = this.getConnection();
        Statement create = conn.createStatement();
        try {
            create.execute("create table something ( id integer, name varchar(50), integerValue integer, intValue integer )");
        }
        catch (Exception e) {
            create.execute("delete from something");
        }
        create.close();
        conn.close();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public static String doIt() {
        return "it";
    }

    public static <K> HandyMapThing<K> map(K k, Object v) {
        HandyMapThing<K> s = new HandyMapThing<K>();
        return s.add(k, v);
    }
}

