/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.ws;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;

public class EchoSocket
extends WebSocketAdapter {
    public void onWebSocketConnect(Session sess) {
        super.onWebSocketConnect(sess);
        sess.setIdleTimeout(10000L);
    }

    public void onWebSocketClose(int statusCode, String reason) {
        this.getSession().close();
        super.onWebSocketClose(statusCode, reason);
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        if (this.isNotConnected()) {
            return;
        }
        try {
            this.getRemote().sendBytes(ByteBuffer.wrap(payload, offset, len));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onWebSocketText(String message) {
        if (this.isNotConnected()) {
            return;
        }
        try {
            if (message.equals("CLOSE")) {
                this.getSession().close();
            } else {
                this.getRemote().sendString(message);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

