/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;
import org.asynchttpclient.request.body.multipart.FilePart;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FastUnauthorizedUploadTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                resp.setStatus(401);
                resp.getOutputStream().flush();
                resp.getOutputStream().close();
                baseRequest.setHandled(true);
            }
        };
    }

    @Test(groups={"standalone"})
    public void testUnauthorizedWhileUploading() throws Exception {
        File file = TestUtils.createTempFile(0x100000);
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            Response response = (Response)((BoundRequestBuilder)client.preparePut(this.getTargetUrl()).addBodyPart((Part)new FilePart("test", file, "application/octet-stream", StandardCharsets.UTF_8))).execute().get();
            Assert.assertEquals((int)response.getStatusCode(), (int)401);
        }
    }
}

