/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.proxy;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;
import org.asynchttpclient.config.AsyncHttpClientConfigHelper;
import org.asynchttpclient.proxy.ProxyServer;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ProxyTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new ProxyHandler();
    }

    @Test(groups={"standalone"})
    public void testRequestLevelProxy() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            String target = "http://localhost:1234/";
            ListenableFuture f = ((BoundRequestBuilder)client.prepareGet(target).setProxyServer(Dsl.proxyServer((String)"localhost", (int)this.port1))).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader("target"), (String)"/");
        }
    }

    @Test(groups={"standalone"})
    public void testGlobalProxy() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setProxyServer(Dsl.proxyServer((String)"localhost", (int)this.port1)));){
            String target = "http://localhost:1234/";
            ListenableFuture f = client.prepareGet(target).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader("target"), (String)"/");
        }
    }

    @Test(groups={"standalone"})
    public void testBothProxies() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setProxyServer(Dsl.proxyServer((String)"localhost", (int)(this.port1 - 1))));){
            String target = "http://localhost:1234/";
            ListenableFuture f = ((BoundRequestBuilder)client.prepareGet(target).setProxyServer(Dsl.proxyServer((String)"localhost", (int)this.port1))).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader("target"), (String)"/");
        }
    }

    @Test(groups={"standalone"})
    public void testNonProxyHost() {
        Request req = Dsl.get((String)"http://somewhere.com/foo").build();
        ProxyServer proxyServer = Dsl.proxyServer((String)"foo", (int)1234).setNonProxyHost("somewhere.com").build();
        Assert.assertTrue((boolean)proxyServer.isIgnoredForHost(req.getUri().getHost()));
        req = Dsl.get((String)"http://sub.somewhere.com/foo").build();
        proxyServer = Dsl.proxyServer((String)"foo", (int)1234).setNonProxyHost("*.somewhere.com").build();
        Assert.assertTrue((boolean)proxyServer.isIgnoredForHost(req.getUri().getHost()));
        req = Dsl.get((String)"http://sub.somewhere.com/foo").build();
        proxyServer = Dsl.proxyServer((String)"foo", (int)1234).setNonProxyHost("*.somewhere.com").build();
        Assert.assertTrue((boolean)proxyServer.isIgnoredForHost(req.getUri().getHost()));
    }

    @Test(groups={"standalone"})
    public void testNonProxyHostsRequestOverridesConfig() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        ProxyServer configProxy = Dsl.proxyServer((String)"localhost", (int)(this.port1 - 1)).build();
        ProxyServer requestProxy = Dsl.proxyServer((String)"localhost", (int)this.port1).setNonProxyHost("localhost").build();
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setProxyServer(configProxy));){
            String target = "http://localhost:1234/";
            ((BoundRequestBuilder)client.prepareGet(target).setProxyServer(requestProxy)).execute().get();
            Assert.assertFalse((boolean)true);
        }
        catch (Throwable e) {
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertEquals(e.getCause().getClass(), ConnectException.class);
        }
    }

    @Test(groups={"standalone"})
    public void testRequestNonProxyHost() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        ProxyServer proxy = Dsl.proxyServer((String)"localhost", (int)(this.port1 - 1)).setNonProxyHost("localhost").build();
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            String target = "http://localhost:" + this.port1 + "/";
            ListenableFuture f = ((BoundRequestBuilder)client.prepareGet(target).setProxyServer(proxy)).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader("target"), (String)"/");
        }
    }

    @Test(groups={"standalone"})
    public void runSequentiallyBecauseNotThreadSafe() throws Exception {
        this.testProxyProperties();
        this.testIgnoreProxyPropertiesByDefault();
        this.testProxyActivationProperty();
        this.testWildcardNonProxyHosts();
        this.testUseProxySelector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProxyProperties() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        Properties originalProps = new Properties();
        originalProps.putAll((Map<?, ?>)System.getProperties());
        System.setProperty("http.proxyHost", "127.0.0.1");
        System.setProperty("http.proxyPort", String.valueOf(this.port1));
        System.setProperty("http.nonProxyHosts", "localhost");
        AsyncHttpClientConfigHelper.reloadProperties();
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setUseProxyProperties(true));){
            String proxifiedtarget = "http://127.0.0.1:1234/";
            ListenableFuture f = client.prepareGet(proxifiedtarget).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader("target"), (String)"/");
            String nonProxifiedtarget = "http://localhost:1234/";
            f = client.prepareGet(nonProxifiedtarget).execute();
            try {
                resp = (Response)f.get(3L, TimeUnit.SECONDS);
                Assert.fail((String)"should not be able to connect");
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        finally {
            System.setProperties(originalProps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIgnoreProxyPropertiesByDefault() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        Properties originalProps = new Properties();
        originalProps.putAll((Map<?, ?>)System.getProperties());
        System.setProperty("http.proxyHost", "localhost");
        System.setProperty("http.proxyPort", String.valueOf(this.port1));
        System.setProperty("http.nonProxyHosts", "localhost");
        AsyncHttpClientConfigHelper.reloadProperties();
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            String target = "http://localhost:1234/";
            ListenableFuture f = client.prepareGet(target).execute();
            try {
                f.get(3L, TimeUnit.SECONDS);
                Assert.fail((String)"should not be able to connect");
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        finally {
            System.setProperties(originalProps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone"}, enabled=false)
    public void testProxyActivationProperty() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        Properties originalProps = new Properties();
        originalProps.putAll((Map<?, ?>)System.getProperties());
        System.setProperty("http.proxyHost", "127.0.0.1");
        System.setProperty("http.proxyPort", String.valueOf(this.port1));
        System.setProperty("http.nonProxyHosts", "localhost");
        System.setProperty("org.asynchttpclient.useProxyProperties", "true");
        AsyncHttpClientConfigHelper.reloadProperties();
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            String proxifiedTarget = "http://127.0.0.1:1234/";
            ListenableFuture f = client.prepareGet(proxifiedTarget).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader("target"), (String)"/");
            String nonProxifiedTarget = "http://localhost:1234/";
            f = client.prepareGet(nonProxifiedTarget).execute();
            try {
                resp = (Response)f.get(3L, TimeUnit.SECONDS);
                Assert.fail((String)"should not be able to connect");
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        finally {
            System.setProperties(originalProps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWildcardNonProxyHosts() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        Properties originalProps = new Properties();
        originalProps.putAll((Map<?, ?>)System.getProperties());
        System.setProperty("http.proxyHost", "127.0.0.1");
        System.setProperty("http.proxyPort", String.valueOf(this.port1));
        System.setProperty("http.nonProxyHosts", "127.*");
        AsyncHttpClientConfigHelper.reloadProperties();
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setUseProxyProperties(true));){
            String nonProxifiedTarget = "http://127.0.0.1:1234/";
            ListenableFuture f = client.prepareGet(nonProxifiedTarget).execute();
            try {
                f.get(3L, TimeUnit.SECONDS);
                Assert.fail((String)"should not be able to connect");
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        finally {
            System.setProperties(originalProps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUseProxySelector() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        ProxySelector originalProxySelector = ProxySelector.getDefault();
        ProxySelector.setDefault(new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                if (uri.getHost().equals("127.0.0.1")) {
                    return Arrays.asList(new Proxy(Proxy.Type.HTTP, new InetSocketAddress("127.0.0.1", ProxyTest.this.port1)));
                }
                return Arrays.asList(Proxy.NO_PROXY);
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        });
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setUseProxySelector(true));){
            String proxifiedTarget = "http://127.0.0.1:1234/";
            ListenableFuture f = client.prepareGet(proxifiedTarget).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader("target"), (String)"/");
            String nonProxifiedTarget = "http://localhost:1234/";
            f = client.prepareGet(nonProxifiedTarget).execute();
            try {
                f.get(3L, TimeUnit.SECONDS);
                Assert.fail((String)"should not be able to connect");
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        finally {
            ProxySelector.setDefault(originalProxySelector);
        }
    }

    public static class ProxyHandler
    extends AbstractHandler {
        public void handle(String s, org.eclipse.jetty.server.Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if ("GET".equalsIgnoreCase(request.getMethod())) {
                response.addHeader("target", r.getHttpURI().getPath());
                response.setStatus(200);
            } else {
                response.sendError(403);
            }
            r.setHandled(true);
        }
    }
}

