/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.exception.RemotelyClosedException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RetryRequestTest
extends AbstractBasicTest {
    @Override
    protected String getTargetUrl() {
        return String.format("http://localhost:%d/", this.port1);
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new SlowAndBigHandler();
    }

    @Test(groups={"standalone"})
    public void testMaxRetry() throws Exception {
        try (AsyncHttpClient ahc = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setMaxRequestRetry(0));){
            ahc.executeRequest(ahc.prepareGet(this.getTargetUrl()).build()).get();
            Assert.fail();
        }
        catch (Exception t) {
            Assert.assertEquals((Object)t.getCause(), (Object)RemotelyClosedException.INSTANCE);
        }
    }

    public static class SlowAndBigHandler
    extends AbstractHandler {
        public void handle(String pathInContext, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            int load = 100;
            httpResponse.setStatus(200);
            httpResponse.setContentLength(load);
            httpResponse.setContentType("application/octet-stream");
            httpResponse.flushBuffer();
            ServletOutputStream os = httpResponse.getOutputStream();
            for (int i = 0; i < load; ++i) {
                os.write(i % 255);
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (i <= load / 10) continue;
                httpResponse.sendError(500);
            }
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

