/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.cookie.Cookie;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RemoteSiteTest
extends AbstractBasicTest {
    public static final String URL = "http://google.com?q=";
    public static final String REQUEST_PARAM = "github github \ngithub";

    @Test(groups={"online"})
    public void testGoogleCom() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setRequestTimeout(10000));){
            Response response = (Response)c.prepareGet("http://www.google.com/").execute().get(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)response);
        }
    }

    @Test(groups={"online"}, enabled=false)
    public void testMicrosoftCom() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setRequestTimeout(10000));){
            Response response = (Response)c.prepareGet("http://microsoft.com/").execute().get(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)301);
        }
    }

    @Test(groups={"online"}, enabled=false)
    public void testWwwMicrosoftCom() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setRequestTimeout(10000));){
            Response response = (Response)c.prepareGet("http://www.microsoft.com/").execute().get(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)302);
        }
    }

    @Test(groups={"online"}, enabled=false)
    public void testUpdateMicrosoftCom() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setRequestTimeout(10000));){
            Response response = (Response)c.prepareGet("http://update.microsoft.com/").execute().get(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)302);
        }
    }

    @Test(groups={"online"})
    public void testGoogleComWithTimeout() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setRequestTimeout(10000));){
            Response response = (Response)c.prepareGet("http://google.com/").execute().get(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)response);
            Assert.assertTrue((response.getStatusCode() == 301 || response.getStatusCode() == 302 ? 1 : 0) != 0);
        }
    }

    @Test(groups={"online"})
    public void asyncStatusHEADContentLenghtTest() throws Exception {
        try (AsyncHttpClient p = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true));){
            final CountDownLatch l = new CountDownLatch(1);
            p.executeRequest(Dsl.head((String)"http://www.google.com/"), (AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)200);
                        Response response2 = response;
                        return response2;
                    }
                    finally {
                        l.countDown();
                    }
                }
            }).get();
            if (!l.await(5L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    @Test(groups={"online"}, enabled=false)
    public void invalidStreamTest2() throws Exception {
        DefaultAsyncHttpClientConfig config = Dsl.config().setRequestTimeout(10000).setFollowRedirect(true).setKeepAlive(false).setMaxRedirects(6).build();
        try (AsyncHttpClient c = Dsl.asyncHttpClient((AsyncHttpClientConfig)config);){
            Response response = (Response)c.prepareGet("http://bit.ly/aUjTtG").execute().get();
            if (response != null) {
                System.out.println(response);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.assertNotNull((Object)t.getCause());
            Assert.assertEquals((String)t.getCause().getMessage(), (String)"invalid version format: ICY");
        }
    }

    @Test(groups={"online"})
    public void asyncFullBodyProperlyRead() throws Exception {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            Response r = (Response)client.prepareGet("http://www.typesafe.com/").execute().get();
            InputStream stream = r.getResponseBodyAsStream();
            int contentLength = Integer.valueOf(r.getHeader("Content-Length"));
            Assert.assertEquals((int)contentLength, (int)IOUtils.toByteArray((InputStream)stream).length);
        }
    }

    @Test(groups={"online"}, enabled=false)
    public void testUrlRequestParametersEncoding() throws Exception {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            String requestUrl2 = URL + URLEncoder.encode(REQUEST_PARAM, StandardCharsets.UTF_8.name());
            this.logger.info(String.format("Executing request [%s] ...", requestUrl2));
            Response response = (Response)client.prepareGet(requestUrl2).execute().get();
            Assert.assertEquals((int)response.getStatusCode(), (int)302);
        }
    }

    @Test(groups={"online"})
    public void stripQueryStringTest() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true));){
            Response response = (Response)c.prepareGet("http://www.freakonomics.com/?p=55846").execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"online"})
    public void evilCoookieTest() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            RequestBuilder builder = (RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)Dsl.get((String)"http://localhost").setFollowRedirect(true)).setUrl("http://www.google.com/")).addHeader((CharSequence)"Content-Type", "text/plain")).addCookie(new Cookie("evilcookie", "test", false, ".google.com", "/", Long.MIN_VALUE, false, false));
            Response response = (Response)c.executeRequest(builder.build()).get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"online"}, enabled=false)
    public void testAHC62Com() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true));){
            Response response = (Response)c.prepareGet("http://api.crunchbase.com/v/1/financial-organization/kinsey-hills-group.js").execute((AsyncHandler)new AsyncHandler<Response>(){
                private Response.ResponseBuilder builder = new Response.ResponseBuilder();

                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                }

                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    System.out.println(bodyPart.getBodyPartBytes().length);
                    this.builder.accumulate(bodyPart);
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    this.builder.accumulate(responseStatus);
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onHeadersReceived(HttpResponseHeaders headers) throws Exception {
                    this.builder.accumulate(headers);
                    return AsyncHandler.State.CONTINUE;
                }

                public Response onCompleted() throws Exception {
                    return this.builder.build();
                }
            }).get(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)response);
            Assert.assertTrue((response.getResponseBody().length() >= 3870 ? 1 : 0) != 0);
        }
    }
}

