/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Realm;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.StringUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RealmTest {
    @Test(groups={"standalone"})
    public void testClone() {
        Realm orig = Dsl.basicAuthRealm((String)"user", (String)"pass").setCharset(StandardCharsets.UTF_16).setUsePreemptiveAuth(true).setRealmName("realm").setAlgorithm("algo").build();
        Realm clone = Dsl.realm((Realm)orig).build();
        Assert.assertEquals((String)clone.getPrincipal(), (String)orig.getPrincipal());
        Assert.assertEquals((String)clone.getPassword(), (String)orig.getPassword());
        Assert.assertEquals((Object)clone.getCharset(), (Object)orig.getCharset());
        Assert.assertEquals((boolean)clone.isUsePreemptiveAuth(), (boolean)orig.isUsePreemptiveAuth());
        Assert.assertEquals((String)clone.getRealmName(), (String)orig.getRealmName());
        Assert.assertEquals((String)clone.getAlgorithm(), (String)orig.getAlgorithm());
        Assert.assertEquals((Object)clone.getScheme(), (Object)orig.getScheme());
    }

    @Test(groups={"standalone"})
    public void testOldDigestEmptyString() throws Exception {
        this.testOldDigest("");
    }

    @Test(groups={"standalone"})
    public void testOldDigestNull() throws Exception {
        this.testOldDigest(null);
    }

    private void testOldDigest(String qop) throws Exception {
        String user = "user";
        String pass = "pass";
        String realm = "realm";
        String nonce = "nonce";
        String method = "GET";
        Uri uri = Uri.create((String)"http://ahc.io/foo");
        Realm orig = Dsl.digestAuthRealm((String)user, (String)pass).setNonce(nonce).setUri(uri).setMethodName(method).setRealmName(realm).setQop(qop).build();
        String ha1 = this.getMd5(user + ":" + realm + ":" + pass);
        String ha2 = this.getMd5(method + ":" + uri.getPath());
        String expectedResponse = this.getMd5(ha1 + ":" + nonce + ":" + ha2);
        Assert.assertEquals((String)orig.getResponse(), (String)expectedResponse);
    }

    @Test(groups={"standalone"})
    public void testStrongDigest() throws Exception {
        String user = "user";
        String pass = "pass";
        String realm = "realm";
        String nonce = "nonce";
        String method = "GET";
        Uri uri = Uri.create((String)"http://ahc.io/foo");
        String qop = "auth";
        Realm orig = Dsl.digestAuthRealm((String)user, (String)pass).setNonce(nonce).setUri(uri).setMethodName(method).setRealmName(realm).setQop(qop).build();
        String nc = orig.getNc();
        String cnonce = orig.getCnonce();
        String ha1 = this.getMd5(user + ":" + realm + ":" + pass);
        String ha2 = this.getMd5(method + ":" + uri.getPath());
        String expectedResponse = this.getMd5(ha1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + ha2);
        Assert.assertEquals((String)orig.getResponse(), (String)expectedResponse);
    }

    private String getMd5(String what) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(what.getBytes(StandardCharsets.ISO_8859_1));
        byte[] hash = md.digest();
        return StringUtils.toHexString((byte[])hash);
    }
}

