/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaders;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.asynchttpclient.test.TestUtils;
import org.asynchttpclient.testserver.HttpServer;
import org.asynchttpclient.testserver.HttpTest;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AsyncStreamHandlerTest
extends HttpTest {
    private static final String RESPONSE = "param_1_";
    private static HttpServer server;

    @BeforeClass
    public static void start() throws Throwable {
        server = new HttpServer();
        server.start();
    }

    @AfterClass
    public static void stop() throws Throwable {
        server.close();
    }

    private static String getTargetUrl() {
        return server.getHttpUrl() + "/foo/bar";
    }

    @Test
    public void getWithOnHeadersReceivedAbort() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            client.prepareGet(AsyncStreamHandlerTest.getTargetUrl()).execute((AsyncHandler)new TestUtils.AsyncHandlerAdapter(){

                @Override
                public AsyncHandler.State onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    TestUtils.assertContentTypesEquals(content.getHeaders().get("Content-Type"), "text/html;charset=UTF-8");
                    return AsyncHandler.State.ABORT;
                }
            }).get(5L, TimeUnit.SECONDS);
        }));
    }

    @Test
    public void asyncStreamPOSTTest() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            String responseBody = (String)((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(AsyncStreamHandlerTest.getTargetUrl()).setHeader((CharSequence)"Content-Type", "application/x-www-form-urlencoded")).addFormParam("param_1", "value_1")).execute((AsyncHandler)new TestUtils.AsyncHandlerAdapter(){
                private StringBuilder builder = new StringBuilder();

                @Override
                public AsyncHandler.State onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    TestUtils.assertContentTypesEquals(content.getHeaders().get("Content-Type"), "text/html;charset=UTF-8");
                    return AsyncHandler.State.CONTINUE;
                }

                @Override
                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
                    this.builder.append(new String(content.getBodyPartBytes(), StandardCharsets.US_ASCII));
                    return AsyncHandler.State.CONTINUE;
                }

                @Override
                public String onCompleted() throws Exception {
                    return this.builder.toString().trim();
                }
            }).get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((String)responseBody, (String)RESPONSE);
        }));
    }

    @Test
    public void asyncStreamInterruptTest() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            final AtomicBoolean onHeadersReceived = new AtomicBoolean();
            final AtomicBoolean onBodyPartReceived = new AtomicBoolean();
            final AtomicBoolean onThrowable = new AtomicBoolean();
            ((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(AsyncStreamHandlerTest.getTargetUrl()).setHeader((CharSequence)"Content-Type", "application/x-www-form-urlencoded")).addFormParam("param_1", "value_1")).execute((AsyncHandler)new TestUtils.AsyncHandlerAdapter(){

                @Override
                public AsyncHandler.State onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    onHeadersReceived.set(true);
                    TestUtils.assertContentTypesEquals(content.getHeaders().get("Content-Type"), "text/html;charset=UTF-8");
                    return AsyncHandler.State.ABORT;
                }

                @Override
                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
                    onBodyPartReceived.set(true);
                    return AsyncHandler.State.ABORT;
                }

                @Override
                public void onThrowable(Throwable t) {
                    onThrowable.set(true);
                }
            }).get(5L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)onHeadersReceived.get(), (String)"Headers weren't received");
            Assert.assertFalse((boolean)onBodyPartReceived.get(), (String)"Abort not working");
            Assert.assertFalse((boolean)onThrowable.get(), (String)"Shouldn't get an exception");
        }));
    }

    @Test
    public void asyncStreamFutureTest() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            final AtomicBoolean onHeadersReceived = new AtomicBoolean();
            final AtomicBoolean onThrowable = new AtomicBoolean();
            String responseBody = (String)((BoundRequestBuilder)client.preparePost(AsyncStreamHandlerTest.getTargetUrl()).addFormParam("param_1", "value_1")).execute((AsyncHandler)new TestUtils.AsyncHandlerAdapter(){
                private StringBuilder builder = new StringBuilder();

                @Override
                public AsyncHandler.State onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    TestUtils.assertContentTypesEquals(content.getHeaders().get("Content-Type"), "text/html;charset=UTF-8");
                    onHeadersReceived.set(true);
                    return AsyncHandler.State.CONTINUE;
                }

                @Override
                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
                    this.builder.append(new String(content.getBodyPartBytes()));
                    return AsyncHandler.State.CONTINUE;
                }

                @Override
                public String onCompleted() throws Exception {
                    return this.builder.toString().trim();
                }

                @Override
                public void onThrowable(Throwable t) {
                    onThrowable.set(true);
                }
            }).get(5L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)onHeadersReceived.get(), (String)"Headers weren't received");
            Assert.assertFalse((boolean)onThrowable.get(), (String)"Shouldn't get an exception");
            Assert.assertEquals((String)responseBody, (String)RESPONSE, (String)"Unexpected response body");
        }));
    }

    @Test
    public void asyncStreamThrowableRefusedTest() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            final CountDownLatch l = new CountDownLatch(1);
            client.prepareGet(AsyncStreamHandlerTest.getTargetUrl()).execute((AsyncHandler)new TestUtils.AsyncHandlerAdapter(){

                @Override
                public AsyncHandler.State onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    throw new RuntimeException("FOO");
                }

                @Override
                public void onThrowable(Throwable t) {
                    try {
                        if (t.getMessage() != null) {
                            Assert.assertEquals((String)t.getMessage(), (String)"FOO");
                        }
                    }
                    finally {
                        l.countDown();
                    }
                }
            });
            if (!l.await(10L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
        }));
    }

    @Test
    public void asyncStreamReusePOSTTest() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            final AtomicReference responseHeaders = new AtomicReference();
            BoundRequestBuilder rb = (BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(AsyncStreamHandlerTest.getTargetUrl()).setHeader((CharSequence)"Content-Type", "application/x-www-form-urlencoded")).addFormParam("param_1", "value_1");
            ListenableFuture f = rb.execute((AsyncHandler)new TestUtils.AsyncHandlerAdapter(){
                private StringBuilder builder = new StringBuilder();

                @Override
                public AsyncHandler.State onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    responseHeaders.set(content.getHeaders());
                    return AsyncHandler.State.CONTINUE;
                }

                @Override
                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
                    this.builder.append(new String(content.getBodyPartBytes()));
                    return AsyncHandler.State.CONTINUE;
                }

                @Override
                public String onCompleted() throws Exception {
                    return this.builder.toString();
                }
            });
            String r = (String)f.get(5L, TimeUnit.SECONDS);
            HttpHeaders h = (HttpHeaders)responseHeaders.get();
            Assert.assertNotNull((Object)h, (String)"Should receive non null headers");
            TestUtils.assertContentTypesEquals(h.get("Content-Type"), "text/html;charset=UTF-8");
            Assert.assertNotNull((Object)r, (String)"No response body");
            Assert.assertEquals((String)r.trim(), (String)RESPONSE, (String)"Unexpected response body");
            responseHeaders.set(null);
            server.enqueueEcho();
            f = rb.execute((AsyncHandler)new TestUtils.AsyncHandlerAdapter(){
                private StringBuilder builder = new StringBuilder();

                @Override
                public AsyncHandler.State onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    responseHeaders.set(content.getHeaders());
                    return AsyncHandler.State.CONTINUE;
                }

                @Override
                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
                    this.builder.append(new String(content.getBodyPartBytes()));
                    return AsyncHandler.State.CONTINUE;
                }

                @Override
                public String onCompleted() throws Exception {
                    return this.builder.toString();
                }
            });
            f.get(5L, TimeUnit.SECONDS);
            h = (HttpHeaders)responseHeaders.get();
            Assert.assertNotNull((Object)h, (String)"Should receive non null headers");
            TestUtils.assertContentTypesEquals(h.get("Content-Type"), "text/html;charset=UTF-8");
            Assert.assertNotNull((Object)r, (String)"No response body");
            Assert.assertEquals((String)r.trim(), (String)RESPONSE, (String)"Unexpected response body");
        }));
    }

    @Test
    public void asyncStream302RedirectWithBody() throws Throwable {
        this.withClient(Dsl.config().setFollowRedirect(true)).run(client -> this.withServer(server).run(server -> {
            String originalUrl = server.getHttpUrl() + "/original";
            String redirectUrl = server.getHttpUrl() + "/redirect";
            server.enqueueResponse(response -> {
                response.setStatus(302);
                response.setHeader("Location", redirectUrl);
                response.getOutputStream().println("You are being asked to redirect to " + redirectUrl);
            });
            server.enqueueOk();
            Response response2 = (Response)client.prepareGet(originalUrl).execute().get(20L, TimeUnit.SECONDS);
            Assert.assertEquals((int)response2.getStatusCode(), (int)200);
            Assert.assertTrue((boolean)response2.getResponseBody().isEmpty());
        }));
    }

    @Test(timeOut=3000L)
    public void asyncStreamJustStatusLine() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            final int STATUS = 0;
            final int COMPLETED = 1;
            final int OTHER = 2;
            final boolean[] whatCalled = new boolean[]{false, false, false};
            final CountDownLatch latch = new CountDownLatch(1);
            ListenableFuture statusCode = client.prepareGet(AsyncStreamHandlerTest.getTargetUrl()).execute((AsyncHandler)new AsyncHandler<Integer>(){
                private int status = -1;

                public void onThrowable(Throwable t) {
                    whatCalled[OTHER] = true;
                    latch.countDown();
                }

                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    whatCalled[OTHER] = true;
                    latch.countDown();
                    return AsyncHandler.State.ABORT;
                }

                public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    whatCalled[STATUS] = true;
                    this.status = responseStatus.getStatusCode();
                    latch.countDown();
                    return AsyncHandler.State.ABORT;
                }

                public AsyncHandler.State onHeadersReceived(HttpResponseHeaders headers) throws Exception {
                    whatCalled[OTHER] = true;
                    latch.countDown();
                    return AsyncHandler.State.ABORT;
                }

                public Integer onCompleted() throws Exception {
                    whatCalled[COMPLETED] = true;
                    latch.countDown();
                    return this.status;
                }
            });
            if (!latch.await(2L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout");
                return;
            }
            Integer status = (Integer)statusCode.get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((int)status, (int)200, (String)"Expected status code failed.");
            if (!whatCalled[0]) {
                Assert.fail((String)"onStatusReceived not called.");
            }
            if (!whatCalled[1]) {
                Assert.fail((String)"onCompleted not called.");
            }
            if (whatCalled[2]) {
                Assert.fail((String)"Other method of AsyncHandler got called.");
            }
        }));
    }

    @Test(groups={"online"})
    public void asyncOptionsTest() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            final AtomicReference responseHeaders = new AtomicReference();
            Object[] expected = new String[]{"GET", "HEAD", "OPTIONS", "POST"};
            ListenableFuture f = client.prepareOptions("http://www.apache.org/").execute((AsyncHandler)new TestUtils.AsyncHandlerAdapter(){

                @Override
                public AsyncHandler.State onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    responseHeaders.set(content.getHeaders());
                    return AsyncHandler.State.ABORT;
                }

                @Override
                public String onCompleted() throws Exception {
                    return "OK";
                }
            });
            f.get(20L, TimeUnit.SECONDS);
            HttpHeaders h = (HttpHeaders)responseHeaders.get();
            Assert.assertNotNull((Object)h);
            Object[] values = h.get("Allow").split(",|, ");
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((int)values.length, (int)expected.length);
            Arrays.sort(values);
            Assert.assertEquals((Object[])values, (Object[])expected);
        }));
    }

    @Test
    public void closeConnectionTest() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            Response r = (Response)client.prepareGet(AsyncStreamHandlerTest.getTargetUrl()).execute((AsyncHandler)new AsyncHandler<Response>(){
                private Response.ResponseBuilder builder = new Response.ResponseBuilder();

                public AsyncHandler.State onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    this.builder.accumulate(content);
                    return AsyncHandler.State.CONTINUE;
                }

                public void onThrowable(Throwable t) {
                }

                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
                    this.builder.accumulate(content);
                    return content.isLast() ? AsyncHandler.State.ABORT : AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    this.builder.accumulate(responseStatus);
                    return AsyncHandler.State.CONTINUE;
                }

                public Response onCompleted() throws Exception {
                    return this.builder.build();
                }
            }).get();
            Assert.assertNotNull((Object)r);
            Assert.assertEquals((int)r.getStatusCode(), (int)200);
        }));
    }
}

