/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.hive.druid.com.google.common.collect.ImmutableMultiset;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableTableScan;
import org.apache.hive.druid.org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.hive.druid.org.apache.calcite.linq4j.Enumerator;
import org.apache.hive.druid.org.apache.calcite.linq4j.Linq4j;
import org.apache.hive.druid.org.apache.calcite.linq4j.QueryProvider;
import org.apache.hive.druid.org.apache.calcite.linq4j.Queryable;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptTable;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.schema.QueryableTable;
import org.apache.hive.druid.org.apache.calcite.schema.SchemaPlus;
import org.apache.hive.druid.org.apache.calcite.schema.Table;
import org.apache.hive.druid.org.apache.calcite.schema.TranslatableTable;
import org.apache.hive.druid.org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.hive.druid.org.apache.calcite.test.CalciteAssert;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TableInRootSchemaTest {
    @Test
    public void testAddingTableInRootSchema() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        calciteConnection.getRootSchema().add("SAMPLE", (Table)new SimpleTable());
        Statement statement = calciteConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("select A, SUM(B) from SAMPLE group by A");
        Assert.assertThat((Object)ImmutableMultiset.of((Object)"A=foo; EXPR$1=8", (Object)"A=bar; EXPR$1=4"), (Matcher)CoreMatchers.equalTo(CalciteAssert.toSet(resultSet)));
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Assert.assertThat((Object)resultSetMetaData.getColumnName(1), (Matcher)CoreMatchers.equalTo((Object)"A"));
        Assert.assertThat((Object)resultSetMetaData.getTableName(1), (Matcher)CoreMatchers.equalTo((Object)"SAMPLE"));
        Assert.assertThat((Object)resultSetMetaData.getSchemaName(1), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)resultSetMetaData.getColumnClassName(1), (Matcher)CoreMatchers.equalTo((Object)"java.lang.String"));
        Assert.assertThat((Object)resultSetMetaData.getColumnName(2), (Matcher)CoreMatchers.equalTo((Object)"EXPR$1"));
        Assert.assertThat((Object)resultSetMetaData.getTableName(2), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)resultSetMetaData.getSchemaName(2), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)resultSetMetaData.getColumnClassName(2), (Matcher)CoreMatchers.equalTo((Object)"java.lang.Integer"));
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static class SimpleTable
    extends AbstractQueryableTable
    implements TranslatableTable {
        private String[] columnNames = new String[]{"A", "B"};
        private Class[] columnTypes = new Class[]{String.class, Integer.class};
        private Object[][] rows = new Object[3][];

        SimpleTable() {
            super(Object[].class);
            this.rows[0] = new Object[]{"foo", 5};
            this.rows[1] = new Object[]{"bar", 4};
            this.rows[2] = new Object[]{"foo", 3};
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            int columnCount = this.columnNames.length;
            ArrayList<Pair> columnDesc = new ArrayList<Pair>(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                RelDataType colType = typeFactory.createJavaType(this.columnTypes[i]);
                columnDesc.add(Pair.of((Object)this.columnNames[i], (Object)colType));
            }
            return typeFactory.createStructType(columnDesc);
        }

        public Iterator<Object[]> iterator() {
            return Linq4j.enumeratorIterator(this.enumerator());
        }

        public Enumerator<Object[]> enumerator() {
            return this.enumeratorImpl(null);
        }

        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            return new AbstractTableQueryable<T>(queryProvider, schema, (QueryableTable)this, tableName){

                public Enumerator<T> enumerator() {
                    return SimpleTable.this.enumeratorImpl(null);
                }
            };
        }

        private Enumerator<Object[]> enumeratorImpl(final int[] fields) {
            return new Enumerator<Object[]>(){
                private Object[] current;
                private Iterator<Object[]> iterator;
                {
                    this.iterator = Arrays.asList(SimpleTable.this.rows).iterator();
                }

                public Object[] current() {
                    return this.current;
                }

                public boolean moveNext() {
                    if (this.iterator.hasNext()) {
                        Object[] full = this.iterator.next();
                        this.current = fields != null ? this.convertRow(full) : full;
                        return true;
                    }
                    this.current = null;
                    return false;
                }

                public void reset() {
                    throw new UnsupportedOperationException();
                }

                public void close() {
                }

                private Object[] convertRow(Object[] full) {
                    Object[] objects = new Object[fields.length];
                    for (int i = 0; i < fields.length; ++i) {
                        objects[i] = full[fields[i]];
                    }
                    return objects;
                }
            };
        }

        public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
            return EnumerableTableScan.create((RelOptCluster)context.getCluster(), (RelOptTable)relOptTable);
        }
    }
}

