/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test;

import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.hive.druid.org.apache.calcite.runtime.CalciteContextException;
import org.apache.hive.druid.org.apache.calcite.runtime.CalciteException;
import org.apache.hive.druid.org.apache.calcite.runtime.Feature;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.sql.test.DefaultSqlTestFactory;
import org.apache.hive.druid.org.apache.calcite.sql.test.DelegatingSqlTestFactory;
import org.apache.hive.druid.org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.hive.druid.org.apache.calcite.sql.test.SqlTester;
import org.apache.hive.druid.org.apache.calcite.sql.test.SqlTesterImpl;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlConformance;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.hive.druid.org.apache.calcite.test.MockCatalogReader;
import org.apache.hive.druid.org.apache.calcite.test.SqlValidatorTestCase;
import org.apache.hive.druid.org.apache.calcite.util.Static;
import org.junit.Test;

public class SqlValidatorFeatureTest
extends SqlValidatorTestCase {
    private static final String FEATURE_DISABLED = "feature_disabled";
    private Feature disabledFeature;

    @Override
    public SqlTester getTester() {
        return new SqlTesterImpl(new FeatureTesterFactory());
    }

    @Test
    public void testDistinct() {
        this.checkFeature("select ^distinct^ name from dept", Static.RESOURCE.sQLFeature_E051_01());
    }

    @Test
    public void testOrderByDesc() {
        this.checkFeature("select name from dept order by ^name desc^", Static.RESOURCE.sQLConformance_OrderByDesc());
    }

    @Test
    public void testIntersect() {
        this.checkFeature("^select name from dept intersect select name from dept^", Static.RESOURCE.sQLFeature_F302());
    }

    @Test
    public void testExcept() {
        this.checkFeature("^select name from dept except select name from dept^", Static.RESOURCE.sQLFeature_E071_03());
    }

    @Test
    public void testMultiset() {
        this.checkFeature("values ^multiset[1]^", Static.RESOURCE.sQLFeature_S271());
        this.checkFeature("values ^multiset(select * from dept)^", Static.RESOURCE.sQLFeature_S271());
    }

    @Test
    public void testTablesample() {
        this.checkFeature("select name from ^dept tablesample bernoulli(50)^", Static.RESOURCE.sQLFeature_T613());
        this.checkFeature("select name from ^dept tablesample substitute('sample_dept')^", Static.RESOURCE.sQLFeatureExt_T613_Substitution());
    }

    private void checkFeature(String sql, Feature feature) {
        this.check(sql);
        try {
            this.disabledFeature = feature;
            this.checkFails(sql, FEATURE_DISABLED);
        }
        finally {
            this.disabledFeature = null;
        }
    }

    private class FeatureValidator
    extends SqlValidatorImpl {
        protected FeatureValidator(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory, SqlConformance conformance) {
            super(opTab, catalogReader, typeFactory, conformance);
        }

        protected void validateFeature(Feature feature, SqlParserPos context) {
            if (feature.equals((Object)SqlValidatorFeatureTest.this.disabledFeature)) {
                CalciteException ex = new CalciteException(SqlValidatorFeatureTest.FEATURE_DISABLED, null);
                if (context == null) {
                    throw ex;
                }
                throw new CalciteContextException("location", (Throwable)ex, context.getLineNum(), context.getColumnNum(), context.getEndLineNum(), context.getEndColumnNum());
            }
        }
    }

    private class FeatureTesterFactory
    extends DelegatingSqlTestFactory {
        FeatureTesterFactory() {
            super(DefaultSqlTestFactory.INSTANCE);
        }

        @Override
        public SqlValidator getValidator(SqlTestFactory factory) {
            SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
            SqlConformance conformance = (SqlConformance)this.get("conformance");
            boolean caseSensitive = (Boolean)this.get("caseSensitive");
            return new FeatureValidator(factory.createOperatorTable(factory), (SqlValidatorCatalogReader)new MockCatalogReader((RelDataTypeFactory)typeFactory, caseSensitive).init(), (RelDataTypeFactory)typeFactory, conformance);
        }
    }
}

