/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.hive.druid.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalProject;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.hive.druid.org.apache.calcite.rex.LogicVisitor;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexTransformer;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.test.SqlToRelTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RexTransformerTest {
    RexBuilder rexBuilder = null;
    RexNode x;
    RexNode y;
    RexNode z;
    RexNode trueRex;
    RexNode falseRex;
    RelDataType boolRelDataType;
    RelDataTypeFactory typeFactory;

    private static RelNode toRel(String sql) {
        SqlToRelTestBase test = new SqlToRelTestBase(){};
        return test.createTester().convertSqlToRel((String)sql).rel;
    }

    @Before
    public void setUp() {
        this.typeFactory = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        this.rexBuilder = new RexBuilder(this.typeFactory);
        this.boolRelDataType = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        this.x = new RexInputRef(0, this.typeFactory.createTypeWithNullability(this.boolRelDataType, true));
        this.y = new RexInputRef(1, this.typeFactory.createTypeWithNullability(this.boolRelDataType, true));
        this.z = new RexInputRef(2, this.typeFactory.createTypeWithNullability(this.boolRelDataType, true));
        this.trueRex = this.rexBuilder.makeLiteral(true);
        this.falseRex = this.rexBuilder.makeLiteral(false);
    }

    @After
    public void testDown() {
        this.typeFactory = null;
        this.rexBuilder = null;
        this.boolRelDataType = null;
        this.falseRex = null;
        this.trueRex = null;
        this.z = null;
        this.y = null;
        this.x = null;
    }

    void check(Boolean encapsulateType, RexNode node, String expected) {
        RexNode root = null == encapsulateType ? node : (encapsulateType.equals(Boolean.TRUE) ? this.isTrue(node) : this.isFalse(node));
        RexTransformer transformer = new RexTransformer(root, this.rexBuilder);
        RexNode result = transformer.transformNullSemantics();
        String actual = result.toString();
        if (!actual.equals(expected)) {
            String msg = "\nExpected=<" + expected + ">\n  Actual=<" + actual + ">";
            Assert.fail((String)msg);
        }
    }

    private RexNode lessThan(RexNode a0, RexNode a1) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{a0, a1});
    }

    private RexNode lessThanOrEqual(RexNode a0, RexNode a1) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{a0, a1});
    }

    private RexNode greaterThan(RexNode a0, RexNode a1) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{a0, a1});
    }

    private RexNode greaterThanOrEqual(RexNode a0, RexNode a1) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{a0, a1});
    }

    private RexNode equals(RexNode a0, RexNode a1) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{a0, a1});
    }

    private RexNode notEquals(RexNode a0, RexNode a1) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, new RexNode[]{a0, a1});
    }

    private RexNode and(RexNode a0, RexNode a1) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{a0, a1});
    }

    private RexNode or(RexNode a0, RexNode a1) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{a0, a1});
    }

    private RexNode not(RexNode a0) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{a0});
    }

    private RexNode plus(RexNode a0, RexNode a1) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{a0, a1});
    }

    private RexNode isNotNull(RexNode a0) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{a0});
    }

    private RexNode isFalse(RexNode node) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_FALSE, new RexNode[]{node});
    }

    private RexNode isTrue(RexNode node) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_TRUE, new RexNode[]{node});
    }

    @Test
    public void testPreTests() {
        RexInputRef node = new RexInputRef(0, this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.BOOLEAN), true));
        Assert.assertTrue((boolean)node.getType().isNullable());
        node = new RexInputRef(0, this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.BOOLEAN), false));
        Assert.assertFalse((boolean)node.getType().isNullable());
    }

    @Test
    public void testNonBooleans() {
        RexNode node = this.plus(this.x, this.y);
        String expected = node.toString();
        this.check(Boolean.TRUE, node, expected);
        this.check(Boolean.FALSE, node, expected);
        this.check(null, node, expected);
    }

    @Test
    public void testOrUnchanged() {
        RexNode node = this.or(this.x, this.y);
        String expected = node.toString();
        this.check(Boolean.TRUE, node, expected);
        this.check(Boolean.FALSE, node, expected);
        this.check(null, node, expected);
    }

    @Test
    public void testSimpleAnd() {
        RexNode node = this.and(this.x, this.y);
        this.check(Boolean.FALSE, node, "AND(AND(IS NOT NULL($0), IS NOT NULL($1)), AND($0, $1))");
    }

    @Test
    public void testSimpleEquals() {
        RexNode node = this.equals(this.x, this.y);
        this.check(Boolean.TRUE, node, "AND(AND(IS NOT NULL($0), IS NOT NULL($1)), =($0, $1))");
    }

    @Test
    public void testSimpleNotEquals() {
        RexNode node = this.notEquals(this.x, this.y);
        this.check(Boolean.FALSE, node, "AND(AND(IS NOT NULL($0), IS NOT NULL($1)), <>($0, $1))");
    }

    @Test
    public void testSimpleGreaterThan() {
        RexNode node = this.greaterThan(this.x, this.y);
        this.check(Boolean.TRUE, node, "AND(AND(IS NOT NULL($0), IS NOT NULL($1)), >($0, $1))");
    }

    @Test
    public void testSimpleGreaterEquals() {
        RexNode node = this.greaterThanOrEqual(this.x, this.y);
        this.check(Boolean.FALSE, node, "AND(AND(IS NOT NULL($0), IS NOT NULL($1)), >=($0, $1))");
    }

    @Test
    public void testSimpleLessThan() {
        RexNode node = this.lessThan(this.x, this.y);
        this.check(Boolean.TRUE, node, "AND(AND(IS NOT NULL($0), IS NOT NULL($1)), <($0, $1))");
    }

    @Test
    public void testSimpleLessEqual() {
        RexNode node = this.lessThanOrEqual(this.x, this.y);
        this.check(Boolean.FALSE, node, "AND(AND(IS NOT NULL($0), IS NOT NULL($1)), <=($0, $1))");
    }

    @Test
    public void testOptimizeNonNullLiterals() {
        RexNode node = this.lessThanOrEqual(this.x, this.trueRex);
        this.check(Boolean.TRUE, node, "AND(IS NOT NULL($0), <=($0, true))");
        node = this.lessThanOrEqual(this.trueRex, this.x);
        this.check(Boolean.FALSE, node, "AND(IS NOT NULL($0), <=(true, $0))");
    }

    @Test
    public void testSimpleIdentifier() {
        RexInputRef node = this.rexBuilder.makeInputRef(this.boolRelDataType, 0);
        this.check(Boolean.TRUE, (RexNode)node, "=(IS TRUE($0), true)");
    }

    @Test
    public void testMixed1() {
        RexNode op1 = this.equals(this.x, this.trueRex);
        RexNode and = this.and(op1, this.y);
        this.check(Boolean.FALSE, and, "AND(IS NOT NULL($1), AND(AND(IS NOT NULL($0), =($0, true)), $1))");
    }

    @Test
    public void testMixed2() {
        RexNode op1 = this.notEquals(this.x, this.trueRex);
        RexNode op2 = this.greaterThan(this.y, this.z);
        RexNode and = this.and(op1, op2);
        this.check(Boolean.FALSE, and, "AND(AND(IS NOT NULL($0), <>($0, true)), AND(AND(IS NOT NULL($1), IS NOT NULL($2)), >($1, $2)))");
    }

    @Test
    public void testMixed3() {
        RexNode op1 = this.equals(this.x, this.y);
        RexNode op2 = this.greaterThan(this.falseRex, this.z);
        RexNode and = this.and(op1, op2);
        this.check(Boolean.TRUE, and, "AND(AND(AND(IS NOT NULL($0), IS NOT NULL($1)), =($0, $1)), AND(IS NOT NULL($2), >(false, $2)))");
    }

    @Test
    public void testExactLiteral() {
        RexLiteral literal = this.rexBuilder.makeExactLiteral(new BigDecimal("-1234.56"));
        Assert.assertThat((Object)literal.getType().getFullTypeString(), (Matcher)CoreMatchers.is((Object)"DECIMAL(6, 2) NOT NULL"));
        Assert.assertThat((Object)literal.getValue().toString(), (Matcher)CoreMatchers.is((Object)"-1234.56"));
        RexLiteral literal2 = this.rexBuilder.makeExactLiteral(new BigDecimal("1234.56"));
        Assert.assertThat((Object)literal2.getType().getFullTypeString(), (Matcher)CoreMatchers.is((Object)"DECIMAL(6, 2) NOT NULL"));
        Assert.assertThat((Object)literal2.getValue().toString(), (Matcher)CoreMatchers.is((Object)"1234.56"));
        RexLiteral literal3 = this.rexBuilder.makeExactLiteral(new BigDecimal("0.0123456"));
        Assert.assertThat((Object)literal3.getType().getFullTypeString(), (Matcher)CoreMatchers.is((Object)"DECIMAL(8, 7) NOT NULL"));
        Assert.assertThat((Object)literal3.getValue().toString(), (Matcher)CoreMatchers.is((Object)"0.0123456"));
        RexLiteral literal4 = this.rexBuilder.makeExactLiteral(new BigDecimal("0.01234560"));
        Assert.assertThat((Object)literal4.getType().getFullTypeString(), (Matcher)CoreMatchers.is((Object)"DECIMAL(9, 8) NOT NULL"));
        Assert.assertThat((Object)literal4.getValue().toString(), (Matcher)CoreMatchers.is((Object)"0.01234560"));
    }

    @Test
    public void testSplitJoinCondition() {
        String sql = "select * \nfrom emp a \nINNER JOIN dept b \nON CAST(a.empno AS int) <> b.deptno";
        RelNode relNode = RexTransformerTest.toRel("select * \nfrom emp a \nINNER JOIN dept b \nON CAST(a.empno AS int) <> b.deptno");
        LogicalProject project = (LogicalProject)relNode;
        LogicalJoin join = (LogicalJoin)project.getInput(0);
        ArrayList leftJoinKeys = new ArrayList();
        ArrayList rightJoinKeys = new ArrayList();
        ArrayList sysFieldList = new ArrayList();
        RexNode remaining = RelOptUtil.splitJoinCondition(sysFieldList, (RelNode)((RelNode)join.getInputs().get(0)), (RelNode)((RelNode)join.getInputs().get(1)), (RexNode)join.getCondition(), leftJoinKeys, rightJoinKeys, null, null);
        Assert.assertThat((Object)remaining.toString(), (Matcher)CoreMatchers.is((Object)"<>(CAST($0):INTEGER NOT NULL, $9)"));
        Assert.assertThat((Object)leftJoinKeys.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)rightJoinKeys.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testLogic() {
        RexNode node = this.and(this.greaterThan(this.x, this.falseRex), this.isNotNull(this.equals(this.y, this.z)));
        Assert.assertThat((Object)this.deduceLogic(node, this.x, RelOptUtil.Logic.TRUE_FALSE), (Matcher)CoreMatchers.is((Object)RelOptUtil.Logic.TRUE_FALSE));
        Assert.assertThat((Object)this.deduceLogic(node, this.y, RelOptUtil.Logic.TRUE_FALSE), (Matcher)CoreMatchers.is((Object)RelOptUtil.Logic.TRUE_FALSE_UNKNOWN));
        Assert.assertThat((Object)this.deduceLogic(node, this.z, RelOptUtil.Logic.TRUE_FALSE), (Matcher)CoreMatchers.is((Object)RelOptUtil.Logic.TRUE_FALSE_UNKNOWN));
        Assert.assertThat((Object)this.deduceLogic(this.and(this.x, this.y), this.x, RelOptUtil.Logic.TRUE), (Matcher)CoreMatchers.is((Object)RelOptUtil.Logic.TRUE));
        Assert.assertThat((Object)this.deduceLogic(this.and(this.x, this.y), this.y, RelOptUtil.Logic.TRUE), (Matcher)CoreMatchers.is((Object)RelOptUtil.Logic.TRUE));
        Assert.assertThat((Object)this.deduceLogic(this.and(this.x, this.and(this.y, this.z)), this.z, RelOptUtil.Logic.TRUE), (Matcher)CoreMatchers.is((Object)RelOptUtil.Logic.TRUE));
        Assert.assertThat((Object)this.deduceLogic(this.and(this.x, this.not(this.y)), this.x, RelOptUtil.Logic.TRUE), (Matcher)CoreMatchers.is((Object)RelOptUtil.Logic.TRUE));
        Assert.assertThat((Object)this.deduceLogic(this.and(this.x, this.not(this.y)), this.y, RelOptUtil.Logic.TRUE), (Matcher)CoreMatchers.is((Object)RelOptUtil.Logic.UNKNOWN_AS_TRUE));
        Assert.assertThat((Object)this.deduceLogic(this.and(this.x, this.not(this.not(this.y))), this.y, RelOptUtil.Logic.TRUE), (Matcher)CoreMatchers.is((Object)RelOptUtil.Logic.TRUE_FALSE_UNKNOWN));
        Assert.assertThat((Object)this.deduceLogic(this.and(this.x, this.not(this.and(this.y, this.z))), this.z, RelOptUtil.Logic.TRUE), (Matcher)CoreMatchers.is((Object)RelOptUtil.Logic.UNKNOWN_AS_TRUE));
        Assert.assertThat((Object)this.deduceLogic(this.or(this.x, this.y), this.x, RelOptUtil.Logic.TRUE), (Matcher)CoreMatchers.is((Object)RelOptUtil.Logic.TRUE_FALSE_UNKNOWN));
    }

    private RelOptUtil.Logic deduceLogic(RexNode root, RexNode seek, RelOptUtil.Logic logic) {
        ArrayList list = new ArrayList();
        LogicVisitor.collect((RexNode)root, (RexNode)seek, (RelOptUtil.Logic)logic, list);
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)1));
        return (RelOptUtil.Logic)list.get(0);
    }
}

