/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.org.apache.calcite.config.Lex;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.hive.druid.org.apache.calcite.test.CalciteAssert;
import org.apache.hive.druid.org.apache.calcite.test.JdbcTest;
import org.apache.hive.druid.org.apache.calcite.test.MultiJdbcSchemaJoinTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hsqldb.jdbcDriver;
import org.junit.Assert;
import org.junit.Test;

public class JdbcAdapterTest {
    private static final ReentrantLock LOCK = new ReentrantLock();

    @Test
    public void testValuesPlan() {
        String sql = "select * from \"days\", (values 1, 2) as t(c)";
        String explain = "PLAN=EnumerableCalc(expr#0..2=[{inputs}], day=[$t1], week_day=[$t2], C=[$t0])\n  EnumerableJoin(condition=[true], joinType=[inner])\n    EnumerableValues(tuples=[[{ 1 }, { 2 }]])\n    JdbcToEnumerableConverter\n      JdbcTableScan(table=[[foodmart, days]])";
        String jdbcSql = "SELECT *\nFROM \"foodmart\".\"days\"";
        CalciteAssert.model(JdbcTest.FOODMART_MODEL).query("select * from \"days\", (values 1, 2) as t(c)").explainContains("PLAN=EnumerableCalc(expr#0..2=[{inputs}], day=[$t1], week_day=[$t2], C=[$t0])\n  EnumerableJoin(condition=[true], joinType=[inner])\n    EnumerableValues(tuples=[[{ 1 }, { 2 }]])\n    JdbcToEnumerableConverter\n      JdbcTableScan(table=[[foodmart, days]])").runs().enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB || CalciteAssert.DB == CalciteAssert.DatabaseInstance.POSTGRESQL).planHasSql("SELECT *\nFROM \"foodmart\".\"days\"");
    }

    @Test
    public void testUnionPlan() {
        CalciteAssert.model(JdbcTest.FOODMART_MODEL).query("select * from \"sales_fact_1997\"\nunion all\nselect * from \"sales_fact_1998\"").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcUnion(all=[true])\n    JdbcTableScan(table=[[foodmart, sales_fact_1997]])\n    JdbcTableScan(table=[[foodmart, sales_fact_1998]])").runs().enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB).planHasSql("SELECT *\nFROM \"foodmart\".\"sales_fact_1997\"\nUNION ALL\nSELECT *\nFROM \"foodmart\".\"sales_fact_1998\"");
    }

    @Test
    public void testFilterUnionPlan() {
        CalciteAssert.model(JdbcTest.FOODMART_MODEL).query("select * from (\n  select * from \"sales_fact_1997\"\n  union all\n  select * from \"sales_fact_1998\")\nwhere \"product_id\" = 1").runs().enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB).planHasSql("SELECT *\nFROM \"foodmart\".\"sales_fact_1997\"\nWHERE \"product_id\" = 1\nUNION ALL\nSELECT *\nFROM \"foodmart\".\"sales_fact_1998\"\nWHERE \"product_id\" = 1");
    }

    @Test
    public void testInPlan() {
        CalciteAssert.model(JdbcTest.FOODMART_MODEL).query("select \"store_id\", \"store_name\" from \"store\"\nwhere \"store_name\" in ('Store 1', 'Store 10', 'Store 11', 'Store 15', 'Store 16', 'Store 24', 'Store 3', 'Store 7')").runs().enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB).planHasSql("SELECT \"store_id\", \"store_name\"\nFROM \"foodmart\".\"store\"\nWHERE \"store_name\" = 'Store 1' OR \"store_name\" = 'Store 10' OR \"store_name\" = 'Store 11' OR \"store_name\" = 'Store 15' OR \"store_name\" = 'Store 16' OR \"store_name\" = 'Store 24' OR \"store_name\" = 'Store 3' OR \"store_name\" = 'Store 7'").returns("store_id=1; store_name=Store 1\nstore_id=3; store_name=Store 3\nstore_id=7; store_name=Store 7\nstore_id=10; store_name=Store 10\nstore_id=11; store_name=Store 11\nstore_id=15; store_name=Store 15\nstore_id=16; store_name=Store 16\nstore_id=24; store_name=Store 24\n");
    }

    @Test
    public void testEquiJoinPlan() {
        CalciteAssert.model(JdbcTest.SCOTT_MODEL).query("select empno, ename, e.deptno, dname \nfrom scott.emp e inner join scott.dept d \non e.deptno = d.deptno").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcProject(EMPNO=[$2], ENAME=[$3], DEPTNO=[$4], DNAME=[$1])\n    JdbcJoin(condition=[=($4, $0)], joinType=[inner])\n      JdbcProject(DEPTNO=[$0], DNAME=[$1])\n        JdbcTableScan(table=[[SCOTT, DEPT]])\n      JdbcProject(EMPNO=[$0], ENAME=[$1], DEPTNO=[$7])\n        JdbcTableScan(table=[[SCOTT, EMP]])").runs().enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB).planHasSql("SELECT \"t0\".\"EMPNO\", \"t0\".\"ENAME\", \"t0\".\"DEPTNO\", \"t\".\"DNAME\"\nFROM (SELECT \"DEPTNO\", \"DNAME\"\nFROM \"SCOTT\".\"DEPT\") AS \"t\"\nINNER JOIN (SELECT \"EMPNO\", \"ENAME\", \"DEPTNO\"\nFROM \"SCOTT\".\"EMP\") AS \"t0\" ON \"t\".\"DEPTNO\" = \"t0\".\"DEPTNO\"");
    }

    @Test
    public void testNonEquiJoinPlan() {
        CalciteAssert.model(JdbcTest.SCOTT_MODEL).query("select empno, ename, grade \nfrom scott.emp e inner join scott.salgrade s \non e.sal > s.losal and e.sal < s.hisal").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcProject(EMPNO=[$3], ENAME=[$4], GRADE=[$0])\n    JdbcJoin(condition=[AND(>($5, $1), <($5, $2))], joinType=[inner])\n      JdbcTableScan(table=[[SCOTT, SALGRADE]])\n      JdbcProject(EMPNO=[$0], ENAME=[$1], SAL=[$5])\n        JdbcTableScan(table=[[SCOTT, EMP]])").runs().enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB).planHasSql("SELECT \"t\".\"EMPNO\", \"t\".\"ENAME\", \"SALGRADE\".\"GRADE\"\nFROM \"SCOTT\".\"SALGRADE\"\nINNER JOIN (SELECT \"EMPNO\", \"ENAME\", \"SAL\"\nFROM \"SCOTT\".\"EMP\") AS \"t\" ON \"SALGRADE\".\"LOSAL\" < \"t\".\"SAL\" AND \"SALGRADE\".\"HISAL\" > \"t\".\"SAL\"");
    }

    @Test
    public void testNonEquiJoinReverseConditionPlan() {
        CalciteAssert.model(JdbcTest.SCOTT_MODEL).query("select empno, ename, grade \nfrom scott.emp e inner join scott.salgrade s \non s.losal <= e.sal and s.hisal >= e.sal").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcProject(EMPNO=[$3], ENAME=[$4], GRADE=[$0])\n    JdbcJoin(condition=[AND(<=($1, $5), >=($2, $5))], joinType=[inner])\n      JdbcTableScan(table=[[SCOTT, SALGRADE]])\n      JdbcProject(EMPNO=[$0], ENAME=[$1], SAL=[$5])\n        JdbcTableScan(table=[[SCOTT, EMP]])").runs().enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB).planHasSql("SELECT \"t\".\"EMPNO\", \"t\".\"ENAME\", \"SALGRADE\".\"GRADE\"\nFROM \"SCOTT\".\"SALGRADE\"\nINNER JOIN (SELECT \"EMPNO\", \"ENAME\", \"SAL\"\nFROM \"SCOTT\".\"EMP\") AS \"t\" ON \"SALGRADE\".\"LOSAL\" <= \"t\".\"SAL\" AND \"SALGRADE\".\"HISAL\" >= \"t\".\"SAL\"");
    }

    @Test
    public void testMixedJoinPlan() {
        CalciteAssert.model(JdbcTest.SCOTT_MODEL).query("select e.empno, e.ename, e.empno, e.ename  \nfrom scott.emp e inner join scott.emp m on  \ne.mgr = m.empno and e.sal > m.sal").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcProject(EMPNO=[$2], ENAME=[$3], EMPNO0=[$2], ENAME0=[$3])\n    JdbcJoin(condition=[AND(=($4, $0), >($5, $1))], joinType=[inner])\n      JdbcProject(EMPNO=[$0], SAL=[$5])\n        JdbcTableScan(table=[[SCOTT, EMP]])\n      JdbcProject(EMPNO=[$0], ENAME=[$1], MGR=[$3], SAL=[$5])\n        JdbcTableScan(table=[[SCOTT, EMP]])").runs().enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB).planHasSql("SELECT \"t0\".\"EMPNO\", \"t0\".\"ENAME\", \"t0\".\"EMPNO\" AS \"EMPNO0\", \"t0\".\"ENAME\" AS \"ENAME0\"\nFROM (SELECT \"EMPNO\", \"SAL\"\nFROM \"SCOTT\".\"EMP\") AS \"t\"\nINNER JOIN (SELECT \"EMPNO\", \"ENAME\", \"MGR\", \"SAL\"\nFROM \"SCOTT\".\"EMP\") AS \"t0\" ON \"t\".\"EMPNO\" = \"t0\".\"MGR\" AND \"t\".\"SAL\" < \"t0\".\"SAL\"");
    }

    @Test
    public void testMixedJoinWithOrPlan() {
        CalciteAssert.model(JdbcTest.SCOTT_MODEL).query("select e.empno, e.ename, e.empno, e.ename  \nfrom scott.emp e inner join scott.emp m on  \ne.mgr = m.empno and (e.sal > m.sal or m.hiredate > e.hiredate)").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcProject(EMPNO=[$3], ENAME=[$4], EMPNO0=[$3], ENAME0=[$4])\n    JdbcJoin(condition=[AND(=($5, $0), OR(>($7, $2), >($1, $6)))], joinType=[inner])\n      JdbcProject(EMPNO=[$0], HIREDATE=[$4], SAL=[$5])\n        JdbcTableScan(table=[[SCOTT, EMP]])\n      JdbcProject(EMPNO=[$0], ENAME=[$1], MGR=[$3], HIREDATE=[$4], SAL=[$5])\n        JdbcTableScan(table=[[SCOTT, EMP]])").runs().enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB).planHasSql("SELECT \"t0\".\"EMPNO\", \"t0\".\"ENAME\", \"t0\".\"EMPNO\" AS \"EMPNO0\", \"t0\".\"ENAME\" AS \"ENAME0\"\nFROM (SELECT \"EMPNO\", \"HIREDATE\", \"SAL\"\nFROM \"SCOTT\".\"EMP\") AS \"t\"\nINNER JOIN (SELECT \"EMPNO\", \"ENAME\", \"MGR\", \"HIREDATE\", \"SAL\"\nFROM \"SCOTT\".\"EMP\") AS \"t0\" ON \"t\".\"EMPNO\" = \"t0\".\"MGR\" AND (\"t\".\"SAL\" < \"t0\".\"SAL\" OR \"t\".\"HIREDATE\" > \"t0\".\"HIREDATE\")");
    }

    @Test
    public void testJoin3TablesPlan() {
        CalciteAssert.model(JdbcTest.SCOTT_MODEL).query("select  empno, ename, dname, grade \nfrom scott.emp e inner join scott.dept d \non e.deptno = d.deptno \ninner join scott.salgrade s \non e.sal > s.losal and e.sal < s.hisal").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcProject(EMPNO=[$3], ENAME=[$4], DNAME=[$8], GRADE=[$0])\n    JdbcJoin(condition=[AND(>($5, $1), <($5, $2))], joinType=[inner])\n      JdbcTableScan(table=[[SCOTT, SALGRADE]])\n      JdbcJoin(condition=[=($3, $4)], joinType=[inner])\n        JdbcProject(EMPNO=[$0], ENAME=[$1], SAL=[$5], DEPTNO=[$7])\n          JdbcTableScan(table=[[SCOTT, EMP]])\n        JdbcProject(DEPTNO=[$0], DNAME=[$1])\n          JdbcTableScan(table=[[SCOTT, DEPT]])").runs().enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB).planHasSql("SELECT \"t\".\"EMPNO\", \"t\".\"ENAME\", \"t0\".\"DNAME\", \"SALGRADE\".\"GRADE\"\nFROM \"SCOTT\".\"SALGRADE\"\nINNER JOIN ((SELECT \"EMPNO\", \"ENAME\", \"SAL\", \"DEPTNO\"\nFROM \"SCOTT\".\"EMP\") AS \"t\"\nINNER JOIN (SELECT \"DEPTNO\", \"DNAME\"\nFROM \"SCOTT\".\"DEPT\") AS \"t0\" ON \"t\".\"DEPTNO\" = \"t0\".\"DEPTNO\") ON \"SALGRADE\".\"LOSAL\" < \"t\".\"SAL\" AND \"SALGRADE\".\"HISAL\" > \"t\".\"SAL\"");
    }

    @Test
    public void testCrossJoinWithJoinKeyPlan() {
        CalciteAssert.model(JdbcTest.SCOTT_MODEL).query("select empno, ename, d.deptno, dname \nfrom scott.emp e,scott.dept d \nwhere e.deptno = d.deptno").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcProject(EMPNO=[$0], ENAME=[$1], DEPTNO=[$3], DNAME=[$4])\n    JdbcJoin(condition=[=($2, $3)], joinType=[inner])\n      JdbcProject(EMPNO=[$0], ENAME=[$1], DEPTNO=[$7])\n        JdbcTableScan(table=[[SCOTT, EMP]])\n      JdbcProject(DEPTNO=[$0], DNAME=[$1])\n        JdbcTableScan(table=[[SCOTT, DEPT]])").runs().enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB).planHasSql("SELECT \"t\".\"EMPNO\", \"t\".\"ENAME\", \"t0\".\"DEPTNO\", \"t0\".\"DNAME\"\nFROM (SELECT \"EMPNO\", \"ENAME\", \"DEPTNO\"\nFROM \"SCOTT\".\"EMP\") AS \"t\"\nINNER JOIN (SELECT \"DEPTNO\", \"DNAME\"\nFROM \"SCOTT\".\"DEPT\") AS \"t0\" ON \"t\".\"DEPTNO\" = \"t0\".\"DEPTNO\"");
    }

    @Test
    public void testCartesianJoinWithoutKeyPlan() {
        CalciteAssert.model(JdbcTest.SCOTT_MODEL).query("select empno, ename, d.deptno, dname \nfrom scott.emp e,scott.dept d").explainContains("PLAN=EnumerableJoin(condition=[true], joinType=[inner])\n  JdbcToEnumerableConverter\n    JdbcProject(EMPNO=[$0], ENAME=[$1])\n      JdbcTableScan(table=[[SCOTT, EMP]])\n  JdbcToEnumerableConverter\n    JdbcProject(DEPTNO=[$0], DNAME=[$1])\n      JdbcTableScan(table=[[SCOTT, DEPT]])").runs().enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB);
    }

    @Test
    public void testCrossJoinWithJoinKeyAndFilterPlan() {
        CalciteAssert.model(JdbcTest.SCOTT_MODEL).query("select empno, ename, d.deptno, dname \nfrom scott.emp e,scott.dept d \nwhere e.deptno = d.deptno \nand e.deptno=20").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcProject(EMPNO=[$0], ENAME=[$1], DEPTNO=[$3], DNAME=[$4])\n    JdbcJoin(condition=[=($2, $3)], joinType=[inner])\n      JdbcProject(EMPNO=[$0], ENAME=[$1], DEPTNO=[$7])\n        JdbcFilter(condition=[=(CAST($7):INTEGER, 20)])\n          JdbcTableScan(table=[[SCOTT, EMP]])\n      JdbcProject(DEPTNO=[$0], DNAME=[$1])\n        JdbcTableScan(table=[[SCOTT, DEPT]])").runs().enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB).planHasSql("SELECT \"t0\".\"EMPNO\", \"t0\".\"ENAME\", \"t1\".\"DEPTNO\", \"t1\".\"DNAME\"\nFROM (SELECT \"EMPNO\", \"ENAME\", \"DEPTNO\"\nFROM \"SCOTT\".\"EMP\"\nWHERE CAST(\"DEPTNO\" AS INTEGER) = 20) AS \"t0\"\nINNER JOIN (SELECT \"DEPTNO\", \"DNAME\"\nFROM \"SCOTT\".\"DEPT\") AS \"t1\" ON \"t0\".\"DEPTNO\" = \"t1\".\"DEPTNO\"");
    }

    @Test
    public void testJoinPlan() {
        String sql = "SELECT T1.\"brand_name\"\nFROM \"foodmart\".\"product\" AS T1\n INNER JOIN \"foodmart\".\"product_class\" AS T2\n ON T1.\"product_class_id\" = T2.\"product_class_id\"\nWHERE T2.\"product_department\" = 'Frozen Foods'\n OR T2.\"product_department\" = 'Baking Goods'\n AND T1.\"brand_name\" <> 'King'";
        CalciteAssert.model(JdbcTest.FOODMART_MODEL).query("SELECT T1.\"brand_name\"\nFROM \"foodmart\".\"product\" AS T1\n INNER JOIN \"foodmart\".\"product_class\" AS T2\n ON T1.\"product_class_id\" = T2.\"product_class_id\"\nWHERE T2.\"product_department\" = 'Frozen Foods'\n OR T2.\"product_department\" = 'Baking Goods'\n AND T1.\"brand_name\" <> 'King'").runs().returnsCount(275);
    }

    @Test
    public void testJoinPlan2() {
        String sql = "SELECT v1.deptno, v2.deptno\nFROM Scott.dept v1 LEFT JOIN Scott.emp v2 ON v1.deptno = v2.deptno\nWHERE v2.job LIKE 'PRESIDENT'";
        CalciteAssert.model(JdbcTest.SCOTT_MODEL).with(Lex.MYSQL).query("SELECT v1.deptno, v2.deptno\nFROM Scott.dept v1 LEFT JOIN Scott.emp v2 ON v1.deptno = v2.deptno\nWHERE v2.job LIKE 'PRESIDENT'").runs().returnsCount(1);
    }

    @Test
    public void testJoinCartesian() {
        String sql = "SELECT *\nFROM Scott.dept, Scott.emp";
        CalciteAssert.model(JdbcTest.SCOTT_MODEL).query("SELECT *\nFROM Scott.dept, Scott.emp").returnsCount(56);
    }

    @Test
    public void testJoinCartesianCount() {
        String sql = "SELECT count(*) as c\nFROM Scott.dept, Scott.emp";
        CalciteAssert.model(JdbcTest.SCOTT_MODEL).query("SELECT count(*) as c\nFROM Scott.dept, Scott.emp").returns("C=56\n");
    }

    @Test
    public void testJdbcAggregate() throws Exception {
        String url = MultiJdbcSchemaJoinTest.TempDb.INSTANCE.getUrl();
        Connection baseConnection = DriverManager.getConnection(url);
        Statement baseStmt = baseConnection.createStatement();
        baseStmt.execute("CREATE TABLE T2 (\nID INTEGER,\nVALS INTEGER)");
        baseStmt.execute("INSERT INTO T2 VALUES (1, 1)");
        baseStmt.execute("INSERT INTO T2 VALUES (2, null)");
        baseStmt.close();
        baseConnection.commit();
        Properties info = new Properties();
        info.put("model", "inline:{\n  version: '1.0',\n  defaultSchema: 'BASEJDBC',\n  schemas: [\n     {\n       type: 'jdbc',\n       name: 'BASEJDBC',\n       jdbcDriver: '" + jdbcDriver.class.getName() + "',\n       jdbcUrl: '" + url + "',\n       jdbcCatalog: null,\n       jdbcSchema: null\n     }\n  ]\n}");
        Connection calciteConnection = DriverManager.getConnection("jdbc:calcite:", info);
        ResultSet rs = calciteConnection.prepareStatement("select 10 * count(ID) from t2").executeQuery();
        Assert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((Long)rs.getObject(1)), (Matcher)CoreMatchers.equalTo((Object)20L));
        Assert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
        rs.close();
        calciteConnection.close();
    }

    @Test
    public void testOverDefault() {
        CalciteAssert.model(JdbcTest.FOODMART_MODEL).enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.POSTGRESQL).query("select \"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\", last_value(\"time_id\") over () as \"last_version\" from \"expense_fact\"").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcProject(store_id=[$0], account_id=[$1], exp_date=[$2], time_id=[$3], category_id=[$4], currency_id=[$5], amount=[$6], last_version=[LAST_VALUE($3) OVER (RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING)])\n    JdbcTableScan(table=[[foodmart, expense_fact]])\n").runs().planHasSql("SELECT \"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\", LAST_VALUE(\"time_id\") OVER (RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING) AS \"last_version\"\nFROM \"foodmart\".\"expense_fact\"");
    }

    @Test
    public void testOverRowsBetweenBoundFollowingAndFollowing() {
        CalciteAssert.model(JdbcTest.FOODMART_MODEL).enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.POSTGRESQL).query("select \"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\", last_value(\"time_id\") over (partition by \"account_id\" order by \"time_id\" rows between 1 following and 10 following) as \"last_version\" from \"expense_fact\"").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcProject(store_id=[$0], account_id=[$1], exp_date=[$2], time_id=[$3], category_id=[$4], currency_id=[$5], amount=[$6], last_version=[LAST_VALUE($3) OVER (PARTITION BY $1 ORDER BY $3 ROWS BETWEEN 1 FOLLOWING AND 10 FOLLOWING)])\n    JdbcTableScan(table=[[foodmart, expense_fact]])\n").runs().planHasSql("SELECT \"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\", LAST_VALUE(\"time_id\") OVER (PARTITION BY \"account_id\" ORDER BY \"time_id\" ROWS BETWEEN 1 FOLLOWING AND 10 FOLLOWING) AS \"last_version\"\nFROM \"foodmart\".\"expense_fact\"");
    }

    @Test
    public void testOverRowsBetweenBoundPrecedingAndCurrent() {
        CalciteAssert.model(JdbcTest.FOODMART_MODEL).enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.POSTGRESQL).query("select \"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\", last_value(\"time_id\") over (partition by \"account_id\" order by \"time_id\" rows between 3 preceding and current row) as \"last_version\" from \"expense_fact\"").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcProject(store_id=[$0], account_id=[$1], exp_date=[$2], time_id=[$3], category_id=[$4], currency_id=[$5], amount=[$6], last_version=[LAST_VALUE($3) OVER (PARTITION BY $1 ORDER BY $3 ROWS BETWEEN 3 PRECEDING AND CURRENT ROW)])\n    JdbcTableScan(table=[[foodmart, expense_fact]])\n").runs().planHasSql("SELECT \"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\", LAST_VALUE(\"time_id\") OVER (PARTITION BY \"account_id\" ORDER BY \"time_id\" ROWS BETWEEN 3 PRECEDING AND CURRENT ROW) AS \"last_version\"\nFROM \"foodmart\".\"expense_fact\"");
    }

    @Test
    public void testOverDisallowPartial() {
        CalciteAssert.model(JdbcTest.FOODMART_MODEL).enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.POSTGRESQL).query("select \"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\", last_value(\"time_id\") over (partition by \"account_id\" order by \"time_id\" rows 3 preceding disallow partial) as \"last_version\" from \"expense_fact\"").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcProject(store_id=[$0], account_id=[$1], exp_date=[$2], time_id=[$3], category_id=[$4], currency_id=[$5], amount=[$6], last_version=[CASE(>=(COUNT() OVER (PARTITION BY $1 ORDER BY $3 ROWS BETWEEN 3 PRECEDING AND CURRENT ROW), 2), LAST_VALUE($3) OVER (PARTITION BY $1 ORDER BY $3 ROWS BETWEEN 3 PRECEDING AND CURRENT ROW), null)])\n    JdbcTableScan(table=[[foodmart, expense_fact]])\n").runs().planHasSql("SELECT \"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\", CASE WHEN (COUNT(*) OVER (PARTITION BY \"account_id\" ORDER BY \"time_id\" ROWS BETWEEN 3 PRECEDING AND CURRENT ROW)) >= 2 THEN LAST_VALUE(\"time_id\") OVER (PARTITION BY \"account_id\" ORDER BY \"time_id\" ROWS BETWEEN 3 PRECEDING AND CURRENT ROW) ELSE NULL END AS \"last_version\"\nFROM \"foodmart\".\"expense_fact\"");
    }

    @Test
    public void testLastValueOver() {
        CalciteAssert.model(JdbcTest.FOODMART_MODEL).enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.POSTGRESQL).query("select \"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\", last_value(\"time_id\") over (partition by \"account_id\" order by \"time_id\") as \"last_version\" from \"expense_fact\"").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcProject(store_id=[$0], account_id=[$1], exp_date=[$2], time_id=[$3], category_id=[$4], currency_id=[$5], amount=[$6], last_version=[LAST_VALUE($3) OVER (PARTITION BY $1 ORDER BY $3 RANGE BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)])\n    JdbcTableScan(table=[[foodmart, expense_fact]])\n").runs().planHasSql("SELECT \"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\", LAST_VALUE(\"time_id\") OVER (PARTITION BY \"account_id\" ORDER BY \"time_id\" RANGE BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) AS \"last_version\"\nFROM \"foodmart\".\"expense_fact\"");
    }

    @Test
    public void testSubQueryWithSingleValue() {
        String expected;
        switch (CalciteAssert.DB) {
            case MYSQL: {
                expected = "Subquery returns more than 1 row";
                break;
            }
            default: {
                expected = "more than one value in agg SINGLE_VALUE";
            }
        }
        CalciteAssert.model(JdbcTest.FOODMART_MODEL).query("SELECT \"full_name\" FROM \"employee\" WHERE \"employee_id\" = (SELECT \"employee_id\" FROM \"salary\")").explainContains("SINGLE_VALUE").throws_(expected);
    }

    @Test
    public void testMetadataTables() throws Exception {
        String model = JdbcTest.FOODMART_MODEL.replace("jdbcSchema: 'foodmart'", "jdbcSchema: null");
        CalciteAssert.model(model).doWithConnection(new Function<CalciteConnection, Void>(){

            public Void apply(CalciteConnection connection) {
                try {
                    ResultSet resultSet = connection.getMetaData().getTables(null, null, "%", null);
                    Assert.assertFalse((boolean)CalciteAssert.toString(resultSet).isEmpty());
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testScalarSubQuery() {
        CalciteAssert.model(JdbcTest.SCOTT_MODEL).query("SELECT COUNT(empno) AS cEmpNo FROM \"SCOTT\".\"EMP\" WHERE DEPTNO <> (SELECT * FROM (VALUES 1))").enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB).returns("CEMPNO=14\n");
        CalciteAssert.model(JdbcTest.SCOTT_MODEL).query("SELECT ename FROM \"SCOTT\".\"EMP\" WHERE DEPTNO = (SELECT deptno FROM \"SCOTT\".\"DEPT\" WHERE dname = 'ACCOUNTING')").enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB).returns("ENAME=CLARK\nENAME=KING\nENAME=MILLER\n");
        CalciteAssert.model(JdbcTest.SCOTT_MODEL).query("SELECT COUNT(ename) AS cEname FROM \"SCOTT\".\"EMP\" WHERE DEPTNO > (SELECT deptno FROM \"SCOTT\".\"DEPT\" WHERE dname = 'ACCOUNTING')").enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB).returns("CENAME=11\n");
        CalciteAssert.model(JdbcTest.SCOTT_MODEL).query("SELECT COUNT(ename) AS cEname FROM \"SCOTT\".\"EMP\" WHERE DEPTNO < (SELECT deptno FROM \"SCOTT\".\"DEPT\" WHERE dname = 'ACCOUNTING')").enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB).returns("CENAME=0\n");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LockWrapper exclusiveCleanDb(Connection c) throws SQLException {
        LockWrapper wrapper = LockWrapper.lock(LOCK);
        try (Statement statement = c.createStatement();){
            String dSql = "DELETE FROM \"foodmart\".\"expense_fact\" WHERE \"store_id\"=666\n";
            String iSql = "INSERT INTO \"foodmart\".\"expense_fact\"(\n \"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\")\n VALUES (666, 666, TIMESTAMP '1997-01-01 00:00:00', 666, '666', 666, 666)";
            statement.executeUpdate("DELETE FROM \"foodmart\".\"expense_fact\" WHERE \"store_id\"=666\n");
            int rowCount = statement.executeUpdate("INSERT INTO \"foodmart\".\"expense_fact\"(\n \"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\")\n VALUES (666, 666, TIMESTAMP '1997-01-01 00:00:00', 666, '666', 666, 666)");
            Assert.assertThat((Object)rowCount, (Matcher)CoreMatchers.is((Object)1));
            LockWrapper lockWrapper = wrapper;
            return lockWrapper;
        }
        catch (Error | RuntimeException | SQLException e) {
            wrapper.close();
            throw e;
        }
    }

    @Test
    public void testTableModifyInsert() throws Exception {
        String sql = "INSERT INTO \"foodmart\".\"expense_fact\"(\n \"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\")\nVALUES (666, 666, TIMESTAMP '1997-01-01 00:00:00', 666, '666', 666, 666)";
        String explain = "PLAN=JdbcToEnumerableConverter\n  JdbcTableModify(table=[[foodmart, expense_fact]], operation=[INSERT], flattened=[false])\n    JdbcValues(tuples=[[{ 666, 666, 1997-01-01 00:00:00, 666, '666', 666, 666.0000 }]])\n";
        String jdbcSql = "INSERT INTO \"foodmart\".\"expense_fact\" (\"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\")\nVALUES  (666, 666, TIMESTAMP '1997-01-01 00:00:00', 666, '666', 666, 666.0000)";
        final CalciteAssert.AssertThat that = CalciteAssert.model(JdbcTest.FOODMART_MODEL).enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB || CalciteAssert.DB == CalciteAssert.DatabaseInstance.POSTGRESQL);
        that.doWithConnection(new Function<CalciteConnection, Void>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Void apply(CalciteConnection connection) {
                try (LockWrapper ignore = JdbcAdapterTest.this.exclusiveCleanDb((Connection)connection);){
                    that.query("INSERT INTO \"foodmart\".\"expense_fact\"(\n \"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\")\nVALUES (666, 666, TIMESTAMP '1997-01-01 00:00:00', 666, '666', 666, 666)").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcTableModify(table=[[foodmart, expense_fact]], operation=[INSERT], flattened=[false])\n    JdbcValues(tuples=[[{ 666, 666, 1997-01-01 00:00:00, 666, '666', 666, 666.0000 }]])\n").planUpdateHasSql("INSERT INTO \"foodmart\".\"expense_fact\" (\"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\")\nVALUES  (666, 666, TIMESTAMP '1997-01-01 00:00:00', 666, '666', 666, 666.0000)", 1);
                    Void void_ = null;
                    return void_;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testTableModifyInsertMultiValues() throws Exception {
        String sql = "INSERT INTO \"foodmart\".\"expense_fact\"(\n \"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\")\nVALUES (666, 666, TIMESTAMP '1997-01-01 00:00:00',   666, '666', 666, 666),\n (666, 777, TIMESTAMP '1997-01-01 00:00:00',   666, '666', 666, 666)";
        String explain = "PLAN=JdbcToEnumerableConverter\n  JdbcTableModify(table=[[foodmart, expense_fact]], operation=[INSERT], flattened=[false])\n    JdbcValues(tuples=[[{ 666, 666, 1997-01-01 00:00:00, 666, '666', 666, 666.0000 }, { 666, 777, 1997-01-01 00:00:00, 666, '666', 666, 666.0000 }]])\n";
        String jdbcSql = "INSERT INTO \"foodmart\".\"expense_fact\" (\"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\")\nVALUES  (666, 666, TIMESTAMP '1997-01-01 00:00:00', 666, '666', 666, 666.0000),\n (666, 777, TIMESTAMP '1997-01-01 00:00:00', 666, '666', 666, 666.0000)";
        final CalciteAssert.AssertThat that = CalciteAssert.model(JdbcTest.FOODMART_MODEL).enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB || CalciteAssert.DB == CalciteAssert.DatabaseInstance.POSTGRESQL);
        that.doWithConnection(new Function<CalciteConnection, Void>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Void apply(CalciteConnection connection) {
                try (LockWrapper ignore = JdbcAdapterTest.this.exclusiveCleanDb((Connection)connection);){
                    that.query("INSERT INTO \"foodmart\".\"expense_fact\"(\n \"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\")\nVALUES (666, 666, TIMESTAMP '1997-01-01 00:00:00',   666, '666', 666, 666),\n (666, 777, TIMESTAMP '1997-01-01 00:00:00',   666, '666', 666, 666)").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcTableModify(table=[[foodmart, expense_fact]], operation=[INSERT], flattened=[false])\n    JdbcValues(tuples=[[{ 666, 666, 1997-01-01 00:00:00, 666, '666', 666, 666.0000 }, { 666, 777, 1997-01-01 00:00:00, 666, '666', 666, 666.0000 }]])\n").planUpdateHasSql("INSERT INTO \"foodmart\".\"expense_fact\" (\"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\")\nVALUES  (666, 666, TIMESTAMP '1997-01-01 00:00:00', 666, '666', 666, 666.0000),\n (666, 777, TIMESTAMP '1997-01-01 00:00:00', 666, '666', 666, 666.0000)", 2);
                    Void void_ = null;
                    return void_;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testTableModifyInsertWithSubQuery() throws Exception {
        final CalciteAssert.AssertThat that = CalciteAssert.model(JdbcTest.FOODMART_MODEL).enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB);
        that.doWithConnection(new Function<CalciteConnection, Void>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Void apply(CalciteConnection connection) {
                try (LockWrapper ignore = JdbcAdapterTest.this.exclusiveCleanDb((Connection)connection);){
                    String sql = "INSERT INTO \"foodmart\".\"expense_fact\"(\n \"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\")\nSELECT  \"store_id\", \"account_id\", \"exp_date\", \"time_id\" + 1, \"category_id\", \"currency_id\", \"amount\"\nFROM \"foodmart\".\"expense_fact\"\nWHERE \"store_id\" = 666";
                    String explain = "PLAN=JdbcToEnumerableConverter\n  JdbcTableModify(table=[[foodmart, expense_fact]], operation=[INSERT], flattened=[false])\n    JdbcProject(store_id=[$0], account_id=[$1], exp_date=[$2], time_id=[+($3, 1)], category_id=[$4], currency_id=[$5], amount=[$6])\n      JdbcFilter(condition=[=($0, 666)])\n        JdbcTableScan(table=[[foodmart, expense_fact]])\n";
                    String jdbcSql = "INSERT INTO \"foodmart\".\"expense_fact\" (\"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\")\n(SELECT \"store_id\", \"account_id\", \"exp_date\", \"time_id\" + 1 AS \"time_id\", \"category_id\", \"currency_id\", \"amount\"\nFROM \"foodmart\".\"expense_fact\"\nWHERE \"store_id\" = 666)";
                    that.query("INSERT INTO \"foodmart\".\"expense_fact\"(\n \"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\")\nSELECT  \"store_id\", \"account_id\", \"exp_date\", \"time_id\" + 1, \"category_id\", \"currency_id\", \"amount\"\nFROM \"foodmart\".\"expense_fact\"\nWHERE \"store_id\" = 666").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcTableModify(table=[[foodmart, expense_fact]], operation=[INSERT], flattened=[false])\n    JdbcProject(store_id=[$0], account_id=[$1], exp_date=[$2], time_id=[+($3, 1)], category_id=[$4], currency_id=[$5], amount=[$6])\n      JdbcFilter(condition=[=($0, 666)])\n        JdbcTableScan(table=[[foodmart, expense_fact]])\n").planUpdateHasSql("INSERT INTO \"foodmart\".\"expense_fact\" (\"store_id\", \"account_id\", \"exp_date\", \"time_id\", \"category_id\", \"currency_id\", \"amount\")\n(SELECT \"store_id\", \"account_id\", \"exp_date\", \"time_id\" + 1 AS \"time_id\", \"category_id\", \"currency_id\", \"amount\"\nFROM \"foodmart\".\"expense_fact\"\nWHERE \"store_id\" = 666)", 1);
                    Void void_ = null;
                    return void_;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testTableModifyUpdate() throws Exception {
        final CalciteAssert.AssertThat that = CalciteAssert.model(JdbcTest.FOODMART_MODEL).enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB);
        that.doWithConnection(new Function<CalciteConnection, Void>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Void apply(CalciteConnection connection) {
                try (LockWrapper ignore = JdbcAdapterTest.this.exclusiveCleanDb((Connection)connection);){
                    String sql = "UPDATE \"foodmart\".\"expense_fact\"\n SET \"account_id\"=888\n WHERE \"store_id\"=666\n";
                    String explain = "PLAN=JdbcToEnumerableConverter\n  JdbcTableModify(table=[[foodmart, expense_fact]], operation=[UPDATE], updateColumnList=[[account_id]], sourceExpressionList=[[888]], flattened=[false])\n    JdbcProject(store_id=[$0], account_id=[$1], exp_date=[$2], time_id=[$3], category_id=[$4], currency_id=[$5], amount=[$6], EXPR$0=[888])\n      JdbcFilter(condition=[=($0, 666)])\n        JdbcTableScan(table=[[foodmart, expense_fact]])";
                    String jdbcSql = "UPDATE \"foodmart\".\"expense_fact\" SET \"account_id\" = 888\nWHERE \"store_id\" = 666";
                    that.query("UPDATE \"foodmart\".\"expense_fact\"\n SET \"account_id\"=888\n WHERE \"store_id\"=666\n").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcTableModify(table=[[foodmart, expense_fact]], operation=[UPDATE], updateColumnList=[[account_id]], sourceExpressionList=[[888]], flattened=[false])\n    JdbcProject(store_id=[$0], account_id=[$1], exp_date=[$2], time_id=[$3], category_id=[$4], currency_id=[$5], amount=[$6], EXPR$0=[888])\n      JdbcFilter(condition=[=($0, 666)])\n        JdbcTableScan(table=[[foodmart, expense_fact]])").planUpdateHasSql("UPDATE \"foodmart\".\"expense_fact\" SET \"account_id\" = 888\nWHERE \"store_id\" = 666", 1);
                    Void void_ = null;
                    return void_;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testTableModifyDelete() throws Exception {
        final CalciteAssert.AssertThat that = CalciteAssert.model(JdbcTest.FOODMART_MODEL).enable(CalciteAssert.DB == CalciteAssert.DatabaseInstance.HSQLDB);
        that.doWithConnection(new Function<CalciteConnection, Void>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Void apply(CalciteConnection connection) {
                try (LockWrapper ignore = JdbcAdapterTest.this.exclusiveCleanDb((Connection)connection);){
                    String sql = "DELETE FROM \"foodmart\".\"expense_fact\"\nWHERE \"store_id\"=666\n";
                    String explain = "PLAN=JdbcToEnumerableConverter\n  JdbcTableModify(table=[[foodmart, expense_fact]], operation=[DELETE], flattened=[false])\n    JdbcFilter(condition=[=($0, 666)])\n      JdbcTableScan(table=[[foodmart, expense_fact]]";
                    String jdbcSql = "DELETE FROM \"foodmart\".\"expense_fact\"\nWHERE \"store_id\" = 666";
                    that.query("DELETE FROM \"foodmart\".\"expense_fact\"\nWHERE \"store_id\"=666\n").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcTableModify(table=[[foodmart, expense_fact]], operation=[DELETE], flattened=[false])\n    JdbcFilter(condition=[=($0, 666)])\n      JdbcTableScan(table=[[foodmart, expense_fact]]").planUpdateHasSql("DELETE FROM \"foodmart\".\"expense_fact\"\nWHERE \"store_id\" = 666", 1);
                    Void void_ = null;
                    return void_;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testColumnNullability() throws Exception {
        String sql = "select \"employee_id\", \"position_id\"\nfrom \"foodmart\".\"employee\" limit 10";
        CalciteAssert.model(JdbcTest.FOODMART_MODEL).query("select \"employee_id\", \"position_id\"\nfrom \"foodmart\".\"employee\" limit 10").runs().returnsCount(10).typeIs("[employee_id INTEGER NOT NULL, position_id INTEGER]");
    }

    static class LockWrapper
    implements AutoCloseable {
        private final Lock lock;

        LockWrapper(Lock lock) {
            this.lock = lock;
        }

        static LockWrapper lock(Lock lock) {
            lock.lock();
            return new LockWrapper(lock);
        }

        @Override
        public void close() {
            this.lock.unlock();
        }
    }
}

