/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.parser.parserextensiontesting;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.hive.druid.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.hive.druid.org.apache.calcite.linq4j.Enumerator;
import org.apache.hive.druid.org.apache.calcite.linq4j.Linq4j;
import org.apache.hive.druid.org.apache.calcite.linq4j.QueryProvider;
import org.apache.hive.druid.org.apache.calcite.linq4j.Queryable;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expression;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.hive.druid.org.apache.calcite.schema.QueryableTable;
import org.apache.hive.druid.org.apache.calcite.schema.SchemaPlus;
import org.apache.hive.druid.org.apache.calcite.schema.Schemas;
import org.apache.hive.druid.org.apache.calcite.schema.Table;
import org.apache.hive.druid.org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCreate;
import org.apache.hive.druid.org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.hive.druid.org.apache.calcite.sql.SqlExecutableStatement;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIdentifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNodeList;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.test.JdbcTest;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apache.hive.druid.org.apache.calcite.util.Util;

public class SqlCreateTable
extends SqlCreate
implements SqlExecutableStatement {
    private final SqlIdentifier name;
    private final SqlNodeList columnList;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE TABLE", SqlKind.CREATE_TABLE);

    public SqlCreateTable(SqlParserPos pos, SqlIdentifier name, SqlNodeList columnList) {
        super(OPERATOR, pos, false, false);
        this.name = name;
        this.columnList = columnList;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.name, (Object)this.columnList);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        writer.keyword("TABLE");
        this.name.unparse(writer, leftPrec, rightPrec);
        SqlWriter.Frame frame = writer.startList("(", ")");
        for (Pair<SqlIdentifier, SqlDataTypeSpec> pair : this.nameTypes()) {
            writer.sep(",");
            ((SqlIdentifier)pair.left).unparse(writer, leftPrec, rightPrec);
            ((SqlDataTypeSpec)pair.right).unparse(writer, leftPrec, rightPrec);
            if (!Boolean.FALSE.equals(((SqlDataTypeSpec)pair.right).getNullable())) continue;
            writer.keyword("NOT NULL");
        }
        writer.endList(frame);
    }

    private List<Pair<SqlIdentifier, SqlDataTypeSpec>> nameTypes() {
        List list = this.columnList.getList();
        return Pair.zip((List)Util.quotientList((List)list, (int)2, (int)0), (List)Util.quotientList((List)list, (int)2, (int)1));
    }

    public void execute(CalcitePrepare.Context context) {
        List path = context.getDefaultSchemaPath();
        CalciteSchema schema = context.getRootSchema();
        for (String p : path) {
            schema = schema.getSubSchema(p, true);
        }
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl();
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        for (Pair<SqlIdentifier, SqlDataTypeSpec> pair : this.nameTypes()) {
            builder.add(((SqlIdentifier)pair.left).getSimple(), ((SqlDataTypeSpec)pair.right).deriveType((RelDataTypeFactory)typeFactory, true));
        }
        RelDataType rowType = builder.build();
        schema.add(this.name.getSimple(), (Table)new MutableArrayTable(this.name.getSimple(), RelDataTypeImpl.proto((RelDataType)rowType)));
    }

    private static class MutableArrayTable
    extends JdbcTest.AbstractModifiableTable {
        final List list = new ArrayList();
        private final RelProtoDataType protoRowType;

        MutableArrayTable(String name, RelProtoDataType protoRowType) {
            super(name);
            this.protoRowType = protoRowType;
        }

        public Collection getModifiableCollection() {
            return this.list;
        }

        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            return new AbstractTableQueryable<T>(queryProvider, schema, (QueryableTable)this, tableName){

                public Enumerator<T> enumerator() {
                    return Linq4j.enumerator((Collection)MutableArrayTable.this.list);
                }
            };
        }

        public Type getElementType() {
            return Object[].class;
        }

        public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
            return Schemas.tableExpression((SchemaPlus)schema, (Type)this.getElementType(), (String)tableName, (Class)clazz);
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return (RelDataType)this.protoRowType.apply((Object)typeFactory);
        }
    }
}

