/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.stomp;

import java.nio.charset.StandardCharsets;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.stomp.DefaultStompFrame;
import org.apache.hive.druid.io.netty.handler.codec.stomp.DefaultStompHeadersSubframe;
import org.apache.hive.druid.io.netty.handler.codec.stomp.LastStompContentSubframe;
import org.apache.hive.druid.io.netty.handler.codec.stomp.StompCommand;
import org.apache.hive.druid.io.netty.handler.codec.stomp.StompHeaders;
import org.apache.hive.druid.io.netty.handler.codec.stomp.StompSubframeEncoder;
import org.apache.hive.druid.io.netty.util.AsciiString;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StompSubframeEncoderTest {
    private EmbeddedChannel channel;

    @BeforeEach
    public void setup() throws Exception {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new StompSubframeEncoder()});
    }

    @AfterEach
    public void teardown() throws Exception {
        Assertions.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void testFrameAndContentEncoding() {
        DefaultStompHeadersSubframe frame = new DefaultStompHeadersSubframe(StompCommand.CONNECT);
        StompHeaders headers = frame.headers();
        headers.set((Object)StompHeaders.HOST, (Object)"stomp.github.org");
        headers.set((Object)StompHeaders.ACCEPT_VERSION, (Object)"1.1,1.2");
        this.channel.writeOutbound(new Object[]{frame});
        this.channel.writeOutbound(new Object[]{LastStompContentSubframe.EMPTY_LAST_CONTENT});
        ByteBuf aggregatedBuffer = Unpooled.buffer();
        ByteBuf byteBuf = (ByteBuf)this.channel.readOutbound();
        Assertions.assertNotNull((Object)byteBuf);
        aggregatedBuffer.writeBytes(byteBuf);
        byteBuf.release();
        byteBuf = (ByteBuf)this.channel.readOutbound();
        Assertions.assertNotNull((Object)byteBuf);
        aggregatedBuffer.writeBytes(byteBuf);
        byteBuf.release();
        aggregatedBuffer.resetReaderIndex();
        String content = aggregatedBuffer.toString(CharsetUtil.UTF_8);
        Assertions.assertEquals((Object)"CONNECT\nhost:stomp.github.org\naccept-version:1.1,1.2\n\n\u0000", (Object)content);
        aggregatedBuffer.release();
    }

    @Test
    public void testUtf8FrameEncoding() {
        DefaultStompFrame frame = new DefaultStompFrame(StompCommand.SEND, Unpooled.wrappedBuffer((byte[])"body".getBytes(CharsetUtil.UTF_8)));
        StompHeaders incoming = frame.headers();
        incoming.set((Object)StompHeaders.DESTINATION, (Object)"/queue/\u211611\u00b1\u265b\u043d\u0435\u0442\u0442\u0438\u2655");
        incoming.set((Object)StompHeaders.CONTENT_TYPE, (Object)AsciiString.of((CharSequence)"text/plain"));
        this.channel.writeOutbound(new Object[]{frame});
        ByteBuf fullFrame = (ByteBuf)this.channel.readOutbound();
        Assertions.assertEquals((Object)"SEND\ndestination:/queue/\u211611\u00b1\u265b\u043d\u0435\u0442\u0442\u0438\u2655\ncontent-type:text/plain\n\nbody\u0000", (Object)fullFrame.toString(CharsetUtil.UTF_8));
        Assertions.assertTrue((boolean)fullFrame.release());
    }

    @Test
    public void testOneBufferForStompFrameWithEmptyContent() {
        DefaultStompFrame connectedFrame = new DefaultStompFrame(StompCommand.CONNECTED);
        connectedFrame.headers().set((Object)StompHeaders.VERSION, (Object)"1.2");
        Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{connectedFrame}));
        ByteBuf stompBuffer = (ByteBuf)this.channel.readOutbound();
        Assertions.assertNotNull((Object)stompBuffer);
        Assertions.assertNull((Object)this.channel.readOutbound());
        Assertions.assertEquals((Object)"CONNECTED\nversion:1.2\n\n\u0000", (Object)stompBuffer.toString(CharsetUtil.UTF_8));
        Assertions.assertTrue((boolean)stompBuffer.release());
    }

    @Test
    void testEscapeStompHeaders() {
        DefaultStompFrame messageFrame = new DefaultStompFrame(StompCommand.MESSAGE);
        ((StompHeaders)((StompHeaders)((StompHeaders)((StompHeaders)((StompHeaders)messageFrame.headers().add((Object)StompHeaders.MESSAGE_ID, (Object)"100")).add((Object)StompHeaders.SUBSCRIPTION, (Object)"1")).add((Object)StompHeaders.DESTINATION, (Object)"/queue/a:")).add((Object)"header\\\r\n:Name", (Object)"header\\\r\n:Value")).add((Object)"header_\\_\r_\n_:_Name", (Object)"header_\\_\r_\n_:_Value")).add((Object)"headerName:", (Object)":headerValue");
        Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{messageFrame}));
        ByteBuf stompBuffer = (ByteBuf)this.channel.readOutbound();
        Assertions.assertNotNull((Object)stompBuffer);
        Assertions.assertNull((Object)this.channel.readOutbound());
        Assertions.assertEquals((Object)"MESSAGE\nmessage-id:100\nsubscription:1\ndestination:/queue/a\\c\nheader\\\\\\r\\n\\cName:header\\\\\\r\\n\\cValue\nheader_\\\\_\\r_\\n_\\c_Name:header_\\\\_\\r_\\n_\\c_Value\nheaderName\\c:\\cheaderValue\n\n\u0000", (Object)stompBuffer.toString(StandardCharsets.UTF_8));
        Assertions.assertTrue((boolean)stompBuffer.release());
    }

    @Test
    void testNotEscapeStompHeadersForConnectCommand() {
        String expectedStompFrame = "CONNECT\ncolonHeaderName-::colonHeaderValue-:\n\n\u0000";
        DefaultStompFrame connectFrame = new DefaultStompFrame(StompCommand.CONNECT);
        connectFrame.headers().add((Object)"colonHeaderName-:", (Object)"colonHeaderValue-:");
        Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{connectFrame}));
        ByteBuf stompBuffer = (ByteBuf)this.channel.readOutbound();
        Assertions.assertNotNull((Object)stompBuffer);
        Assertions.assertNull((Object)this.channel.readOutbound());
        Assertions.assertEquals((Object)expectedStompFrame, (Object)stompBuffer.toString(StandardCharsets.UTF_8));
        Assertions.assertTrue((boolean)stompBuffer.release());
    }

    @Test
    void testNotEscapeStompHeadersForConnectedCommand() {
        String expectedStompFrame = "CONNECTED\ncolonHeaderName-::colonHeaderValue-:\n\n\u0000";
        DefaultStompFrame connectedFrame = new DefaultStompFrame(StompCommand.CONNECTED);
        connectedFrame.headers().add((Object)"colonHeaderName-:", (Object)"colonHeaderValue-:");
        Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{connectedFrame}));
        ByteBuf stompBuffer = (ByteBuf)this.channel.readOutbound();
        Assertions.assertNotNull((Object)stompBuffer);
        Assertions.assertNull((Object)this.channel.readOutbound());
        Assertions.assertEquals((Object)expectedStompFrame, (Object)stompBuffer.toString(StandardCharsets.UTF_8));
        Assertions.assertTrue((boolean)stompBuffer.release());
    }
}

