/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.redis;

import org.apache.hive.druid.io.netty.handler.codec.redis.ErrorRedisMessage;
import org.apache.hive.druid.io.netty.handler.codec.redis.FixedRedisMessagePool;
import org.apache.hive.druid.io.netty.handler.codec.redis.RedisCodecTestUtil;
import org.apache.hive.druid.io.netty.handler.codec.redis.SimpleStringRedisMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FixedRedisMessagePoolTest {
    @Test
    public void shouldGetSameMessageObject() {
        FixedRedisMessagePool pool = FixedRedisMessagePool.INSTANCE;
        SimpleStringRedisMessage fromStr = pool.getSimpleString("OK");
        SimpleStringRedisMessage fromEnum = pool.getSimpleString(FixedRedisMessagePool.RedisReplyKey.OK);
        SimpleStringRedisMessage fromByteBuf = pool.getSimpleString(RedisCodecTestUtil.byteBufOf("OK"));
        Assertions.assertEquals((Object)fromStr.content(), (Object)"OK");
        Assertions.assertEquals((Object)fromStr, (Object)fromEnum);
        Assertions.assertEquals((Object)fromStr, (Object)fromByteBuf);
        ErrorRedisMessage errorFromStr = pool.getError("NOAUTH Authentication required.");
        ErrorRedisMessage errorFromEnum = pool.getError(FixedRedisMessagePool.RedisErrorKey.NOT_AUTH);
        ErrorRedisMessage errorFromByteBuf = pool.getError(RedisCodecTestUtil.byteBufOf("NOAUTH Authentication required."));
        Assertions.assertEquals((Object)errorFromStr.content(), (Object)"NOAUTH Authentication required.");
        Assertions.assertEquals((Object)errorFromStr, (Object)errorFromEnum);
        Assertions.assertEquals((Object)errorFromStr, (Object)errorFromByteBuf);
    }

    @Test
    public void shouldReturnNullByNotExistKey() {
        FixedRedisMessagePool pool = FixedRedisMessagePool.INSTANCE;
        SimpleStringRedisMessage message1 = pool.getSimpleString("Not exist");
        SimpleStringRedisMessage message2 = pool.getSimpleString(RedisCodecTestUtil.byteBufOf("Not exist"));
        Assertions.assertNull((Object)message1);
        Assertions.assertNull((Object)message2);
        ErrorRedisMessage error1 = pool.getError("Not exist");
        ErrorRedisMessage error2 = pool.getError(RedisCodecTestUtil.byteBufOf("Not exist"));
        Assertions.assertNull((Object)error1);
        Assertions.assertNull((Object)error2);
    }

    @Test
    public void shouldReturnDifferentMessage() {
        FixedRedisMessagePool pool = FixedRedisMessagePool.INSTANCE;
        SimpleStringRedisMessage okMessage = pool.getSimpleString(FixedRedisMessagePool.RedisReplyKey.OK);
        SimpleStringRedisMessage pongMessage = pool.getSimpleString(FixedRedisMessagePool.RedisReplyKey.PONG);
        Assertions.assertNotEquals((Object)okMessage, (Object)pongMessage);
    }
}

