/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.memcache.binary;

import java.nio.charset.Charset;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheResponse;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultFullBinaryMemcacheResponseTest {
    private DefaultFullBinaryMemcacheResponse response;

    @BeforeEach
    public void setUp() {
        this.response = new DefaultFullBinaryMemcacheResponse(Unpooled.copiedBuffer((CharSequence)"key", (Charset)CharsetUtil.UTF_8), Unpooled.wrappedBuffer((byte[])new byte[]{1, 3, 4, 9}), Unpooled.copiedBuffer((CharSequence)"some value", (Charset)CharsetUtil.UTF_8));
        this.response.setStatus((short)1);
        this.response.setMagic((byte)3);
        this.response.setOpcode((byte)2);
        this.response.setKeyLength((short)32);
        this.response.setExtrasLength((byte)34);
        this.response.setDataType((byte)43);
        this.response.setTotalBodyLength(345);
        this.response.setOpaque(3);
        this.response.setCas(345345L);
    }

    @Test
    public void fullCopy() {
        FullBinaryMemcacheResponse newInstance = this.response.copy();
        try {
            this.assertResponseEquals((FullBinaryMemcacheResponse)this.response, this.response.content(), newInstance);
        }
        finally {
            this.response.release();
            newInstance.release();
        }
    }

    @Test
    public void fullDuplicate() {
        try {
            this.assertResponseEquals((FullBinaryMemcacheResponse)this.response, this.response.content(), this.response.duplicate());
        }
        finally {
            this.response.release();
        }
    }

    @Test
    public void fullReplace() {
        ByteBuf newContent = Unpooled.copiedBuffer((CharSequence)"new value", (Charset)CharsetUtil.UTF_8);
        FullBinaryMemcacheResponse newInstance = this.response.replace(newContent);
        try {
            this.assertResponseEquals((FullBinaryMemcacheResponse)this.response, newContent, newInstance);
        }
        finally {
            this.response.release();
            newInstance.release();
        }
    }

    private void assertResponseEquals(FullBinaryMemcacheResponse expected, ByteBuf expectedContent, FullBinaryMemcacheResponse actual) {
        Assertions.assertNotSame((Object)expected, (Object)actual);
        Assertions.assertEquals((Object)expected.key(), (Object)actual.key());
        Assertions.assertEquals((Object)expected.extras(), (Object)actual.extras());
        Assertions.assertEquals((Object)expectedContent, (Object)actual.content());
        Assertions.assertEquals((short)expected.status(), (short)actual.status());
        Assertions.assertEquals((byte)expected.magic(), (byte)actual.magic());
        Assertions.assertEquals((byte)expected.opcode(), (byte)actual.opcode());
        Assertions.assertEquals((short)expected.keyLength(), (short)actual.keyLength());
        Assertions.assertEquals((byte)expected.extrasLength(), (byte)actual.extrasLength());
        Assertions.assertEquals((byte)expected.dataType(), (byte)actual.dataType());
        Assertions.assertEquals((int)expected.totalBodyLength(), (int)actual.totalBodyLength());
        Assertions.assertEquals((int)expected.opaque(), (int)actual.opaque());
        Assertions.assertEquals((long)expected.cas(), (long)actual.cas());
    }
}

