/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.memcache.binary;

import java.nio.charset.Charset;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.memcache.DefaultLastMemcacheContent;
import org.apache.hive.druid.io.netty.handler.codec.memcache.DefaultMemcacheContent;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.BinaryMemcacheObjectAggregator;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.BinaryMemcacheRequestDecoder;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.BinaryMemcacheRequestEncoder;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheRequest;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheRequest;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BinaryMemcacheObjectAggregatorTest {
    private static final byte[] SET_REQUEST_WITH_CONTENT = new byte[]{-128, 1, 0, 3, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 102, 111, 111, 1, 2, 3, 4, 5, 6, 7, 8};
    public static final int MAX_CONTENT_SIZE = 2048;
    private EmbeddedChannel channel;

    @Test
    public void shouldAggregateChunksOnDecode() {
        int smallBatchSize = 2;
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new BinaryMemcacheRequestDecoder(smallBatchSize), new BinaryMemcacheObjectAggregator(2048)});
        ByteBuf incoming = Unpooled.buffer();
        incoming.writeBytes(SET_REQUEST_WITH_CONTENT);
        this.channel.writeInbound(new Object[]{incoming});
        FullBinaryMemcacheRequest request = (FullBinaryMemcacheRequest)this.channel.readInbound();
        MatcherAssert.assertThat((Object)request, (Matcher)CoreMatchers.instanceOf(FullBinaryMemcacheRequest.class));
        MatcherAssert.assertThat((Object)request, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)request.key(), (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)request.extras(), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)request.content().readableBytes(), (Matcher)CoreMatchers.is((Object)8));
        MatcherAssert.assertThat((Object)request.content().readByte(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)request.content().readByte(), (Matcher)CoreMatchers.is((Object)2));
        request.release();
        MatcherAssert.assertThat((Object)this.channel.readInbound(), (Matcher)IsNull.nullValue());
        Assertions.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void shouldRetainByteBufWhenAggregating() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new BinaryMemcacheRequestEncoder(), new BinaryMemcacheRequestDecoder(), new BinaryMemcacheObjectAggregator(2048)});
        ByteBuf key = Unpooled.copiedBuffer((CharSequence)"Netty", (Charset)CharsetUtil.UTF_8);
        ByteBuf extras = Unpooled.copiedBuffer((CharSequence)"extras", (Charset)CharsetUtil.UTF_8);
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key, extras);
        DefaultMemcacheContent content1 = new DefaultMemcacheContent(Unpooled.copiedBuffer((CharSequence)"Netty", (Charset)CharsetUtil.UTF_8));
        DefaultLastMemcacheContent content2 = new DefaultLastMemcacheContent(Unpooled.copiedBuffer((CharSequence)" Rocks!", (Charset)CharsetUtil.UTF_8));
        int totalBodyLength = key.readableBytes() + extras.readableBytes() + content1.content().readableBytes() + content2.content().readableBytes();
        request.setTotalBodyLength(totalBodyLength);
        Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{request, content1, content2}));
        MatcherAssert.assertThat((Object)this.channel.outboundMessages().size(), (Matcher)CoreMatchers.is((Object)3));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{this.channel.readOutbound(), this.channel.readOutbound(), this.channel.readOutbound()}));
        FullBinaryMemcacheRequest read = (FullBinaryMemcacheRequest)this.channel.readInbound();
        MatcherAssert.assertThat((Object)read, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)read.key().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"Netty"));
        MatcherAssert.assertThat((Object)read.extras().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"extras"));
        MatcherAssert.assertThat((Object)read.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"Netty Rocks!"));
        read.release();
        Assertions.assertFalse((boolean)this.channel.finish());
    }
}

