/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hive.druid.io.netty.bootstrap.Bootstrap;
import org.apache.hive.druid.io.netty.bootstrap.ServerBootstrap;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelInitializer;
import org.apache.hive.druid.io.netty.channel.DefaultEventLoop;
import org.apache.hive.druid.io.netty.channel.EventLoopGroup;
import org.apache.hive.druid.io.netty.channel.local.LocalAddress;
import org.apache.hive.druid.io.netty.channel.local.LocalChannel;
import org.apache.hive.druid.io.netty.channel.local.LocalServerChannel;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2MultiplexHandler;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2StreamChannel;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import org.apache.hive.druid.io.netty.util.concurrent.DefaultPromise;
import org.apache.hive.druid.io.netty.util.concurrent.EventExecutor;
import org.apache.hive.druid.io.netty.util.concurrent.Promise;
import org.apache.hive.druid.io.netty.util.internal.logging.InternalLogger;
import org.apache.hive.druid.io.netty.util.internal.logging.InternalLoggerFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;

public class Http2StreamChannelBootstrapTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2StreamChannelBootstrapTest.class);
    private volatile Channel serverConnectedChannel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStreamIsNotCreatedIfParentConnectionIsClosedConcurrently() throws Exception {
        DefaultEventLoop group = null;
        Channel serverChannel = null;
        Channel clientChannel = null;
        try {
            final CountDownLatch serverChannelLatch = new CountDownLatch(1);
            group = new DefaultEventLoop();
            LocalAddress serverAddress = new LocalAddress(this.getClass().getName());
            ServerBootstrap sb = ((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).group((EventLoopGroup)group).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    Http2StreamChannelBootstrapTest.this.serverConnectedChannel = ch;
                    ch.pipeline().addLast(new ChannelHandler[]{Http2FrameCodecBuilder.forServer().build(), Http2StreamChannelBootstrapTest.newMultiplexedHandler()});
                    serverChannelLatch.countDown();
                }
            });
            serverChannel = sb.bind((SocketAddress)serverAddress).sync().channel();
            Bootstrap cb = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group((EventLoopGroup)group)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{Http2FrameCodecBuilder.forClient().build(), Http2StreamChannelBootstrapTest.newMultiplexedHandler()});
                }
            });
            clientChannel = cb.connect((SocketAddress)serverAddress).sync().channel();
            Assertions.assertTrue((boolean)serverChannelLatch.await(3L, TimeUnit.SECONDS));
            final CountDownLatch closeLatch = new CountDownLatch(1);
            final Channel clientChannelToClose = clientChannel;
            group.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        closeLatch.await();
                        clientChannelToClose.close().syncUninterruptibly();
                    }
                    catch (InterruptedException e) {
                        logger.error((Throwable)e);
                    }
                }
            });
            Http2StreamChannelBootstrap bootstrap = new Http2StreamChannelBootstrap(clientChannel);
            final Promise promise = clientChannel.eventLoop().newPromise();
            bootstrap.open(promise);
            MatcherAssert.assertThat((Object)promise.isDone(), (Matcher)Matchers.is((Object)false));
            closeLatch.countDown();
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    promise.get(3L, TimeUnit.SECONDS);
                }
            });
            MatcherAssert.assertThat((Object)exception.getCause(), (Matcher)IsInstanceOf.instanceOf(ClosedChannelException.class));
        }
        catch (Throwable throwable) {
            Http2StreamChannelBootstrapTest.safeClose(clientChannel);
            Http2StreamChannelBootstrapTest.safeClose(this.serverConnectedChannel);
            Http2StreamChannelBootstrapTest.safeClose(serverChannel);
            if (group != null) {
                group.shutdownGracefully(0L, 3L, TimeUnit.SECONDS);
            }
            throw throwable;
        }
        Http2StreamChannelBootstrapTest.safeClose(clientChannel);
        Http2StreamChannelBootstrapTest.safeClose(this.serverConnectedChannel);
        Http2StreamChannelBootstrapTest.safeClose(serverChannel);
        if (group != null) {
            group.shutdownGracefully(0L, 3L, TimeUnit.SECONDS);
        }
    }

    private static Http2MultiplexHandler newMultiplexedHandler() {
        return new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Http2StreamChannel>(){

            protected void initChannel(Http2StreamChannel ch) {
            }
        });
    }

    private static void safeClose(Channel channel) {
        if (channel != null) {
            try {
                channel.close().syncUninterruptibly();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    @Test
    public void open0FailsPromiseOnHttp2MultiplexHandlerError() {
        Http2StreamChannelBootstrap bootstrap = new Http2StreamChannelBootstrap((Channel)Mockito.mock(Channel.class));
        Http2MultiplexHandler handler = new Http2MultiplexHandler((ChannelHandler)Mockito.mock(ChannelHandler.class));
        EventExecutor executor = (EventExecutor)Mockito.mock(EventExecutor.class);
        Mockito.when((Object)executor.inEventLoop()).thenReturn((Object)true);
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)ctx.executor()).thenReturn((Object)executor);
        Mockito.when((Object)ctx.handler()).thenReturn((Object)handler);
        DefaultPromise promise = new DefaultPromise((EventExecutor)Mockito.mock(EventExecutor.class));
        bootstrap.open0(ctx, (Promise)promise);
        MatcherAssert.assertThat((Object)promise.isDone(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)promise.cause(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class)));
    }
}

