/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import java.io.File;
import java.io.InputStream;
import org.apache.hive.druid.io.netty.handler.codec.http2.HpackTestCase;
import org.apache.hive.druid.io.netty.util.internal.ObjectUtil;
import org.apache.hive.druid.io.netty.util.internal.ResourcesUtil;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class HpackTest {
    private static final String TEST_DIR = '/' + HpackTest.class.getPackage().getName().replaceAll("\\.", "/") + "/testdata/";

    public static File[] files() {
        File[] files = ResourcesUtil.getFile(HpackTest.class, (String)TEST_DIR).listFiles();
        ObjectUtil.checkNotNull((Object)files, (String)"files");
        return files;
    }

    @ParameterizedTest(name="file = {0}")
    @MethodSource(value={"files"})
    public void test(File file) throws Exception {
        InputStream is = HpackTest.class.getResourceAsStream(TEST_DIR + file.getName());
        HpackTestCase hpackTestCase = HpackTestCase.load(is);
        hpackTestCase.testCompress();
        hpackTestCase.testDecompress();
    }
}

