/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import java.util.Random;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2Headers;
import org.apache.hive.druid.io.netty.handler.codec.http2.HpackDecoder;
import org.apache.hive.druid.io.netty.handler.codec.http2.HpackEncoder;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Exception;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Headers;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2HeadersEncoder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;

public class HpackEncoderTest {
    private HpackDecoder hpackDecoder;
    private HpackEncoder hpackEncoder;
    private Http2Headers mockHeaders;
    private ByteBuf buf;

    @BeforeEach
    public void setUp() {
        this.hpackEncoder = new HpackEncoder();
        this.hpackDecoder = new HpackDecoder(8192L);
        this.mockHeaders = (Http2Headers)Mockito.mock(Http2Headers.class);
        this.buf = Unpooled.buffer();
    }

    @AfterEach
    public void teardown() {
        this.buf.release();
    }

    @Test
    public void testSetMaxHeaderTableSizeToMaxValue() throws Http2Exception {
        this.hpackEncoder.setMaxHeaderTableSize(this.buf, 0xFFFFFFFFL);
        this.hpackDecoder.setMaxHeaderTableSize(0xFFFFFFFFL);
        this.hpackDecoder.decode(0, this.buf, this.mockHeaders, true);
        Assertions.assertEquals((long)0xFFFFFFFFL, (long)this.hpackDecoder.getMaxHeaderTableSize());
    }

    @Test
    public void testSetMaxHeaderTableSizeOverflow() {
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackEncoderTest.this.hpackEncoder.setMaxHeaderTableSize(HpackEncoderTest.this.buf, 0x100000000L);
            }
        });
    }

    @Test
    public void testWillEncode16MBHeaderByDefault() throws Http2Exception {
        String bigHeaderName = "x-big-header";
        int bigHeaderSize = 0x1000000;
        String bigHeaderVal = new String(new char[bigHeaderSize]).replace('\u0000', 'X');
        Http2Headers headersIn = (Http2Headers)new DefaultHttp2Headers().add((Object)"x-big-header", (Object)bigHeaderVal);
        DefaultHttp2Headers headersOut = new DefaultHttp2Headers();
        this.hpackEncoder.encodeHeaders(0, this.buf, headersIn, Http2HeadersEncoder.NEVER_SENSITIVE);
        this.hpackDecoder.setMaxHeaderListSize((long)(bigHeaderSize + 1024));
        this.hpackDecoder.decode(0, this.buf, (Http2Headers)headersOut, false);
        Assertions.assertEquals((Object)((CharSequence)headersOut.get((Object)bigHeaderName)).toString(), (Object)bigHeaderVal);
    }

    @Test
    public void testSetMaxHeaderListSizeEnforcedAfterSet() throws Http2Exception {
        final Http2Headers headers = (Http2Headers)new DefaultHttp2Headers().add((Object)"x-big-header", (Object)new String(new char[16384]).replace('\u0000', 'X'));
        this.hpackEncoder.setMaxHeaderListSize(1000L);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackEncoderTest.this.hpackEncoder.encodeHeaders(0, HpackEncoderTest.this.buf, headers, Http2HeadersEncoder.NEVER_SENSITIVE);
            }
        });
    }

    @Test
    public void testEncodeUsingBothStaticAndDynamicTable() throws Http2Exception {
        Http2Headers headers = (Http2Headers)((Http2Headers)((Http2Headers)((Http2Headers)new DefaultHttp2Headers().add((Object)":method", (Object)"POST")).add((Object)":path", (Object)"/dev/null")).add((Object)"accept-language", (Object)"fr")).add((Object)"k", (Object)"x");
        this.verifyEncoding(headers, -125, 68, 9, 47, 100, 101, 118, 47, 110, 117, 108, 108, 81, 2, 102, 114, 64, 1, 107, 1, 120);
        this.verifyEncoding(headers, -125, -64, -65, -66);
    }

    @Test
    public void testSameHeaderNameMultipleValues() throws Http2Exception {
        Http2Headers headers = (Http2Headers)((Http2Headers)new DefaultHttp2Headers().add((Object)"k", (Object)"x")).add((Object)"k", (Object)"y");
        this.verifyEncoding(headers, 64, 1, 107, 1, 120, 126, 1, 121);
        this.verifyEncoding(headers, -65, -66);
    }

    @Test
    public void testEviction() throws Http2Exception {
        this.setMaxTableSize(67);
        this.verifyEncoding((Http2Headers)new DefaultHttp2Headers().add((Object)"k", (Object)"x"), 63, 36, 64, 1, 107, 1, 120);
        this.verifyEncoding((Http2Headers)new DefaultHttp2Headers().add((Object)"k", (Object)"x"), -66);
        this.verifyEncoding((Http2Headers)new DefaultHttp2Headers().add((Object)"k", (Object)"y"), 64, 1, 107, 1, 121);
        this.verifyEncoding((Http2Headers)new DefaultHttp2Headers().add((Object)"k", (Object)"x"), 64, 1, 107, 1, 120);
    }

    @Test
    public void testTableResize() throws Http2Exception {
        this.verifyEncoding((Http2Headers)((Http2Headers)new DefaultHttp2Headers().add((Object)"k", (Object)"x")).add((Object)"k", (Object)"y"), 64, 1, 107, 1, 120, 126, 1, 121);
        this.verifyEncoding((Http2Headers)new DefaultHttp2Headers().add((Object)"k", (Object)"x"), -65);
        this.setMaxTableSize(67);
        this.verifyEncoding((Http2Headers)new DefaultHttp2Headers().add((Object)"k", (Object)"x"), 63, 36, 64, 1, 107, 1, 120);
        this.setMaxTableSize(1000);
        this.verifyEncoding((Http2Headers)new DefaultHttp2Headers().add((Object)"k", (Object)"y"), 63, -55, 7, 126, 1, 121);
        this.verifyEncoding((Http2Headers)((Http2Headers)new DefaultHttp2Headers().add((Object)"k", (Object)"x")).add((Object)"k", (Object)"y"), -65, -66);
    }

    @Test
    public void testManyHeaderCombinations() throws Http2Exception {
        Random r = new Random(0L);
        for (int i = 0; i < 50000; ++i) {
            if (r.nextInt(10) == 0) {
                this.setMaxTableSize(r.nextBoolean() ? 0 : r.nextInt(4096));
            }
            this.verifyRoundTrip((Http2Headers)((Http2Headers)((Http2Headers)((Http2Headers)new DefaultHttp2Headers().add((Object)("k" + r.nextInt(20)), (Object)("x" + r.nextInt(500)))).add((Object)":method", (Object)(r.nextBoolean() ? "GET" : "POST"))).add((Object)":path", (Object)"/dev/null")).add((Object)"accept-language", (Object)String.valueOf(r.nextBoolean())));
            this.buf.clear();
        }
    }

    @Test
    public void testSanitization() throws Http2Exception {
        int headerValueSize = 300;
        StringBuilder actualHeaderValueBuilder = new StringBuilder();
        StringBuilder expectedHeaderValueBuilder = new StringBuilder();
        for (int i = 0; i < 300; ++i) {
            actualHeaderValueBuilder.append((char)i);
            if (i <= 255) {
                expectedHeaderValueBuilder.append((char)i);
                continue;
            }
            expectedHeaderValueBuilder.append('?');
        }
        String actualHeaderValue = actualHeaderValueBuilder.toString();
        String expectedHeaderValue = expectedHeaderValueBuilder.toString();
        HpackEncoder encoderWithHuffmanEncoding = new HpackEncoder(false, 64, 0);
        HpackEncoder encoderWithoutHuffmanEncoding = new HpackEncoder(false, 64, Integer.MAX_VALUE);
        this.verifyHeaderValueSanitization(encoderWithHuffmanEncoding, actualHeaderValue, expectedHeaderValue);
        this.verifyHeaderValueSanitization(encoderWithoutHuffmanEncoding, actualHeaderValue, expectedHeaderValue);
    }

    private void verifyHeaderValueSanitization(HpackEncoder encoder, String actualHeaderValue, String expectedHeaderValue) throws Http2Exception {
        String headerKey = "some-key";
        Http2Headers toBeEncodedHeaders = (Http2Headers)new DefaultHttp2Headers().add((Object)headerKey, (Object)actualHeaderValue);
        encoder.encodeHeaders(0, this.buf, toBeEncodedHeaders, Http2HeadersEncoder.NEVER_SENSITIVE);
        DefaultHttp2Headers decodedHeaders = new DefaultHttp2Headers();
        this.hpackDecoder.decode(0, this.buf, (Http2Headers)decodedHeaders, true);
        this.buf.clear();
        String decodedHeaderValue = ((CharSequence)decodedHeaders.get((Object)headerKey)).toString();
        Assertions.assertEquals((Object)expectedHeaderValue, (Object)decodedHeaderValue);
    }

    private void setMaxTableSize(int maxHeaderTableSize) throws Http2Exception {
        this.hpackEncoder.setMaxHeaderTableSize(this.buf, (long)maxHeaderTableSize);
        this.hpackDecoder.setMaxHeaderTableSize((long)maxHeaderTableSize);
    }

    private void verifyEncoding(Http2Headers encodedHeaders, int ... encoding) throws Http2Exception {
        this.verifyRoundTrip(encodedHeaders);
        this.verifyEncodedBytes(encoding);
        this.buf.clear();
    }

    private void verifyRoundTrip(Http2Headers encodedHeaders) throws Http2Exception {
        this.hpackEncoder.encodeHeaders(0, this.buf, encodedHeaders, Http2HeadersEncoder.NEVER_SENSITIVE);
        DefaultHttp2Headers decodedHeaders = new DefaultHttp2Headers();
        this.hpackDecoder.decode(0, this.buf, (Http2Headers)decodedHeaders, true);
        Assertions.assertEquals((Object)encodedHeaders, (Object)decodedHeaders);
    }

    private void verifyEncodedBytes(int ... expectedEncoding) {
        byte[] actualEncoding = new byte[this.buf.writerIndex()];
        this.buf.getBytes(0, actualEncoding);
        Assertions.assertArrayEquals((byte[])this.toByteArray(expectedEncoding), (byte[])actualEncoding);
    }

    private byte[] toByteArray(int[] encoding) {
        byte[] expectedEncoding = new byte[encoding.length];
        for (int i = 0; i < encoding.length; ++i) {
            expectedEncoding[i] = (byte)encoding[i];
        }
        return expectedEncoding;
    }
}

