/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.channel.kqueue;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Random;
import org.apache.hive.druid.io.netty.bootstrap.Bootstrap;
import org.apache.hive.druid.io.netty.channel.ChannelException;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hive.druid.io.netty.channel.EventLoopGroup;
import org.apache.hive.druid.io.netty.channel.kqueue.BsdSocket;
import org.apache.hive.druid.io.netty.channel.kqueue.KQueueEventLoopGroup;
import org.apache.hive.druid.io.netty.channel.kqueue.KQueueSocketChannel;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.opentest4j.TestAbortedException;

public class KQueueSocketChannelConfigTest {
    private static EventLoopGroup group;
    private static KQueueSocketChannel ch;
    private static Random rand;

    @BeforeAll
    public static void beforeClass() {
        rand = new Random();
        group = new KQueueEventLoopGroup(1);
    }

    @AfterAll
    public static void afterClass() {
        group.shutdownGracefully();
    }

    @BeforeEach
    public void setup() {
        Bootstrap bootstrap = new Bootstrap();
        ch = (KQueueSocketChannel)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(KQueueSocketChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
    }

    @AfterEach
    public void teardown() {
        ch.close().syncUninterruptibly();
    }

    @Test
    public void testRandomSndLowAt() {
        int actual;
        int expected = Math.min(BsdSocket.BSD_SND_LOW_AT_MAX, Math.abs(rand.nextInt()));
        try {
            ch.config().setSndLowAt(expected);
            actual = ch.config().getSndLowAt();
        }
        catch (RuntimeException e) {
            throw new TestAbortedException("assumeNoException", (Throwable)e);
        }
        Assertions.assertEquals((int)expected, (int)actual);
    }

    @Test
    public void testInvalidHighSndLowAt() {
        try {
            ch.config().setSndLowAt(Integer.MIN_VALUE);
        }
        catch (ChannelException e) {
            return;
        }
        catch (RuntimeException e) {
            throw new TestAbortedException("assumeNoException", (Throwable)e);
        }
        Assertions.fail();
    }

    @Test
    public void testTcpNoPush() {
        ch.config().setTcpNoPush(false);
        Assertions.assertFalse((boolean)ch.config().isTcpNoPush());
        ch.config().setTcpNoPush(true);
        Assertions.assertTrue((boolean)ch.config().isTcpNoPush());
    }

    @Test
    public void testSetOptionWhenClosed() {
        ch.close().syncUninterruptibly();
        try {
            ch.config().setSoLinger(0);
            Assertions.fail();
        }
        catch (ChannelException e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof ClosedChannelException));
        }
    }

    @Test
    public void testGetOptionWhenClosed() {
        ch.close().syncUninterruptibly();
        try {
            ch.config().getSoLinger();
            Assertions.fail();
        }
        catch (ChannelException e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof ClosedChannelException));
        }
    }
}

