/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.channel.epoll;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.druid.io.netty.bootstrap.Bootstrap;
import org.apache.hive.druid.io.netty.bootstrap.ServerBootstrap;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelFuture;
import org.apache.hive.druid.io.netty.channel.ChannelFutureListener;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hive.druid.io.netty.channel.EventLoopGroup;
import org.apache.hive.druid.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hive.druid.io.netty.channel.epoll.AbstractEpollStreamChannel;
import org.apache.hive.druid.io.netty.channel.epoll.EpollChannelOption;
import org.apache.hive.druid.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.hive.druid.io.netty.channel.epoll.EpollMode;
import org.apache.hive.druid.io.netty.channel.epoll.EpollServerSocketChannel;
import org.apache.hive.druid.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.hive.druid.io.netty.channel.unix.FileDescriptor;
import org.apache.hive.druid.io.netty.util.NetUtil;
import org.apache.hive.druid.io.netty.util.concurrent.GenericFutureListener;
import org.apache.hive.druid.io.netty.util.internal.PlatformDependent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class EpollSpliceTest {
    private static final int SPLICE_LEN = 32768;
    private static final Random random = new Random();
    private static final byte[] data = new byte[0x100000];

    @Test
    public void spliceToSocket() throws Throwable {
        int length;
        EchoHandler sh = new EchoHandler();
        EchoHandler ch = new EchoHandler();
        EpollEventLoopGroup group = new EpollEventLoopGroup(1);
        ServerBootstrap bs = new ServerBootstrap();
        bs.channel(EpollServerSocketChannel.class);
        bs.group((EventLoopGroup)group).childHandler((ChannelHandler)sh);
        final Channel sc = bs.bind(NetUtil.LOCALHOST, 0).syncUninterruptibly().channel();
        ServerBootstrap bs2 = new ServerBootstrap();
        bs2.channel(EpollServerSocketChannel.class);
        bs2.childOption(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.LEVEL_TRIGGERED);
        bs2.group((EventLoopGroup)group).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelActive(final ChannelHandlerContext ctx) throws Exception {
                ctx.channel().config().setAutoRead(false);
                Bootstrap bs = new Bootstrap();
                bs.option(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.LEVEL_TRIGGERED);
                bs.channel(EpollSocketChannel.class);
                ((Bootstrap)bs.group((EventLoopGroup)ctx.channel().eventLoop())).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                    public void channelActive(ChannelHandlerContext context) throws Exception {
                        final EpollSocketChannel ch = (EpollSocketChannel)ctx.channel();
                        final EpollSocketChannel ch2 = (EpollSocketChannel)context.channel();
                        ch.spliceTo((AbstractEpollStreamChannel)ch2, Integer.MAX_VALUE).addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (!future.isSuccess()) {
                                    future.channel().close();
                                }
                            }
                        });
                        ch2.spliceTo((AbstractEpollStreamChannel)ch, 32768).addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (!future.isSuccess()) {
                                    future.channel().close();
                                } else {
                                    ch2.spliceTo((AbstractEpollStreamChannel)ch, 32768).addListener((GenericFutureListener)this);
                                }
                            }
                        });
                        ctx.channel().config().setAutoRead(true);
                    }

                    public void channelInactive(ChannelHandlerContext context) throws Exception {
                        context.close();
                    }
                });
                bs.connect(sc.localAddress()).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            ctx.close();
                        } else {
                            future.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                                public void operationComplete(ChannelFuture future) throws Exception {
                                    ctx.close();
                                }
                            });
                        }
                    }
                });
            }
        });
        Channel pc = bs2.bind(NetUtil.LOCALHOST, 0).syncUninterruptibly().channel();
        Bootstrap cb = new Bootstrap();
        cb.group((EventLoopGroup)group);
        cb.channel(EpollSocketChannel.class);
        cb.handler((ChannelHandler)ch);
        Channel cc = cb.connect(pc.localAddress()).syncUninterruptibly().channel();
        for (int i = 0; i < data.length; i += length) {
            length = Math.min(random.nextInt(65536), data.length - i);
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])data, (int)i, (int)length);
            cc.writeAndFlush((Object)buf);
        }
        while (ch.counter < data.length && sh.exception.get() == null && ch.exception.get() == null) {
            Thread.sleep(50L);
        }
        while (sh.counter < data.length && sh.exception.get() == null && ch.exception.get() == null) {
            Thread.sleep(50L);
        }
        sh.channel.close().sync();
        ch.channel.close().sync();
        sc.close().sync();
        pc.close().sync();
        group.shutdownGracefully();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void spliceToFile() throws Throwable {
        int length;
        EpollEventLoopGroup group = new EpollEventLoopGroup(1);
        File file = PlatformDependent.createTempFile((String)"netty-splice", null, null);
        file.deleteOnExit();
        SpliceHandler sh = new SpliceHandler(file);
        ServerBootstrap bs = new ServerBootstrap();
        bs.channel(EpollServerSocketChannel.class);
        bs.group((EventLoopGroup)group).childHandler((ChannelHandler)sh);
        bs.childOption(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.LEVEL_TRIGGERED);
        Channel sc = bs.bind(NetUtil.LOCALHOST, 0).syncUninterruptibly().channel();
        Bootstrap cb = new Bootstrap();
        cb.group((EventLoopGroup)group);
        cb.channel(EpollSocketChannel.class);
        cb.handler((ChannelHandler)new ChannelInboundHandlerAdapter());
        Channel cc = cb.connect(sc.localAddress()).syncUninterruptibly().channel();
        for (int i = 0; i < data.length; i += length) {
            length = Math.min(random.nextInt(65536), data.length - i);
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])data, (int)i, (int)length);
            cc.writeAndFlush((Object)buf);
        }
        while (!(sh.future2 != null && sh.future2.isDone() && sh.future.isDone() || sh.exception.get() != null)) {
            Thread.sleep(50L);
        }
        sc.close().sync();
        cc.close().sync();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        byte[] written = new byte[data.length];
        FileInputStream in = new FileInputStream(file);
        try {
            Assertions.assertEquals((int)written.length, (int)in.read(written));
            Assertions.assertArrayEquals((byte[])data, (byte[])written);
        }
        finally {
            in.close();
            group.shutdownGracefully();
        }
    }

    static {
        random.nextBytes(data);
    }

    private static class SpliceHandler
    extends ChannelInboundHandlerAdapter {
        private final File file;
        volatile ChannelFuture future;
        volatile ChannelFuture future2;
        final AtomicReference<Throwable> exception = new AtomicReference();

        SpliceHandler(File file) {
            this.file = file;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            EpollSocketChannel ch = (EpollSocketChannel)ctx.channel();
            FileDescriptor fd = FileDescriptor.from((File)this.file);
            this.future = ch.spliceTo(fd, 0, data.length / 2);
            this.future2 = ch.spliceTo(fd, data.length / 2, data.length / 2);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                cause.printStackTrace();
                ctx.close();
            }
        }
    }

    private static class EchoHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();
        volatile int counter;

        private EchoHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            byte[] actual = new byte[in.readableBytes()];
            in.readBytes(actual);
            int lastIdx = this.counter;
            for (int i = 0; i < actual.length; ++i) {
                Assertions.assertEquals((byte)data[i + lastIdx], (byte)actual[i]);
            }
            if (this.channel.parent() != null) {
                this.channel.write((Object)Unpooled.wrappedBuffer((byte[])actual));
            }
            this.counter += actual.length;
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            ctx.flush();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                cause.printStackTrace();
                ctx.close();
            }
        }
    }
}

