/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.initialization.jetty;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.server.initialization.jetty.LimitRequestsFilter;
import org.easymock.EasyMock;
import org.junit.Test;

public class LimitRequestsFilterTest {
    @Test(timeout=5000L)
    public void testSimple() throws Exception {
        LimitRequestsFilter filter = new LimitRequestsFilter(2);
        CountDownLatch latch1 = this.createAndStartRequestThread(filter, (ServletRequest)EasyMock.createStrictMock(ServletRequest.class), (HttpServletResponse)EasyMock.createStrictMock(HttpServletResponse.class));
        CountDownLatch latch2 = this.createAndStartRequestThread(filter, (ServletRequest)EasyMock.createStrictMock(ServletRequest.class), (HttpServletResponse)EasyMock.createStrictMock(HttpServletResponse.class));
        while (filter.getActiveRequestsCount() != 2) {
            Thread.sleep(100L);
        }
        HttpServletResponse resp = (HttpServletResponse)EasyMock.createMock(HttpServletResponse.class);
        resp.sendError(429, "Too Many Requests");
        EasyMock.expectLastCall().times(2);
        EasyMock.replay((Object[])new Object[]{resp});
        filter.doFilter((ServletRequest)EasyMock.createStrictMock(ServletRequest.class), (ServletResponse)resp, (FilterChain)EasyMock.createStrictMock(FilterChain.class));
        filter.doFilter((ServletRequest)EasyMock.createStrictMock(ServletRequest.class), (ServletResponse)resp, (FilterChain)EasyMock.createStrictMock(FilterChain.class));
        EasyMock.verify((Object[])new Object[]{resp});
        latch1.countDown();
        while (filter.getActiveRequestsCount() != 1) {
            Thread.sleep(100L);
        }
        FilterChain chain = (FilterChain)EasyMock.createMock(FilterChain.class);
        chain.doFilter((ServletRequest)EasyMock.anyObject(), (ServletResponse)EasyMock.anyObject());
        EasyMock.expectLastCall().times(2);
        EasyMock.replay((Object[])new Object[]{chain});
        filter.doFilter((ServletRequest)EasyMock.createStrictMock(ServletRequest.class), (ServletResponse)EasyMock.createStrictMock(HttpServletResponse.class), chain);
        filter.doFilter((ServletRequest)EasyMock.createStrictMock(ServletRequest.class), (ServletResponse)EasyMock.createStrictMock(HttpServletResponse.class), chain);
        EasyMock.verify((Object[])new Object[]{chain});
        latch2.countDown();
        while (filter.getActiveRequestsCount() != 0) {
            Thread.sleep(100L);
        }
    }

    private CountDownLatch createAndStartRequestThread(LimitRequestsFilter filter, ServletRequest req, HttpServletResponse resp) {
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> {
            try {
                filter.doFilter(req, (ServletResponse)resp, (FilterChain)new TestFilterChain(latch));
            }
            catch (Exception e) {
                throw new ISE((Throwable)e, "exception", new Object[0]);
            }
        }).start();
        return latch;
    }

    private static class TestFilterChain
    implements FilterChain {
        private final CountDownLatch latch;

        TestFilterChain(CountDownLatch latch) {
            this.latch = latch;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            try {
                this.latch.await();
            }
            catch (InterruptedException ex) {
                throw new ISE((Throwable)ex, "exception", new Object[0]);
            }
        }
    }
}

