/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.client.DruidServer;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.server.coordination.ServerType;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorStats;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeonTester;
import org.apache.hive.druid.io.druid.server.coordinator.SegmentReplicantLookup;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.server.coordinator.rules.ForeverBroadcastDistributionRule;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BroadcastDistributionRuleTest {
    private DruidCluster druidCluster;
    private ServerHolder holderOfSmallSegment;
    private List<ServerHolder> holdersOfLargeSegments = Lists.newArrayList();
    private List<ServerHolder> holdersOfLargeSegments2 = Lists.newArrayList();
    private final List<DataSegment> largeSegments = Lists.newArrayList();
    private final List<DataSegment> largeSegments2 = Lists.newArrayList();
    private DataSegment smallSegment;

    @Before
    public void setUp() throws Exception {
        int i;
        this.smallSegment = new DataSegment("small_source", Intervals.of((String)"0/1000"), DateTimes.nowUtc().toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 0L);
        for (i = 0; i < 3; ++i) {
            this.largeSegments.add(new DataSegment("large_source", Intervals.of((String)(i * 1000 + "/" + (i + 1) * 1000)), DateTimes.nowUtc().toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 100L));
        }
        for (i = 0; i < 2; ++i) {
            this.largeSegments2.add(new DataSegment("large_source2", Intervals.of((String)(i * 1000 + "/" + (i + 1) * 1000)), DateTimes.nowUtc().toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 100L));
        }
        this.holderOfSmallSegment = new ServerHolder(new DruidServer("serverHot2", "hostHot2", null, 1000L, ServerType.HISTORICAL, "hot", 0).addDataSegment(this.smallSegment).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester());
        this.holdersOfLargeSegments.add(new ServerHolder(new DruidServer("serverHot1", "hostHot1", null, 1000L, ServerType.HISTORICAL, "hot", 0).addDataSegment(this.largeSegments.get(0)).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester()));
        this.holdersOfLargeSegments.add(new ServerHolder(new DruidServer("serverNorm1", "hostNorm1", null, 1000L, ServerType.HISTORICAL, "_default_tier", 0).addDataSegment(this.largeSegments.get(1)).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester()));
        this.holdersOfLargeSegments.add(new ServerHolder(new DruidServer("serverNorm2", "hostNorm2", null, 100L, ServerType.HISTORICAL, "_default_tier", 0).addDataSegment(this.largeSegments.get(2)).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester()));
        this.holdersOfLargeSegments2.add(new ServerHolder(new DruidServer("serverHot3", "hostHot3", null, 1000L, ServerType.HISTORICAL, "hot", 0).addDataSegment(this.largeSegments2.get(0)).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester()));
        this.holdersOfLargeSegments2.add(new ServerHolder(new DruidServer("serverNorm3", "hostNorm3", null, 100L, ServerType.HISTORICAL, "_default_tier", 0).addDataSegment(this.largeSegments2.get(1)).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester()));
        this.druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"hot", (Object)Stream.of(this.holdersOfLargeSegments.get(0), this.holderOfSmallSegment, this.holdersOfLargeSegments2.get(0)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder()))), (Object)"_default_tier", (Object)Stream.of(this.holdersOfLargeSegments.get(1), this.holdersOfLargeSegments.get(2), this.holdersOfLargeSegments2.get(1)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
    }

    @Test
    public void testBroadcastToSingleDataSource() {
        ForeverBroadcastDistributionRule rule = new ForeverBroadcastDistributionRule((List)ImmutableList.of((Object)"large_source"));
        CoordinatorStats stats = rule.run(null, DruidCoordinatorRuntimeParams.newBuilder().withDruidCluster(this.druidCluster).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)this.druidCluster)).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).withAvailableSegments((Collection)Lists.newArrayList((Object[])new DataSegment[]{this.smallSegment, this.largeSegments.get(0), this.largeSegments.get(1), this.largeSegments.get(2), this.largeSegments2.get(0), this.largeSegments2.get(1)})).build(), this.smallSegment);
        Assert.assertEquals((long)3L, (long)stats.getGlobalStat("assignedCount"));
        Assert.assertEquals((Object)false, (Object)stats.hasPerTierStats());
        Assert.assertTrue((boolean)this.holdersOfLargeSegments.stream().allMatch(holder -> holder.getPeon().getSegmentsToLoad().contains(this.smallSegment)));
        Assert.assertTrue((boolean)this.holdersOfLargeSegments2.stream().noneMatch(holder -> holder.getPeon().getSegmentsToLoad().contains(this.smallSegment)));
        Assert.assertFalse((boolean)this.holderOfSmallSegment.getPeon().getSegmentsToLoad().contains(this.smallSegment));
    }

    @Test
    public void testBroadcastToMultipleDataSources() {
        ForeverBroadcastDistributionRule rule = new ForeverBroadcastDistributionRule((List)ImmutableList.of((Object)"large_source", (Object)"large_source2"));
        CoordinatorStats stats = rule.run(null, DruidCoordinatorRuntimeParams.newBuilder().withDruidCluster(this.druidCluster).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)this.druidCluster)).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).withAvailableSegments((Collection)Lists.newArrayList((Object[])new DataSegment[]{this.smallSegment, this.largeSegments.get(0), this.largeSegments.get(1), this.largeSegments.get(2), this.largeSegments2.get(0), this.largeSegments2.get(1)})).build(), this.smallSegment);
        Assert.assertEquals((long)5L, (long)stats.getGlobalStat("assignedCount"));
        Assert.assertEquals((Object)false, (Object)stats.hasPerTierStats());
        Assert.assertTrue((boolean)this.holdersOfLargeSegments.stream().allMatch(holder -> holder.getPeon().getSegmentsToLoad().contains(this.smallSegment)));
        Assert.assertTrue((boolean)this.holdersOfLargeSegments2.stream().allMatch(holder -> holder.getPeon().getSegmentsToLoad().contains(this.smallSegment)));
        Assert.assertFalse((boolean)this.holderOfSmallSegment.getPeon().getSegmentsToLoad().contains(this.smallSegment));
    }

    @Test
    public void testBroadcastToAllServers() {
        ForeverBroadcastDistributionRule rule = new ForeverBroadcastDistributionRule(null);
        CoordinatorStats stats = rule.run(null, DruidCoordinatorRuntimeParams.newBuilder().withDruidCluster(this.druidCluster).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)this.druidCluster)).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).withAvailableSegments((Collection)Lists.newArrayList((Object[])new DataSegment[]{this.smallSegment, this.largeSegments.get(0), this.largeSegments.get(1), this.largeSegments.get(2), this.largeSegments2.get(0), this.largeSegments2.get(1)})).build(), this.smallSegment);
        Assert.assertEquals((long)6L, (long)stats.getGlobalStat("assignedCount"));
        Assert.assertEquals((Object)false, (Object)stats.hasPerTierStats());
        Assert.assertTrue((boolean)this.druidCluster.getAllServers().stream().allMatch(holder -> holder.getPeon().getSegmentsToLoad().contains(this.smallSegment)));
    }
}

