/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.server.coordinator.ReservoirSegmentSampler;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReservoirSegmentSamplerTest {
    private ImmutableDruidServer druidServer1;
    private ImmutableDruidServer druidServer2;
    private ImmutableDruidServer druidServer3;
    private ImmutableDruidServer druidServer4;
    private ServerHolder holder1;
    private ServerHolder holder2;
    private ServerHolder holder3;
    private ServerHolder holder4;
    private DataSegment segment1;
    private DataSegment segment2;
    private DataSegment segment3;
    private DataSegment segment4;
    Map<String, DataSegment> segmentsMap1;
    Map<String, DataSegment> segmentsMap2;
    Map<String, DataSegment> segmentsMap3;
    Map<String, DataSegment> segmentsMap4;
    List<DataSegment> segments;

    @Before
    public void setUp() throws Exception {
        this.druidServer1 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.druidServer2 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.druidServer3 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.druidServer4 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.holder1 = (ServerHolder)EasyMock.createMock(ServerHolder.class);
        this.holder2 = (ServerHolder)EasyMock.createMock(ServerHolder.class);
        this.holder3 = (ServerHolder)EasyMock.createMock(ServerHolder.class);
        this.holder4 = (ServerHolder)EasyMock.createMock(ServerHolder.class);
        this.segment1 = (DataSegment)EasyMock.createMock(DataSegment.class);
        this.segment2 = (DataSegment)EasyMock.createMock(DataSegment.class);
        this.segment3 = (DataSegment)EasyMock.createMock(DataSegment.class);
        this.segment4 = (DataSegment)EasyMock.createMock(DataSegment.class);
        DateTime start1 = DateTimes.of((String)"2012-01-01");
        DateTime start2 = DateTimes.of((String)"2012-02-01");
        DateTime version = DateTimes.of((String)"2012-03-01");
        this.segment1 = new DataSegment("datasource1", new Interval((ReadableInstant)start1, (ReadableInstant)start1.plusHours(1)), version.toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 11L);
        this.segment2 = new DataSegment("datasource1", new Interval((ReadableInstant)start2, (ReadableInstant)start2.plusHours(1)), version.toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 7L);
        this.segment3 = new DataSegment("datasource2", new Interval((ReadableInstant)start1, (ReadableInstant)start1.plusHours(1)), version.toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 4L);
        this.segment4 = new DataSegment("datasource2", new Interval((ReadableInstant)start2, (ReadableInstant)start2.plusHours(1)), version.toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 8L);
        this.segments = Lists.newArrayList((Object[])new DataSegment[]{this.segment1, this.segment2, this.segment3, this.segment4});
        this.segmentsMap1 = ImmutableMap.of((Object)"datasource1_2012-01-01T00:00:00.000Z_2012-01-01T01:00:00.000Z_2012-03-01T00:00:00.000Z", (Object)this.segment1);
        this.segmentsMap2 = ImmutableMap.of((Object)"datasource1_2012-02-01T00:00:00.000Z_2012-02-01T01:00:00.000Z_2012-03-01T00:00:00.000Z", (Object)this.segment2);
        this.segmentsMap3 = ImmutableMap.of((Object)"datasource2_2012-01-01T00:00:00.000Z_2012-01-01T01:00:00.000Z_2012-03-01T00:00:00.000Z", (Object)this.segment3);
        this.segmentsMap4 = ImmutableMap.of((Object)"datasource2_2012-02-01T00:00:00.000Z_2012-02-01T01:00:00.000Z_2012-03-01T00:00:00.000Z", (Object)this.segment4);
    }

    @Test
    public void getRandomBalancerSegmentHolderTest() {
        EasyMock.expect((Object)this.druidServer1.getName()).andReturn((Object)"1").atLeastOnce();
        EasyMock.expect((Object)this.druidServer1.getCurrSize()).andReturn((Object)30L).atLeastOnce();
        EasyMock.expect((Object)this.druidServer1.getMaxSize()).andReturn((Object)100L).atLeastOnce();
        EasyMock.expect((Object)this.druidServer1.getSegments()).andReturn(this.segmentsMap1).anyTimes();
        EasyMock.expect((Object)this.druidServer1.getSegment((String)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidServer1});
        EasyMock.expect((Object)this.druidServer2.getName()).andReturn((Object)"2").atLeastOnce();
        EasyMock.expect((Object)this.druidServer2.getTier()).andReturn((Object)"normal").anyTimes();
        EasyMock.expect((Object)this.druidServer2.getCurrSize()).andReturn((Object)30L).atLeastOnce();
        EasyMock.expect((Object)this.druidServer2.getMaxSize()).andReturn((Object)100L).atLeastOnce();
        EasyMock.expect((Object)this.druidServer2.getSegments()).andReturn(this.segmentsMap2).anyTimes();
        EasyMock.expect((Object)this.druidServer2.getSegment((String)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidServer2});
        EasyMock.expect((Object)this.druidServer3.getName()).andReturn((Object)"3").atLeastOnce();
        EasyMock.expect((Object)this.druidServer3.getTier()).andReturn((Object)"normal").anyTimes();
        EasyMock.expect((Object)this.druidServer3.getCurrSize()).andReturn((Object)30L).atLeastOnce();
        EasyMock.expect((Object)this.druidServer3.getMaxSize()).andReturn((Object)100L).atLeastOnce();
        EasyMock.expect((Object)this.druidServer3.getSegments()).andReturn(this.segmentsMap3).anyTimes();
        EasyMock.expect((Object)this.druidServer3.getSegment((String)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidServer3});
        EasyMock.expect((Object)this.druidServer4.getName()).andReturn((Object)"4").atLeastOnce();
        EasyMock.expect((Object)this.druidServer4.getTier()).andReturn((Object)"normal").anyTimes();
        EasyMock.expect((Object)this.druidServer4.getCurrSize()).andReturn((Object)30L).atLeastOnce();
        EasyMock.expect((Object)this.druidServer4.getMaxSize()).andReturn((Object)100L).atLeastOnce();
        EasyMock.expect((Object)this.druidServer4.getSegments()).andReturn(this.segmentsMap4).anyTimes();
        EasyMock.expect((Object)this.druidServer4.getSegment((String)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidServer4});
        EasyMock.expect((Object)this.holder1.getServer()).andReturn((Object)this.druidServer1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.holder1});
        EasyMock.expect((Object)this.holder2.getServer()).andReturn((Object)this.druidServer2).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.holder2});
        EasyMock.expect((Object)this.holder3.getServer()).andReturn((Object)this.druidServer3).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.holder3});
        EasyMock.expect((Object)this.holder4.getServer()).andReturn((Object)this.druidServer4).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.holder4});
        ArrayList holderList = Lists.newArrayList();
        holderList.add(this.holder1);
        holderList.add(this.holder2);
        holderList.add(this.holder3);
        holderList.add(this.holder4);
        HashMap segmentCountMap = Maps.newHashMap();
        ReservoirSegmentSampler sampler = new ReservoirSegmentSampler();
        for (int i = 0; i < 5000; ++i) {
            segmentCountMap.put(sampler.getRandomBalancerSegmentHolder((List)holderList).getSegment(), 1);
        }
        for (DataSegment segment : this.segments) {
            Assert.assertEquals(segmentCountMap.get(segment), (Object)new Integer(1));
        }
    }
}

