/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordination;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hive.druid.com.google.common.util.concurrent.FutureCallback;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentChangeRequest;
import org.apache.hive.druid.io.druid.server.coordination.SegmentChangeRequestHistory;
import org.apache.hive.druid.io.druid.server.coordination.SegmentChangeRequestNoop;
import org.apache.hive.druid.io.druid.server.coordination.SegmentChangeRequestsSnapshot;
import org.junit.Assert;
import org.junit.Test;

public class SegmentChangeRequestHistoryTest {
    @Test
    public void testSimple() throws Exception {
        SegmentChangeRequestHistory history = new SegmentChangeRequestHistory();
        Assert.assertEquals((long)0L, (long)history.getLastCounter().getCounter());
        history.addSegmentChangeRequest((DataSegmentChangeRequest)new SegmentChangeRequestNoop());
        Assert.assertEquals((long)1L, (long)history.getLastCounter().getCounter());
        SegmentChangeRequestsSnapshot snapshot = (SegmentChangeRequestsSnapshot)history.getRequestsSince(SegmentChangeRequestHistory.Counter.ZERO).get();
        Assert.assertEquals((long)1L, (long)snapshot.getRequests().size());
        Assert.assertEquals((long)1L, (long)snapshot.getCounter().getCounter());
        history.addSegmentChangeRequest((DataSegmentChangeRequest)new SegmentChangeRequestNoop());
        Assert.assertEquals((long)2L, (long)history.getLastCounter().getCounter());
        snapshot = (SegmentChangeRequestsSnapshot)history.getRequestsSince(snapshot.getCounter()).get();
        Assert.assertEquals((long)1L, (long)snapshot.getRequests().size());
        Assert.assertEquals((long)2L, (long)snapshot.getCounter().getCounter());
        snapshot = (SegmentChangeRequestsSnapshot)history.getRequestsSince(SegmentChangeRequestHistory.Counter.ZERO).get();
        Assert.assertEquals((long)2L, (long)snapshot.getRequests().size());
        Assert.assertEquals((long)2L, (long)snapshot.getCounter().getCounter());
    }

    @Test
    public void testTruncatedHistory() throws Exception {
        SegmentChangeRequestHistory history = new SegmentChangeRequestHistory(2);
        history.addSegmentChangeRequest((DataSegmentChangeRequest)new SegmentChangeRequestNoop());
        SegmentChangeRequestHistory.Counter one = history.getLastCounter();
        history.addSegmentChangeRequest((DataSegmentChangeRequest)new SegmentChangeRequestNoop());
        SegmentChangeRequestHistory.Counter two = history.getLastCounter();
        history.addSegmentChangeRequest((DataSegmentChangeRequest)new SegmentChangeRequestNoop());
        SegmentChangeRequestHistory.Counter three = history.getLastCounter();
        history.addSegmentChangeRequest((DataSegmentChangeRequest)new SegmentChangeRequestNoop());
        SegmentChangeRequestHistory.Counter four = history.getLastCounter();
        Assert.assertTrue((boolean)((SegmentChangeRequestsSnapshot)history.getRequestsSince(SegmentChangeRequestHistory.Counter.ZERO).get()).isResetCounter());
        Assert.assertTrue((boolean)((SegmentChangeRequestsSnapshot)history.getRequestsSince(one).get()).isResetCounter());
        Assert.assertTrue((boolean)((SegmentChangeRequestsSnapshot)history.getRequestsSince(two).get()).isResetCounter());
        SegmentChangeRequestsSnapshot snapshot = (SegmentChangeRequestsSnapshot)history.getRequestsSince(three).get();
        Assert.assertEquals((long)1L, (long)snapshot.getRequests().size());
        Assert.assertEquals((long)4L, (long)snapshot.getCounter().getCounter());
    }

    @Test
    public void testCounterHashMismatch() throws Exception {
        SegmentChangeRequestHistory history = new SegmentChangeRequestHistory(3);
        try {
            history.getRequestsSince(new SegmentChangeRequestHistory.Counter(0L, 1234L)).get();
            Assert.fail();
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof IllegalArgumentException));
        }
        history.addSegmentChangeRequest((DataSegmentChangeRequest)new SegmentChangeRequestNoop());
        SegmentChangeRequestHistory.Counter one = history.getLastCounter();
        history.addSegmentChangeRequest((DataSegmentChangeRequest)new SegmentChangeRequestNoop());
        SegmentChangeRequestHistory.Counter two = history.getLastCounter();
        try {
            history.getRequestsSince(new SegmentChangeRequestHistory.Counter(0L, 1234L)).get();
            Assert.fail();
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof IllegalArgumentException));
        }
        SegmentChangeRequestsSnapshot snapshot = (SegmentChangeRequestsSnapshot)history.getRequestsSince(one).get();
        Assert.assertEquals((long)1L, (long)snapshot.getRequests().size());
        Assert.assertEquals((long)2L, (long)snapshot.getCounter().getCounter());
        try {
            history.getRequestsSince(new SegmentChangeRequestHistory.Counter(1L, 1234L)).get();
            Assert.fail();
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof IllegalArgumentException));
        }
        history.addSegmentChangeRequest((DataSegmentChangeRequest)new SegmentChangeRequestNoop());
        SegmentChangeRequestHistory.Counter three = history.getLastCounter();
        history.addSegmentChangeRequest((DataSegmentChangeRequest)new SegmentChangeRequestNoop());
        SegmentChangeRequestHistory.Counter four = history.getLastCounter();
        snapshot = (SegmentChangeRequestsSnapshot)history.getRequestsSince(two).get();
        Assert.assertEquals((long)2L, (long)snapshot.getRequests().size());
        Assert.assertEquals((long)4L, (long)snapshot.getCounter().getCounter());
        try {
            history.getRequestsSince(new SegmentChangeRequestHistory.Counter(2L, 1234L)).get();
            Assert.fail();
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testCancel() throws Exception {
        SegmentChangeRequestHistory history = new SegmentChangeRequestHistory();
        ListenableFuture future = history.getRequestsSince(SegmentChangeRequestHistory.Counter.ZERO);
        Assert.assertEquals((long)1L, (long)history.waitingFutures.size());
        final AtomicBoolean callbackExcecuted = new AtomicBoolean(false);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<SegmentChangeRequestsSnapshot>(){

            public void onSuccess(SegmentChangeRequestsSnapshot result) {
                callbackExcecuted.set(true);
            }

            public void onFailure(Throwable t) {
                callbackExcecuted.set(true);
            }
        });
        future.cancel(true);
        Assert.assertEquals((long)0L, (long)history.waitingFutures.size());
        Assert.assertFalse((boolean)callbackExcecuted.get());
    }

    @Test
    public void testNonImmediateFuture() throws Exception {
        SegmentChangeRequestHistory history = new SegmentChangeRequestHistory();
        ListenableFuture future = history.getRequestsSince(SegmentChangeRequestHistory.Counter.ZERO);
        Assert.assertFalse((boolean)future.isDone());
        history.addSegmentChangeRequest((DataSegmentChangeRequest)new SegmentChangeRequestNoop());
        SegmentChangeRequestsSnapshot snapshot = (SegmentChangeRequestsSnapshot)future.get(1L, TimeUnit.MINUTES);
        Assert.assertEquals((long)1L, (long)snapshot.getCounter().getCounter());
        Assert.assertEquals((long)1L, (long)snapshot.getRequests().size());
    }

    @Test
    public void testCircularBuffer() throws Exception {
        int i;
        SegmentChangeRequestHistory.CircularBuffer circularBuffer = new SegmentChangeRequestHistory.CircularBuffer(3);
        circularBuffer.add((Object)1);
        Assert.assertEquals((long)1L, (long)circularBuffer.size());
        Assert.assertEquals((long)1L, (long)((Integer)circularBuffer.get(0)).intValue());
        circularBuffer.add((Object)2);
        Assert.assertEquals((long)2L, (long)circularBuffer.size());
        for (i = 0; i < circularBuffer.size(); ++i) {
            Assert.assertEquals((long)(i + 1), (long)((Integer)circularBuffer.get(i)).intValue());
        }
        circularBuffer.add((Object)3);
        Assert.assertEquals((long)3L, (long)circularBuffer.size());
        for (i = 0; i < circularBuffer.size(); ++i) {
            Assert.assertEquals((long)(i + 1), (long)((Integer)circularBuffer.get(i)).intValue());
        }
        circularBuffer.add((Object)4);
        Assert.assertEquals((long)3L, (long)circularBuffer.size());
        for (i = 0; i < circularBuffer.size(); ++i) {
            Assert.assertEquals((long)(i + 2), (long)((Integer)circularBuffer.get(i)).intValue());
        }
        circularBuffer.add((Object)5);
        Assert.assertEquals((long)3L, (long)circularBuffer.size());
        for (i = 0; i < circularBuffer.size(); ++i) {
            Assert.assertEquals((long)(i + 3), (long)((Integer)circularBuffer.get(i)).intValue());
        }
        circularBuffer.add((Object)6);
        Assert.assertEquals((long)3L, (long)circularBuffer.size());
        for (i = 0; i < circularBuffer.size(); ++i) {
            Assert.assertEquals((long)(i + 4), (long)((Integer)circularBuffer.get(i)).intValue());
        }
        circularBuffer.add((Object)7);
        Assert.assertEquals((long)3L, (long)circularBuffer.size());
        for (i = 0; i < circularBuffer.size(); ++i) {
            Assert.assertEquals((long)(i + 5), (long)((Integer)circularBuffer.get(i)).intValue());
        }
        circularBuffer.add((Object)8);
        Assert.assertEquals((long)3L, (long)circularBuffer.size());
        for (i = 0; i < circularBuffer.size(); ++i) {
            Assert.assertEquals((long)(i + 6), (long)((Integer)circularBuffer.get(i)).intValue());
        }
    }
}

