/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.loading.LocalDataSegmentPuller;
import org.apache.hive.druid.io.druid.segment.loading.LocalLoadSpec;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoaderConfig;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoaderLocalCacheManager;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.io.druid.segment.loading.StorageLocationConfig;
import org.apache.hive.druid.io.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.hive.druid.io.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.hive.druid.io.druid.server.metrics.NoopServiceEmitter;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SegmentLoaderLocalCacheManagerTest {
    @Rule
    public final TemporaryFolder tmpFolder = new TemporaryFolder();
    private final ObjectMapper jsonMapper = new DefaultObjectMapper();
    private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;
    private File localSegmentCacheFolder;
    private SegmentLoaderLocalCacheManager manager;

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() throws IOException {
        return ImmutableList.of((Object)new Object[]{TmpFileSegmentWriteOutMediumFactory.instance()}, (Object)new Object[]{OffHeapMemorySegmentWriteOutMediumFactory.instance()});
    }

    public SegmentLoaderLocalCacheManagerTest(SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        this.jsonMapper.registerSubtypes(new NamedType[]{new NamedType(LocalLoadSpec.class, "local")});
        this.jsonMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(LocalDataSegmentPuller.class, (Object)new LocalDataSegmentPuller()));
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
    }

    @Before
    public void setUp() throws Exception {
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        this.localSegmentCacheFolder = this.tmpFolder.newFolder("segment_cache_folder");
        ArrayList locations = Lists.newArrayList();
        StorageLocationConfig locationConfig = new StorageLocationConfig();
        locationConfig.setPath(this.localSegmentCacheFolder);
        locationConfig.setMaxSize(10000000000L);
        locations.add(locationConfig);
        this.manager = new SegmentLoaderLocalCacheManager(TestHelper.getTestIndexIO(this.segmentWriteOutMediumFactory), new SegmentLoaderConfig().withLocations((List)locations), this.jsonMapper);
    }

    @Test
    public void testIfSegmentIsLoaded() throws Exception {
        DataSegment cachedSegment = this.dataSegmentWithInterval("2014-10-20T00:00:00Z/P1D");
        File cachedSegmentFile = new File(this.localSegmentCacheFolder, "test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        cachedSegmentFile.mkdirs();
        Assert.assertTrue((String)"Expect cache hit", (boolean)this.manager.isSegmentLoaded(cachedSegment));
        DataSegment uncachedSegment = this.dataSegmentWithInterval("2014-10-21T00:00:00Z/P1D");
        Assert.assertFalse((String)"Expect cache miss", (boolean)this.manager.isSegmentLoaded(uncachedSegment));
    }

    @Test
    public void testGetAndCleanSegmentFiles() throws Exception {
        File localStorageFolder = this.tmpFolder.newFolder("local_storage_folder");
        DataSegment segmentToDownload = this.dataSegmentWithInterval("2014-10-20T00:00:00Z/P1D").withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(localStorageFolder.getCanonicalPath() + "/test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        File localSegmentFile = new File(localStorageFolder, "test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        localSegmentFile.mkdirs();
        File indexZip = new File(localSegmentFile, "index.zip");
        indexZip.createNewFile();
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        this.manager.getSegmentFiles(segmentToDownload);
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        this.manager.cleanup(segmentToDownload);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
    }

    @Test
    public void testRetrySuccessAtFirstLocation() throws Exception {
        File localStorageFolder = this.tmpFolder.newFolder("local_storage_folder");
        ArrayList locations = Lists.newArrayList();
        StorageLocationConfig locationConfig = new StorageLocationConfig();
        locationConfig.setPath(localStorageFolder);
        locationConfig.setMaxSize(10000000000L);
        locations.add(locationConfig);
        StorageLocationConfig locationConfig2 = new StorageLocationConfig();
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder2");
        locationConfig2.setPath(localStorageFolder2);
        locationConfig2.setMaxSize(1000000000L);
        locations.add(locationConfig2);
        this.manager = new SegmentLoaderLocalCacheManager(TestHelper.getTestIndexIO(this.segmentWriteOutMediumFactory), new SegmentLoaderConfig().withLocations((List)locations), this.jsonMapper);
        File segmentSrcFolder = this.tmpFolder.newFolder("segmentSrcFolder");
        DataSegment segmentToDownload = this.dataSegmentWithInterval("2014-10-20T00:00:00Z/P1D").withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        File localSegmentFile = new File(segmentSrcFolder, "test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        localSegmentFile.mkdirs();
        File indexZip = new File(localSegmentFile, "index.zip");
        indexZip.createNewFile();
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        File segmentFile = this.manager.getSegmentFiles(segmentToDownload);
        Assert.assertTrue((boolean)segmentFile.getAbsolutePath().contains("/local_storage_folder/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        this.manager.cleanup(segmentToDownload);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
    }

    @Test
    public void testRetrySuccessAtSecondLocation() throws Exception {
        ArrayList locations = Lists.newArrayList();
        StorageLocationConfig locationConfig = new StorageLocationConfig();
        File localStorageFolder = this.tmpFolder.newFolder("local_storage_folder");
        localStorageFolder.setWritable(false);
        locationConfig.setPath(localStorageFolder);
        locationConfig.setMaxSize(1000000000L);
        locations.add(locationConfig);
        StorageLocationConfig locationConfig2 = new StorageLocationConfig();
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder2");
        locationConfig2.setPath(localStorageFolder2);
        locationConfig2.setMaxSize(10000000L);
        locations.add(locationConfig2);
        this.manager = new SegmentLoaderLocalCacheManager(TestHelper.getTestIndexIO(this.segmentWriteOutMediumFactory), new SegmentLoaderConfig().withLocations((List)locations), this.jsonMapper);
        File segmentSrcFolder = this.tmpFolder.newFolder("segmentSrcFolder");
        DataSegment segmentToDownload = this.dataSegmentWithInterval("2014-10-20T00:00:00Z/P1D").withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        File localSegmentFile = new File(segmentSrcFolder, "test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        localSegmentFile.mkdirs();
        File indexZip = new File(localSegmentFile, "index.zip");
        indexZip.createNewFile();
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        File segmentFile = this.manager.getSegmentFiles(segmentToDownload);
        Assert.assertTrue((boolean)segmentFile.getAbsolutePath().contains("/local_storage_folder2/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        this.manager.cleanup(segmentToDownload);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
    }

    @Test
    public void testRetryAllFail() throws Exception {
        ArrayList locations = Lists.newArrayList();
        StorageLocationConfig locationConfig = new StorageLocationConfig();
        File localStorageFolder = this.tmpFolder.newFolder("local_storage_folder");
        localStorageFolder.setWritable(false);
        locationConfig.setPath(localStorageFolder);
        locationConfig.setMaxSize(1000000000L);
        locations.add(locationConfig);
        StorageLocationConfig locationConfig2 = new StorageLocationConfig();
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder2");
        localStorageFolder2.setWritable(false);
        locationConfig2.setPath(localStorageFolder2);
        locationConfig2.setMaxSize(10000000L);
        locations.add(locationConfig2);
        this.manager = new SegmentLoaderLocalCacheManager(TestHelper.getTestIndexIO(this.segmentWriteOutMediumFactory), new SegmentLoaderConfig().withLocations((List)locations), this.jsonMapper);
        File segmentSrcFolder = this.tmpFolder.newFolder("segmentSrcFolder");
        DataSegment segmentToDownload = this.dataSegmentWithInterval("2014-10-20T00:00:00Z/P1D").withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        File localSegmentFile = new File(segmentSrcFolder, "test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        localSegmentFile.mkdirs();
        File indexZip = new File(localSegmentFile, "index.zip");
        indexZip.createNewFile();
        try {
            this.manager.getSegmentFiles(segmentToDownload);
            Assert.fail();
        }
        catch (SegmentLoadingException segmentLoadingException) {
            // empty catch block
        }
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        this.manager.cleanup(segmentToDownload);
    }

    @Test
    public void testEmptyToFullOrder() throws Exception {
        ArrayList locations = Lists.newArrayList();
        StorageLocationConfig locationConfig = new StorageLocationConfig();
        File localStorageFolder = this.tmpFolder.newFolder("local_storage_folder");
        localStorageFolder.setWritable(true);
        locationConfig.setPath(localStorageFolder);
        locationConfig.setMaxSize(10L);
        locations.add(locationConfig);
        StorageLocationConfig locationConfig2 = new StorageLocationConfig();
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder2");
        localStorageFolder2.setWritable(true);
        locationConfig2.setPath(localStorageFolder2);
        locationConfig2.setMaxSize(10L);
        locations.add(locationConfig2);
        this.manager = new SegmentLoaderLocalCacheManager(TestHelper.getTestIndexIO(this.segmentWriteOutMediumFactory), new SegmentLoaderConfig().withLocations((List)locations), this.jsonMapper);
        File segmentSrcFolder = this.tmpFolder.newFolder("segmentSrcFolder");
        DataSegment segmentToDownload = this.dataSegmentWithInterval("2014-10-20T00:00:00Z/P1D").withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        File localSegmentFile = new File(segmentSrcFolder, "test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        localSegmentFile.mkdirs();
        File indexZip = new File(localSegmentFile, "index.zip");
        indexZip.createNewFile();
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        File segmentFile = this.manager.getSegmentFiles(segmentToDownload);
        Assert.assertTrue((boolean)segmentFile.getAbsolutePath().contains("/local_storage_folder/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        DataSegment segmentToDownload2 = this.dataSegmentWithInterval("2014-11-20T00:00:00Z/P1D").withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-11-20T00:00:00.000Z_2014-11-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        File localSegmentFile2 = new File(segmentSrcFolder, "test_segment_loader/2014-11-20T00:00:00.000Z_2014-11-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        localSegmentFile2.mkdirs();
        File indexZip2 = new File(localSegmentFile2, "index.zip");
        indexZip2.createNewFile();
        File segmentFile2 = this.manager.getSegmentFiles(segmentToDownload2);
        Assert.assertTrue((boolean)segmentFile2.getAbsolutePath().contains("/local_storage_folder2/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload2));
        this.manager.cleanup(segmentToDownload2);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload2));
    }

    private DataSegment dataSegmentWithInterval(String intervalStr) {
        return DataSegment.builder().dataSource("test_segment_loader").interval(Intervals.of((String)intervalStr)).loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)"somewhere")).version("2015-05-27T03:38:35.683Z").dimensions((List)ImmutableList.of()).metrics((List)ImmutableList.of()).shardSpec((ShardSpec)NoneShardSpec.instance()).binaryVersion(Integer.valueOf(9)).size(10L).build();
    }
}

